/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.shell.aargparse.impl.converter;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import oracle.pgx.shell.aargparse.Argument;
import oracle.pgx.shell.aargparse.ArgumentConverter;
import oracle.pgx.shell.aargparse.ArgumentParser;

public class ReflectionConverter<T>
implements ArgumentConverter<T> {
    private final Class<T> expectedClass;
    private final boolean isEnum;
    private final boolean hasValueOfMethod;
    private final Method valueOfMethod;
    private final Constructor<T> conversionConstructor;

    public ReflectionConverter(Class<T> expectedClass) {
        Constructor<T> conversionConstructor;
        this.expectedClass = expectedClass;
        if (this.expectedClass.isEnum()) {
            this.isEnum = true;
            this.hasValueOfMethod = false;
            this.valueOfMethod = null;
            this.conversionConstructor = null;
            return;
        }
        this.isEnum = false;
        Method m = null;
        try {
            m = this.expectedClass.getMethod("valueOf", String.class);
            if (!Modifier.isStatic(m.getModifiers()) || !this.expectedClass.isAssignableFrom(m.getReturnType())) {
                m = null;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        this.hasValueOfMethod = m != null;
        this.valueOfMethod = m;
        try {
            conversionConstructor = this.expectedClass.getConstructor(String.class);
        }
        catch (NoSuchMethodException e) {
            conversionConstructor = null;
        }
        this.conversionConstructor = conversionConstructor;
    }

    @Override
    public T convert(ArgumentParser parser, Argument arg, String value) {
        if (this.isEnum) {
            try {
                return Enum.valueOf(this.expectedClass, value);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("cannot convert enumeration");
            }
        }
        if (this.hasValueOfMethod) {
            try {
                return (T)this.valueOfMethod.invoke(null, value);
            }
            catch (IllegalAccessException e) {
                return this.convertUsingConstructor(parser, arg, value);
            }
            catch (IllegalArgumentException e) {
                this.handleInstantiationError(e);
            }
            catch (InvocationTargetException e) {
                this.throwArgumentParserException(e);
            }
            return null;
        }
        return this.convertUsingConstructor(parser, arg, value);
    }

    private T convertUsingConstructor(ArgumentParser parser, Argument arg, String value) {
        if (this.conversionConstructor == null) {
            this.handleInstantiationError(null);
        }
        try {
            return this.conversionConstructor.newInstance(value);
        }
        catch (IllegalAccessException | InstantiationException e) {
            this.handleInstantiationError(e);
        }
        catch (InvocationTargetException e) {
            this.throwArgumentParserException(e);
        }
        return null;
    }

    private void throwArgumentParserException(InvocationTargetException e) {
        throw new IllegalStateException("exception when calling parsing constructor", e);
    }

    private void handleInstantiationError(Exception e) {
        throw new IllegalArgumentException("reflect type conversion error", e);
    }
}

