/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.shell.aargparse;

import java.util.Objects;
import oracle.pgx.shell.aargparse.ArgumentConverter;
import oracle.pgx.shell.aargparse.impl.converter.FileConverter;
import oracle.pgx.shell.aargparse.impl.converter.PrimitiveConverter;
import oracle.pgx.shell.aargparse.impl.converter.ReflectionConverter;

public class Converters {
    private static final ArgumentConverter<?> INT_CONVERTER = new PrimitiveConverter.PrimitiveIntegerConverter();
    private static final ArgumentConverter<?> LONG_CONVERTER = new PrimitiveConverter.PrimitiveLongConverter();
    private static final ArgumentConverter<?> STRING_CONVERTER = new PrimitiveConverter.PrimitiveStringConverter();
    private static final ArgumentConverter<?> BOOLEAN_CONVERTER = new PrimitiveConverter.PrimitiveBooleanConverter();

    public static ArgumentConverter<?> converterFor(Class<?> expectedClazz) {
        if (Objects.equals(expectedClazz, Integer.TYPE)) {
            return INT_CONVERTER;
        }
        if (Objects.equals(expectedClazz, Long.TYPE)) {
            return LONG_CONVERTER;
        }
        if (Objects.equals(expectedClazz, String.class)) {
            return STRING_CONVERTER;
        }
        if (Objects.equals(expectedClazz, Boolean.TYPE)) {
            return BOOLEAN_CONVERTER;
        }
        return new ReflectionConverter(expectedClazz);
    }

    public static FileConverter fileType() {
        return new FileConverter();
    }
}

