/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.internal.onprem;

import com.nimbusds.jwt.JWT;
import java.text.ParseException;
import oracle.pg.rdbms.internal.AbstractRealmClient;
import oracle.pg.rdbms.internal.onprem.GraphServerClient;
import org.apache.hc.client5.http.cookie.Cookie;

public class GraphRealmClient
extends AbstractRealmClient {
    private final GraphServerClient client;
    private final String endpoint;
    private final Cookie clientStickyCookie;
    private static final String REFRESH_TIME_BEFORE_EXPIRY = "refresh_time_before_token_expiry_seconds";

    public GraphRealmClient(GraphServerClient client, String endpoint, String token, Cookie clientStickyCookie) {
        super(token);
        this.client = client;
        this.endpoint = endpoint;
        this.clientStickyCookie = clientStickyCookie;
    }

    @Override
    protected final long getRefreshTimeBeforeTokenExpiry(JWT jwt) {
        try {
            Integer refreshTimeFromJwt = jwt.getJWTClaimsSet().getIntegerClaim(REFRESH_TIME_BEFORE_EXPIRY);
            return refreshTimeFromJwt != null ? (long)refreshTimeFromJwt.intValue() : 1800L;
        }
        catch (NullPointerException | ParseException e) {
            throw new IllegalArgumentException("Could not retrieve refresh_time_before_token_expiry_seconds from token: ", e);
        }
    }

    @Override
    protected String refreshToken(String token) {
        return this.client.refreshToken(this.endpoint, token).getToken();
    }

    public Cookie getPgxInstanceStickyCookie() {
        return this.clientStickyCookie;
    }
}

