/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.terms;

import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoString;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermPrinter;
import org.spoofax.interpreter.terms.TermType;
import org.spoofax.terms.StrategoTerm;
import org.spoofax.terms.TermFactory;
import org.spoofax.terms.util.EmptyIterator;
import org.spoofax.terms.util.StringUtils;
import org.spoofax.terms.util.TermUtils;

public class StrategoString
extends StrategoTerm
implements IStrategoString {
    private static final long serialVersionUID = 237308007762215350L;
    private final String value;

    public StrategoString(String value, @Nullable IStrategoList annotations) {
        super(annotations);
        this.value = value;
        this.initImmutableHashCode();
    }

    protected StrategoString(String value) {
        this(value, TermFactory.EMPTY_LIST);
    }

    @Override
    public IStrategoTerm getSubterm(int index) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public IStrategoTerm[] getAllSubterms() {
        return TermFactory.EMPTY_TERM_ARRAY;
    }

    @Override
    public List<IStrategoTerm> getSubterms() {
        return Collections.emptyList();
    }

    @Override
    public int getSubtermCount() {
        return 0;
    }

    @Override
    public TermType getType() {
        return TermType.STRING;
    }

    @Override
    protected boolean doSlowMatch(IStrategoTerm second) {
        IStrategoList secondAnnotations;
        String secondValue;
        if (!TermUtils.isString(second)) {
            return false;
        }
        String value = this.stringValue();
        if (!value.equals(secondValue = ((IStrategoString)second).stringValue())) {
            return false;
        }
        IStrategoList annotations = this.getAnnotations();
        if (annotations == (secondAnnotations = second.getAnnotations())) {
            return true;
        }
        return annotations.match(secondAnnotations);
    }

    @Override
    public String stringValue() {
        return this.value;
    }

    @Override
    public String getName() {
        return this.value;
    }

    @Override
    @Deprecated
    public void prettyPrint(ITermPrinter pp) {
        pp.print("\"");
        pp.print(StringUtils.escape(this.stringValue()));
        pp.print("\"");
        this.printAnnotations(pp);
    }

    @Override
    public void writeAsString(Appendable output, int maxDepth) throws IOException {
        output.append("\"");
        StringUtils.appendEscape(this.stringValue(), output);
        output.append("\"");
        this.appendAnnotations(output, maxDepth);
    }

    @Override
    public int hashFunction() {
        return this.stringValue().hashCode();
    }

    @Override
    public Iterator<IStrategoTerm> iterator() {
        return new EmptyIterator<IStrategoTerm>();
    }
}

