/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.terms;

import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermPrinter;
import org.spoofax.interpreter.terms.TermType;
import org.spoofax.terms.StrategoTerm;
import org.spoofax.terms.TermList;
import org.spoofax.terms.util.ArrayIterator;
import org.spoofax.terms.util.TermUtils;

public class StrategoAppl
extends StrategoTerm
implements IStrategoAppl {
    private static final long serialVersionUID = -2522680523775044390L;
    private final IStrategoConstructor ctor;
    private final IStrategoTerm[] kids;

    public StrategoAppl(IStrategoConstructor ctor, IStrategoTerm[] kids, @Nullable IStrategoList annotations) {
        super(annotations);
        this.ctor = ctor;
        this.kids = kids;
    }

    @Deprecated
    public IStrategoTerm[] getArguments() {
        return this.kids;
    }

    @Override
    public IStrategoConstructor getConstructor() {
        return this.ctor;
    }

    @Override
    public String getName() {
        return this.ctor.getName();
    }

    @Override
    public List<IStrategoTerm> getSubterms() {
        return TermList.ofUnsafe(this.kids);
    }

    @Override
    public IStrategoTerm getSubterm(int index) {
        if (index < 0 || index >= this.kids.length) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + index);
        }
        return this.kids[index];
    }

    @Override
    public IStrategoTerm[] getAllSubterms() {
        return this.kids;
    }

    @Override
    public int getSubtermCount() {
        return this.kids.length;
    }

    @Override
    public TermType getType() {
        return TermType.APPL;
    }

    @Override
    protected boolean doSlowMatch(IStrategoTerm second) {
        IStrategoList secondAnnotations;
        IStrategoList annotations;
        Object[] secondKids;
        if (!TermUtils.isAppl(second)) {
            return false;
        }
        IStrategoAppl o = (IStrategoAppl)second;
        if (!this.ctor.equals(o.getConstructor())) {
            return false;
        }
        Object[] kids = this.getAllSubterms();
        if (kids.length != (secondKids = o.getAllSubterms()).length) {
            return false;
        }
        if (!Arrays.equals(kids, secondKids)) {
            int i = 0;
            int sz = kids.length;
            while (i < sz) {
                Object kid = kids[i];
                Object secondKid = secondKids[i];
                if (kid != secondKid && !kid.match((IStrategoTerm)secondKid)) {
                    return false;
                }
                ++i;
            }
        }
        if ((annotations = this.getAnnotations()) == (secondAnnotations = second.getAnnotations())) {
            return true;
        }
        return annotations.match(secondAnnotations);
    }

    @Override
    @Deprecated
    public void prettyPrint(ITermPrinter pp) {
        pp.print(this.ctor.getName());
        IStrategoTerm[] kids = this.getAllSubterms();
        if (kids.length > 0) {
            pp.println("(");
            pp.indent(this.ctor.getName().length());
            kids[0].prettyPrint(pp);
            int i = 1;
            while (i < kids.length) {
                pp.print(",");
                kids[i].prettyPrint(pp);
                ++i;
            }
            pp.println(")");
            pp.outdent(this.ctor.getName().length());
        }
        this.printAnnotations(pp);
    }

    @Override
    public void writeAsString(Appendable output, int maxDepth) throws IOException {
        output.append(this.ctor.getName());
        IStrategoTerm[] kids = this.getAllSubterms();
        if (kids.length > 0) {
            output.append('(');
            if (maxDepth == 0) {
                output.append("...");
            } else {
                kids[0].writeAsString(output, maxDepth - 1);
                int i = 1;
                while (i < kids.length) {
                    output.append(',');
                    kids[i].writeAsString(output, maxDepth - 1);
                    ++i;
                }
            }
            output.append(')');
        }
        this.appendAnnotations(output, maxDepth);
    }

    @Override
    public int hashFunction() {
        long r = this.ctor.hashCode();
        int accum = 6673;
        IStrategoTerm[] kids = this.getAllSubterms();
        int i = 0;
        while (i < kids.length) {
            r += (long)(kids[i].hashCode() * accum);
            accum *= 7703;
            ++i;
        }
        return (int)(r >> 12);
    }

    @Override
    public Iterator<IStrategoTerm> iterator() {
        return new ArrayIterator<IStrategoTerm>(this.kids);
    }
}

