/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr2.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.interpreter.terms.TermType;
import org.spoofax.terms.TermFactory;

public class AstUtilities {
    private ITermFactory termFactory = new TermFactory();

    public List<IStrategoTerm> expand(IStrategoTerm ast) {
        ArrayList<IStrategoTerm> result = new ArrayList<IStrategoTerm>();
        switch (ast.getType()) {
            case APPL: {
                IStrategoAppl appl = (IStrategoAppl)ast;
                IStrategoConstructor constructor = appl.getConstructor();
                if ("amb".equals(constructor.getName())) {
                    IStrategoTerm[] iStrategoTermArray = appl.getSubterm(0).getAllSubterms();
                    int n = iStrategoTermArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IStrategoTerm subAst = iStrategoTermArray[n2];
                        result.addAll(this.expand(subAst));
                        ++n2;
                    }
                } else {
                    for (List<IStrategoTerm> subAsts : this.expandSubterms(appl)) {
                        result.add(this.termFactory.makeAppl(constructor, subAsts.toArray(new IStrategoTerm[subAsts.size()])));
                    }
                }
                break;
            }
            case LIST: {
                for (List<IStrategoTerm> subAsts : this.expandSubterms(ast)) {
                    result.add(this.termFactory.makeList(subAsts.toArray(new IStrategoTerm[subAsts.size()])));
                }
                break;
            }
            case TUPLE: {
                for (List<IStrategoTerm> subAsts : this.expandSubterms(ast)) {
                    result.add(this.termFactory.makeTuple(subAsts.toArray(new IStrategoTerm[subAsts.size()])));
                }
                break;
            }
            default: {
                result.add(ast);
            }
        }
        return result;
    }

    private List<List<IStrategoTerm>> expandSubterms(IStrategoTerm astWithSubAsts) {
        ArrayList expandedSubAsts = new ArrayList(astWithSubAsts.getSubtermCount());
        IStrategoTerm[] iStrategoTermArray = astWithSubAsts.getAllSubterms();
        int n = iStrategoTermArray.length;
        int n2 = 0;
        while (n2 < n) {
            IStrategoTerm subAst = iStrategoTermArray[n2];
            expandedSubAsts.add(this.expand(subAst));
            ++n2;
        }
        return this.expand(expandedSubAsts);
    }

    public <T> List<List<T>> expand(List<List<T>> elements) {
        if (elements.isEmpty()) {
            return Arrays.asList(Arrays.asList(new Object[0]));
        }
        ArrayList<List<T>> results = new ArrayList<List<T>>();
        List<T> head = elements.get(0);
        List<List<T>> tail = elements.subList(1, elements.size());
        List<List<T>> tailExpansions = this.expand(tail);
        for (T headElement : head) {
            for (List<T> tailExpansion : tailExpansions) {
                ArrayList<T> result = new ArrayList<T>();
                result.add(headElement);
                result.addAll(tailExpansion);
                results.add(result);
            }
        }
        return results;
    }

    public int ambCount(IStrategoTerm ast) {
        int result = 0;
        switch (ast.getType()) {
            case APPL: {
                IStrategoAppl appl = (IStrategoAppl)ast;
                IStrategoConstructor constructor = appl.getConstructor();
                if ("amb".equals(constructor.getName())) {
                    ++result;
                    IStrategoTerm[] iStrategoTermArray = appl.getSubterm(0).getAllSubterms();
                    int n = iStrategoTermArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IStrategoTerm subAst = iStrategoTermArray[n2];
                        result += this.ambCount(subAst);
                        ++n2;
                    }
                } else {
                    IStrategoTerm[] iStrategoTermArray = appl.getAllSubterms();
                    int n = iStrategoTermArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        IStrategoTerm subAst = iStrategoTermArray[n3];
                        result += this.ambCount(subAst);
                        ++n3;
                    }
                }
                break;
            }
            case LIST: 
            case TUPLE: {
                IStrategoTerm[] iStrategoTermArray = ast.getAllSubterms();
                int n = iStrategoTermArray.length;
                int n4 = 0;
                while (n4 < n) {
                    IStrategoTerm subAst = iStrategoTermArray[n4];
                    result += this.ambCount(subAst);
                    ++n4;
                }
                break;
            }
        }
        return result;
    }

    public int ambCountShared(IStrategoTerm ast) {
        HashSet<IStrategoAppl> ambs = new HashSet<IStrategoAppl>();
        this.ambCountShared(ast, ambs);
        return ambs.size();
    }

    private void ambCountShared(IStrategoTerm ast, Set<IStrategoAppl> ambs) {
        switch (ast.getType()) {
            case APPL: {
                IStrategoAppl appl = (IStrategoAppl)ast;
                IStrategoConstructor constructor = appl.getConstructor();
                if ("amb".equals(constructor.getName())) {
                    ambs.add(appl);
                    IStrategoTerm[] iStrategoTermArray = appl.getSubterm(0).getAllSubterms();
                    int n = iStrategoTermArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IStrategoTerm subAst = iStrategoTermArray[n2];
                        this.ambCountShared(subAst, ambs);
                        ++n2;
                    }
                } else {
                    IStrategoTerm[] iStrategoTermArray = appl.getAllSubterms();
                    int n = iStrategoTermArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        IStrategoTerm subAst = iStrategoTermArray[n3];
                        this.ambCountShared(subAst, ambs);
                        ++n3;
                    }
                }
                break;
            }
            case LIST: 
            case TUPLE: {
                IStrategoTerm[] iStrategoTermArray = ast.getAllSubterms();
                int n = iStrategoTermArray.length;
                int n4 = 0;
                while (n4 < n) {
                    IStrategoTerm subAst = iStrategoTermArray[n4];
                    this.ambCountShared(subAst, ambs);
                    ++n4;
                }
                break;
            }
        }
    }

    public IStrategoTerm ambFlatten(IStrategoTerm ast) {
        switch (ast.getType()) {
            case APPL: {
                IStrategoAppl appl = (IStrategoAppl)ast;
                IStrategoConstructor constructor = appl.getConstructor();
                if ("amb".equals(constructor.getName())) {
                    ArrayList<IStrategoTerm> flattenSubAsts = new ArrayList<IStrategoTerm>();
                    IStrategoTerm[] iStrategoTermArray = appl.getSubterm(0).getAllSubterms();
                    int n = iStrategoTermArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IStrategoTerm subAst = iStrategoTermArray[n2];
                        IStrategoTerm flattenSubAst = this.ambFlatten(subAst);
                        if (TermType.APPL == subAst.getType()) {
                            IStrategoAppl flattenSubAppl = (IStrategoAppl)subAst;
                            IStrategoConstructor flattenSubConstructor = flattenSubAppl.getConstructor();
                            if ("amb".equals(flattenSubConstructor.getName())) {
                                flattenSubAsts.addAll(Arrays.asList(flattenSubAppl.getSubterm(0).getAllSubterms()));
                            } else {
                                flattenSubAsts.add(flattenSubAst);
                            }
                        } else {
                            flattenSubAsts.add(flattenSubAst);
                        }
                        ++n2;
                    }
                    return this.termFactory.makeAppl(constructor, this.termFactory.makeList(flattenSubAsts.toArray(new IStrategoTerm[flattenSubAsts.size()])));
                }
                return ast;
            }
        }
        return ast;
    }
}

