/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr.client.incremental;

import java.util.Iterator;
import java.util.Set;
import mb.jsglr.shared.AbstractTokenizer;
import mb.jsglr.shared.IToken;
import mb.jsglr.shared.ImploderAttachment;
import org.spoofax.interpreter.terms.ISimpleTerm;
import org.spoofax.jsglr.client.incremental.DamageRegionAnalyzer;
import org.spoofax.jsglr.client.incremental.IncrementalSGLR;
import org.spoofax.jsglr.client.incremental.IncrementalSGLRException;
import org.spoofax.jsglr.client.incremental.IncrementalSortSet;
import org.spoofax.terms.SimpleTermVisitor;

public class IncrementalInputBuilder {
    private static final boolean INSERT_WHITESPACE = false;
    private final StringBuilder result = new StringBuilder();
    private final Set<ISimpleTerm> damageNodes;
    private final IncrementalSortSet incrementalSorts;
    private final String newInput;
    private final String oldInput;
    private final int damageStart;
    private final int damageEnd;
    private final int damageSizeChange;
    private boolean isSkipping;
    private boolean isDamagePrinted;
    private int skippedCharsBeforeDamage;
    private int skippedCharsAfterDamage;

    public IncrementalInputBuilder(DamageRegionAnalyzer damageAnalyzer, Set<ISimpleTerm> damageNodes, String input, String oldInput) {
        this.damageNodes = damageNodes;
        this.incrementalSorts = damageAnalyzer.incrementalSorts;
        this.newInput = input;
        this.oldInput = oldInput;
        this.damageEnd = damageAnalyzer.damageEnd;
        this.damageStart = damageAnalyzer.damageStart;
        this.damageSizeChange = damageAnalyzer.damageSizeChange;
    }

    public String buildPartialInput(ISimpleTerm oldTree) throws IncrementalSGLRException {
        this.result.setLength(0);
        this.isDamagePrinted = false;
        this.isSkipping = false;
        this.skippedCharsBeforeDamage = 0;
        this.skippedCharsAfterDamage = 0;
        this.appendTree(oldTree, false);
        try {
            assert (this.result.length() == this.newInput.length() - this.skippedCharsBeforeDamage - this.skippedCharsAfterDamage);
            String string = this.result.toString();
            return string;
        }
        finally {
            if (IncrementalSGLR.DEBUG) {
                System.out.println();
            }
        }
    }

    public int getLastSkippedCharsBeforeDamage() {
        return this.skippedCharsBeforeDamage;
    }

    private boolean appendTree(ISimpleTerm oldTree, boolean disallowSkipping) throws IncrementalSGLRException {
        IToken left = ImploderAttachment.getLeftToken(oldTree);
        IToken right = ImploderAttachment.getRightToken(oldTree);
        int startOffset = 0;
        int endOffset = 0;
        boolean isSkippingStart = false;
        boolean disallowSkippingStart = false;
        if (left != null && right != null) {
            startOffset = left.getStartOffset();
            endOffset = right.getEndOffset();
            if (this.damageNodes.contains(oldTree)) {
                disallowSkippingStart = true;
                disallowSkipping = true;
            } else if (!disallowSkipping && !this.isSkipping && this.isSkippableNode(oldTree, startOffset, endOffset)) {
                isSkippingStart = true;
                this.isSkipping = true;
            }
            boolean wasSkipped = false;
            Iterator<ISimpleTerm> iterator = SimpleTermVisitor.tryGetListIterator(oldTree);
            int i = 0;
            int max2 = oldTree.getSubtermCount();
            while (i < max2) {
                ISimpleTerm child = iterator == null ? oldTree.getSubterm(i) : iterator.next();
                IToken childLeft = ImploderAttachment.getLeftToken(child);
                IToken childRight = ImploderAttachment.getRightToken(child);
                if (childLeft != null) {
                    this.appendToken(startOffset, childLeft.getStartOffset() - 1);
                }
                if (wasSkipped) {
                    this.isSkipping = false;
                }
                boolean bl = wasSkipped = !this.appendTree(child, disallowSkipping);
                if (childRight != null) {
                    startOffset = childRight.getEndOffset() + 1;
                }
                ++i;
            }
            this.appendToken(startOffset, endOffset);
            if (wasSkipped) {
                this.isSkipping = false;
            }
        } else assert (oldTree.getSubtermCount() == 0) : "No tokens for tree with children??";
        if (disallowSkippingStart) {
            disallowSkipping = false;
        }
        return !isSkippingStart;
    }

    private boolean isSkippableNode(ISimpleTerm oldTree, int startOffset, int endOffset) {
        return !oldTree.isList() && this.incrementalSorts.isIncrementalNode(oldTree) && !IncrementalSGLR.isRangeOverlap(this.damageStart, this.damageEnd, startOffset, endOffset) && !AbstractTokenizer.isErrorInRange(ImploderAttachment.getLeftToken(oldTree), ImploderAttachment.getRightToken(oldTree));
    }

    private void appendToken(int startOffset, int endOffset) {
        if (this.isDamagePrinted) {
            assert (startOffset >= this.damageStart);
            if (endOffset > this.damageEnd) {
                int newStartOffset = Math.max(this.damageEnd + this.damageSizeChange + 1, startOffset + this.damageSizeChange);
                this.internalAppendSubstring(newStartOffset, endOffset + this.damageSizeChange + 1);
            }
        } else if (endOffset >= this.damageStart) {
            int tokenLength = endOffset - startOffset + 1;
            int charsBeforeDamage = this.damageStart - startOffset;
            int charsAfterDamage = Math.max(0, endOffset - this.damageEnd);
            assert (charsBeforeDamage + charsAfterDamage <= tokenLength && Math.min(charsBeforeDamage, charsAfterDamage) >= 0);
            if (IncrementalSGLR.DEBUG) {
                System.out.print('|');
            }
            this.internalAppendSubstring(startOffset, startOffset + charsBeforeDamage);
            if (IncrementalSGLR.DEBUG) {
                System.out.print('$');
            }
            this.internalAppendSubstring(this.damageStart, this.damageEnd + this.damageSizeChange + 1);
            if (IncrementalSGLR.DEBUG) {
                System.out.print('$');
            }
            this.internalAppendSubstring(this.damageEnd + this.damageSizeChange + 1, this.damageEnd + this.damageSizeChange + 1 + charsAfterDamage);
            if (IncrementalSGLR.DEBUG) {
                System.out.print('|');
            }
            this.isDamagePrinted = true;
        } else {
            this.internalAppendSubstring(startOffset, endOffset + 1);
        }
    }

    private void internalAppendSubstring(int startIndex, int endIndex) {
        if (this.isSkipping) {
            int i = startIndex;
            while (i < endIndex) {
                if (this.newInput.charAt(i) == '\n') {
                    this.result.append('\n');
                } else if (i < this.damageStart) {
                    ++this.skippedCharsBeforeDamage;
                } else {
                    ++this.skippedCharsAfterDamage;
                }
                ++i;
            }
        } else {
            if (IncrementalSGLR.DEBUG) {
                System.out.print(this.newInput.substring(startIndex, endIndex));
            }
            this.result.append(this.newInput, startIndex, endIndex);
        }
    }
}

