/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr.client;

import java.util.List;
import mb.jsglr.shared.ITokenizer;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoString;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.jsglr.client.BottomupTreeBuilder;
import org.spoofax.jsglr.client.ParseTable;
import org.spoofax.terms.TermFactory;

public class Asfix2TreeBuilder
extends BottomupTreeBuilder {
    private final ITermFactory factory;
    private final IStrategoConstructor applIStrategoConstructor;
    private final IStrategoConstructor ambIStrategoConstructor;
    private final IStrategoConstructor parseTreeIStrategoConstructor;
    private final IStrategoConstructor cycleConstructor;
    private ParseTable table;
    private IStrategoAppl[] labels;
    private int labelStart;

    public Asfix2TreeBuilder() {
        this(new TermFactory());
    }

    public Asfix2TreeBuilder(ITermFactory factory) {
        this.factory = factory;
        this.applIStrategoConstructor = factory.makeConstructor("appl", 2);
        this.ambIStrategoConstructor = factory.makeConstructor("amb", 1);
        this.parseTreeIStrategoConstructor = factory.makeConstructor("parsetree", 2);
        this.cycleConstructor = factory.makeConstructor("cycle", 1);
    }

    @Override
    public void initializeTable(ParseTable table, int labelStart, int labelCount) {
        this.table = table;
        this.labels = new IStrategoAppl[labelCount - labelStart];
        this.labelStart = labelStart;
    }

    @Override
    public void initializeLabel(int labelNumber, IStrategoAppl parseTreeProduction) {
        this.labels[labelNumber - this.labelStart] = parseTreeProduction;
    }

    public ParseTable getTable() {
        return this.table;
    }

    @Override
    public void initializeInput(String input, String filename) {
    }

    @Override
    public IStrategoTerm buildNode(int labelNumber, List<Object> subtrees) {
        IStrategoList ls = this.factory.makeList();
        int i = subtrees.size() - 1;
        while (i >= 0) {
            ls = this.factory.makeListCons((IStrategoTerm)subtrees.get(i), ls);
            --i;
        }
        return this.factory.makeAppl(this.applIStrategoConstructor, this.labels[labelNumber - this.labelStart], ls);
    }

    @Override
    public IStrategoTerm buildAmb(List<Object> alternatives) {
        List<Object> alternativesCasted = alternatives;
        IStrategoList alternativesList = this.factory.makeList(alternativesCasted);
        return this.factory.makeAppl(this.ambIStrategoConstructor, alternativesList);
    }

    @Override
    public IStrategoTerm buildProduction(int productionNumber) {
        return this.factory.makeInt(productionNumber);
    }

    @Override
    public IStrategoTerm buildTreeTop(Object node, int ambCount) {
        return this.factory.makeAppl(this.parseTreeIStrategoConstructor, (IStrategoAppl)node, this.factory.makeInt(ambCount));
    }

    @Override
    public ITokenizer getTokenizer() {
        return null;
    }

    @Override
    public Object buildCycle(int labelNumber) {
        IStrategoString label = labelNumber == -1 ? this.factory.makeString("?") : this.labels[labelNumber - this.labelStart];
        return this.factory.makeAppl(this.cycleConstructor, label);
    }
}

