/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.jsglr;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.metaborg.parsetable.IParseTable;
import org.metaborg.parsetable.ParseTableReadException;
import org.metaborg.parsetable.ParseTableReader;
import org.metaborg.parsetable.actions.ActionsFactory;
import org.metaborg.parsetable.characterclasses.CharacterClassFactory;
import org.metaborg.parsetable.states.StateFactory;
import org.spoofax.interpreter.core.Interpreter;
import org.spoofax.interpreter.core.InterpreterException;
import org.spoofax.interpreter.library.AbstractStrategoOperatorRegistry;
import org.spoofax.interpreter.library.jsglr.AbstractFilterSetting;
import org.spoofax.interpreter.library.jsglr.STRSGLR2_parse_implode_stream_pt;
import org.spoofax.interpreter.library.jsglr.STRSGLR_anno_location;
import org.spoofax.interpreter.library.jsglr.STRSGLR_clear_parse_error;
import org.spoofax.interpreter.library.jsglr.STRSGLR_close_parse_table;
import org.spoofax.interpreter.library.jsglr.STRSGLR_get_parse_error;
import org.spoofax.interpreter.library.jsglr.STRSGLR_open_parse_table;
import org.spoofax.interpreter.library.jsglr.STRSGLR_parse_stream_pt;
import org.spoofax.interpreter.library.jsglr.STRSGLR_parse_string;
import org.spoofax.interpreter.library.jsglr.STRSGLR_parse_string_pt;
import org.spoofax.interpreter.library.jsglr.STRSGLR_recover_parse_string;
import org.spoofax.interpreter.terms.IStrategoInt;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.jsglr.client.Disambiguator;
import org.spoofax.jsglr.client.InvalidParseTableException;
import org.spoofax.jsglr.client.ParseTable;
import org.spoofax.jsglr.io.ParseTableManager;

public class JSGLRLibrary
extends AbstractStrategoOperatorRegistry {
    public static final String REGISTRY_NAME = "JSGLR";
    private ParseTableManager parseTableManager;
    private final ArrayList<ParseTable> v1parseTables = new ArrayList();
    private final ArrayList<IParseTable> v2parseTables = new ArrayList();
    private final Map<IStrategoTerm, IStrategoInt> parseTableCache = new WeakHashMap<IStrategoTerm, IStrategoInt>();
    private final Disambiguator filterSettings = new Disambiguator();
    private final AtomicBoolean recoveryEnabled = new AtomicBoolean(false);
    private ParseTableReader parseTableReader = new ParseTableReader(new CharacterClassFactory(true, true), new ActionsFactory(true), new StateFactory());

    public Disambiguator getFilterSettings() {
        return this.filterSettings;
    }

    public AtomicBoolean getRecoveryEnabledSetting() {
        return this.recoveryEnabled;
    }

    public JSGLRLibrary() {
        this.add(new STRSGLR_open_parse_table());
        this.add(new STRSGLR_parse_string_pt(this.filterSettings, this.recoveryEnabled));
        this.add(new STRSGLR_parse_string(this.filterSettings, this.recoveryEnabled));
        this.add(new STRSGLR_parse_stream_pt());
        this.add(new STRSGLR_recover_parse_string());
        this.add(new STRSGLR_get_parse_error());
        this.add(new STRSGLR_clear_parse_error());
        this.add(new STRSGLR_anno_location());
        this.add(new STRSGLR_close_parse_table());
        this.add(new STRSGLR2_parse_implode_stream_pt());
        this.initFilterSettings();
    }

    private void initFilterSettings() {
        this.filterSettings.setFilterAny(true);
        this.add(new AbstractFilterSetting(this.filterSettings, "STRSGLR_set_filter_direct_eagernes_on"){

            @Override
            public void set() {
                JSGLRLibrary.this.filterSettings.setFilterDirectPreference(true);
            }
        });
        this.add(new AbstractFilterSetting(this.filterSettings, "STRSGLR_set_filter_direct_eagernes_off"){

            @Override
            public void set() {
                JSGLRLibrary.this.filterSettings.setFilterDirectPreference(false);
            }
        });
        this.add(new AbstractFilterSetting(this.filterSettings, "STRSGLR_get_filter_direct_eagernes"){

            @Override
            public boolean get() {
                return JSGLRLibrary.this.filterSettings.getFilterDirectPreference();
            }
        });
        this.add(new AbstractFilterSetting(this.filterSettings, "STRSGLR_set_filter_eagernes_on"){

            @Override
            public void set() {
                JSGLRLibrary.this.filterSettings.setFilterPreferenceCount(true);
            }
        });
        this.add(new AbstractFilterSetting(this.filterSettings, "STRSGLR_set_filter_eagernes_off"){

            @Override
            public void set() {
                JSGLRLibrary.this.filterSettings.setFilterPreferenceCount(false);
            }
        });
        this.add(new AbstractFilterSetting(this.filterSettings, "STRSGLR_get_filter_eagernes"){

            @Override
            public boolean get() {
                return JSGLRLibrary.this.filterSettings.getFilterPreferenceCount();
            }
        });
        this.add(new AbstractFilterSetting(this.filterSettings, "STRSGLR_set_filter_injection_count_on"){

            @Override
            public void set() {
                JSGLRLibrary.this.filterSettings.setFilterInjectionCount(true);
            }
        });
        this.add(new AbstractFilterSetting(this.filterSettings, "STRSGLR_set_filter_injection_count_off"){

            @Override
            public void set() {
                JSGLRLibrary.this.filterSettings.setFilterInjectionCount(false);
            }
        });
        this.add(new AbstractFilterSetting(this.filterSettings, "STRSGLR_get_filter_injection_count"){

            @Override
            public boolean get() {
                return JSGLRLibrary.this.filterSettings.getFilterInjectionCount();
            }
        });
        this.add(new AbstractFilterSetting(this.filterSettings, "STRSGLR_set_filter_priority_on"){

            @Override
            public void set() {
                JSGLRLibrary.this.filterSettings.setFilterPriorities(true);
            }
        });
        this.add(new AbstractFilterSetting(this.filterSettings, "STRSGLR_set_filter_priority_off"){

            @Override
            public void set() {
                JSGLRLibrary.this.filterSettings.setFilterPriorities(false);
            }
        });
        this.add(new AbstractFilterSetting(this.filterSettings, "STRSGLR_get_filter_priority"){

            @Override
            public boolean get() {
                return JSGLRLibrary.this.filterSettings.getFilterPriorities();
            }
        });
        this.add(new AbstractFilterSetting(this.filterSettings, "STRSGLR_set_filter_reject_on"){

            @Override
            public void set() {
                JSGLRLibrary.this.filterSettings.setFilterReject(true);
            }
        });
        this.add(new AbstractFilterSetting(this.filterSettings, "STRSGLR_set_filter_reject_off"){

            @Override
            public void set() {
                JSGLRLibrary.this.filterSettings.setFilterReject(false);
            }
        });
        this.add(new AbstractFilterSetting(this.filterSettings, "STRSGLR_get_filter_reject"){

            @Override
            public boolean get() {
                return JSGLRLibrary.this.filterSettings.getFilterReject();
            }
        });
        this.add(new AbstractFilterSetting(this.filterSettings, "STRSGLR_set_default_filters"){

            @Override
            public void set() {
                JSGLRLibrary.this.filterSettings.setDefaultFilters();
            }
        });
        this.add(new AbstractFilterSetting(this.filterSettings, "STRSGLR_set_recovery_on"){

            @Override
            public void set() {
                JSGLRLibrary.this.recoveryEnabled.set(true);
            }
        });
        this.add(new AbstractFilterSetting(this.filterSettings, "STRSGLR_set_recovery_off"){

            @Override
            public void set() {
                JSGLRLibrary.this.recoveryEnabled.set(false);
            }
        });
        this.add(new AbstractFilterSetting(this.filterSettings, "STRSGLR_get_recovery"){

            @Override
            public boolean get() {
                return JSGLRLibrary.this.recoveryEnabled.get();
            }
        });
        this.add(new AbstractFilterSetting(this.filterSettings, "STRSGLR_set_default_config"){

            @Override
            public void set() {
                JSGLRLibrary.this.filterSettings.setDefaultFilters();
            }
        });
        this.add(new AbstractFilterSetting(this.filterSettings, "STRSGLR_set_ambiguity_error_on"){

            @Override
            public void set() {
                JSGLRLibrary.this.filterSettings.setAmbiguityIsError(true);
            }
        });
        this.add(new AbstractFilterSetting(this.filterSettings, "STRSGLR_set_ambiguity_error_off"){

            @Override
            public void set() {
                JSGLRLibrary.this.filterSettings.setAmbiguityIsError(false);
            }
        });
        this.add(new AbstractFilterSetting(this.filterSettings, "STRSGLR_get_ambiguity_error"){

            @Override
            public boolean get() {
                return JSGLRLibrary.this.filterSettings.getAmbiguityIsError();
            }
        });
        this.add(new AbstractFilterSetting(this.filterSettings, "STRSGLR_set_filtering_on"){

            @Override
            public void set() {
                JSGLRLibrary.this.filterSettings.setFilterAny(true);
            }
        });
        this.add(new AbstractFilterSetting(this.filterSettings, "STRSGLR_set_filtering_off"){

            @Override
            public void set() {
                JSGLRLibrary.this.filterSettings.setFilterAny(false);
            }
        });
        this.add(new AbstractFilterSetting(this.filterSettings, "STRSGLR_set_log_statistics_on"){

            @Override
            public void set() {
                JSGLRLibrary.this.filterSettings.setLogStatistics(true);
            }
        });
        this.add(new AbstractFilterSetting(this.filterSettings, "STRSGLR_set_log_statistics_off"){

            @Override
            public void set() {
                JSGLRLibrary.this.filterSettings.setLogStatistics(false);
            }
        });
        this.add(new AbstractFilterSetting(this.filterSettings, "STRSGLR_get_log_statistics"){

            @Override
            public boolean get() {
                return JSGLRLibrary.this.filterSettings.getLogStatistics();
            }
        });
    }

    @Override
    public String getOperatorRegistryName() {
        return REGISTRY_NAME;
    }

    int addParseTable(ITermFactory factory, IStrategoTerm tableTerm) throws InvalidParseTableException, ParseTableReadException {
        if (this.parseTableManager == null) {
            this.parseTableManager = new ParseTableManager(factory);
        }
        ParseTable ptv1 = this.parseTableManager.loadFromTerm(tableTerm);
        IParseTable ptv2 = this.parseTableReader.read(tableTerm);
        assert (this.v1parseTables.size() == this.v2parseTables.size());
        int idx = this.v1parseTables.size();
        this.v1parseTables.add(ptv1);
        this.v2parseTables.add(ptv2);
        return idx;
    }

    ParseTable getParseTable(int idx) {
        return this.v1parseTables.get(idx);
    }

    IParseTable getV2ParseTable(int idx) {
        return this.v2parseTables.get(idx);
    }

    Map<IStrategoTerm, IStrategoInt> getParseTableCache() {
        return this.parseTableCache;
    }

    public static void attach(Interpreter intp) throws IOException, InterpreterException {
        JSGLRLibrary.attach(intp, new JSGLRLibrary(), "share/libstratego-jsglr.ctree");
    }

    public void removeParseTable(int index) {
        this.v1parseTables.set(index, null);
    }
}

