/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.util.collection;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;

public class Sets {
    public static <E> Set<E> union(final Set<? extends E> set1, final Set<? extends E> set2) {
        Objects.requireNonNull(set1, "set1");
        Objects.requireNonNull(set2, "set2");
        return new AbstractSet<E>(){

            @Override
            public int size() {
                int size = set1.size();
                for (Object e : set2) {
                    if (set1.contains(e)) continue;
                    ++size;
                }
                return size;
            }

            @Override
            public boolean isEmpty() {
                return set1.isEmpty() && set2.isEmpty();
            }

            @Override
            public Iterator<E> iterator() {
                return new Iterator<E>(set2){
                    final Iterator<? extends E> itr1;
                    final Iterator<? extends E> itr2;
                    E next;
                    boolean hasNext;
                    {
                        this.itr1 = set.iterator();
                        this.itr2 = set2.iterator();
                        this.next = null;
                        this.hasNext = false;
                    }

                    /*
                     * Unable to fully structure code
                     */
                    private E computeNext() {
                        if (!this.itr1.hasNext()) ** GOTO lbl8
                        this.hasNext = true;
                        return this.itr1.next();
lbl-1000:
                        // 1 sources

                        {
                            e = this.itr2.next();
                            if (set1.contains(e)) continue;
                            this.hasNext = true;
                            return e;
lbl8:
                            // 2 sources

                            ** while (this.itr2.hasNext())
                        }
lbl9:
                        // 1 sources

                        this.hasNext = false;
                        return null;
                    }

                    @Override
                    public boolean hasNext() {
                        if (!this.hasNext) {
                            this.next = this.computeNext();
                        }
                        return this.hasNext;
                    }

                    @Override
                    public E next() {
                        if (this.hasNext()) {
                            this.hasNext = false;
                            return this.next;
                        }
                        throw new NoSuchElementException();
                    }
                };
            }

            @Override
            public Stream<E> stream() {
                return Stream.concat(set1.stream(), set2.stream().filter(e -> !set1.contains(e)));
            }

            @Override
            public Stream<E> parallelStream() {
                return (Stream)this.stream().parallel();
            }

            @Override
            public boolean contains(Object object) {
                return set1.contains(object) || set2.contains(object);
            }
        };
    }

    public static <E> Set<E> intersection(final Set<E> set1, final Set<?> set2) {
        Objects.requireNonNull(set1, "set1");
        Objects.requireNonNull(set2, "set2");
        return new AbstractSet<E>(){

            @Override
            public Iterator<E> iterator() {
                return new Iterator<E>(set1){
                    final Iterator<E> itr;
                    E next;
                    boolean hasNext;
                    {
                        this.itr = set.iterator();
                        this.next = null;
                        this.hasNext = false;
                    }

                    protected E computeNext() {
                        while (this.itr.hasNext()) {
                            Object e = this.itr.next();
                            if (!set2.contains(e)) continue;
                            this.hasNext = true;
                            return e;
                        }
                        this.hasNext = false;
                        return null;
                    }

                    @Override
                    public boolean hasNext() {
                        if (!this.hasNext) {
                            this.next = this.computeNext();
                        }
                        return this.hasNext;
                    }

                    @Override
                    public E next() {
                        if (this.hasNext()) {
                            this.hasNext = false;
                            return this.next;
                        }
                        throw new NoSuchElementException();
                    }
                };
            }

            @Override
            public Stream<E> stream() {
                return set1.stream().filter(set2::contains);
            }

            @Override
            public Stream<E> parallelStream() {
                return set1.parallelStream().filter(set2::contains);
            }

            @Override
            public int size() {
                int size = 0;
                for (Object e : set1) {
                    if (!set2.contains(e)) continue;
                    ++size;
                }
                return size;
            }

            @Override
            public boolean isEmpty() {
                return Collections.disjoint(set1, set2);
            }

            @Override
            public boolean contains(Object object) {
                return set1.contains(object) && set2.contains(object);
            }

            @Override
            public boolean containsAll(Collection<?> collection) {
                return set1.containsAll(collection) && set2.containsAll(collection);
            }
        };
    }

    public static <E> Set<E> difference(final Set<E> set1, final Set<?> set2) {
        Objects.requireNonNull(set1, "set1");
        Objects.requireNonNull(set2, "set2");
        return new AbstractSet<E>(){

            @Override
            public Iterator<E> iterator() {
                return new Iterator<E>(set1){
                    final Iterator<E> itr;
                    E next;
                    boolean hasNext;
                    {
                        this.itr = set.iterator();
                        this.next = null;
                        this.hasNext = false;
                    }

                    protected E computeNext() {
                        while (this.itr.hasNext()) {
                            Object e = this.itr.next();
                            if (set2.contains(e)) continue;
                            this.hasNext = true;
                            return e;
                        }
                        this.hasNext = false;
                        return null;
                    }

                    @Override
                    public boolean hasNext() {
                        if (!this.hasNext) {
                            this.next = this.computeNext();
                        }
                        return this.hasNext;
                    }

                    @Override
                    public E next() {
                        if (this.hasNext()) {
                            this.hasNext = false;
                            return this.next;
                        }
                        throw new NoSuchElementException();
                    }
                };
            }

            @Override
            public Stream<E> stream() {
                return set1.stream().filter(e -> !set2.contains(e));
            }

            @Override
            public Stream<E> parallelStream() {
                return set1.parallelStream().filter(e -> !set2.contains(e));
            }

            @Override
            public int size() {
                int size = 0;
                for (Object e : set1) {
                    if (set2.contains(e)) continue;
                    ++size;
                }
                return size;
            }

            @Override
            public boolean isEmpty() {
                return set2.containsAll(set1);
            }

            @Override
            public boolean contains(Object element) {
                return set1.contains(element) && !set2.contains(element);
            }
        };
    }

    public static int hashCapacity(int expectedSize) {
        if (expectedSize < 3) {
            return Integer.max(expectedSize, 2) + 1;
        }
        if (expectedSize < 0x40000000) {
            return (int)((float)expectedSize / 0.75f + 1.0f);
        }
        return Integer.MAX_VALUE;
    }
}

