/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.util.collection;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.metaborg.util.functions.CheckedAction2;

public abstract class Multimap<K, V, C extends Collection<V>>
implements Serializable {
    public static final long serialVersionUID = 1L;
    protected final Map<K, C> backingMap;

    protected Multimap(Map<K, C> backingMap) {
        this.backingMap = backingMap;
    }

    public Multimap() {
        this(new HashMap());
    }

    protected Multimap(Multimap<K, V, C> toCopy) {
        this.backingMap = toCopy.copyOfBackingMap();
    }

    protected Map<K, C> copyOfBackingMap() {
        HashMap<Object, C> kcHashMap = new HashMap<Object, C>(this.backingMap);
        kcHashMap.replaceAll((k, c) -> this.copyCollection(c));
        return kcHashMap;
    }

    protected abstract C newCollection();

    protected abstract C emptyCollection();

    protected abstract C unmodifiableCollection(C var1);

    protected abstract C copyCollection(C var1);

    public int size() {
        return (int)this.backingMap.values().stream().flatMap(Collection::stream).count();
    }

    public boolean isEmpty() {
        return this.backingMap.isEmpty();
    }

    public boolean containsKey(K key) {
        return this.backingMap.containsKey(key);
    }

    public boolean containsValue(V value) {
        return this.backingMap.values().stream().flatMap(Collection::stream).anyMatch(v -> v.equals(value));
    }

    public boolean containsEntry(K key, V value) {
        return this.get(key).contains(value);
    }

    public C get(K key) {
        Collection values = (Collection)this.backingMap.getOrDefault(key, this.emptyCollection());
        return (C)this.unmodifiableCollection(values);
    }

    public boolean put(K key, V value) {
        Collection collection = this.backingMap.computeIfAbsent(key, k -> this.newCollection());
        return collection.add(value);
    }

    public boolean putAll(K key, Collection<? extends V> values) {
        boolean anyAdded = false;
        for (V value : values) {
            anyAdded |= this.put(key, value);
        }
        return anyAdded;
    }

    public boolean putAll(Map<? extends K, ? extends V> m) {
        boolean changed = false;
        for (Map.Entry<K, V> entry : m.entrySet()) {
            changed |= this.put(entry.getKey(), entry.getValue());
        }
        return changed;
    }

    public boolean putAll(Multimap<? extends K, V, C> mm) {
        AtomicBoolean changed = new AtomicBoolean(false);
        mm.forEach((key, values) -> {
            boolean localChanged = this.putAll((K)key, (Collection<? extends V>)values);
            changed.compareAndSet(false, localChanged);
        });
        return changed.get();
    }

    public void clear() {
        this.backingMap.clear();
    }

    public Set<K> keySet() {
        return this.backingMap.keySet();
    }

    public Collection<V> values() {
        return this.backingMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public Stream<Map.Entry<K, V>> entries() {
        return this.backingMap.entrySet().stream().flatMap(e -> {
            Object k = e.getKey();
            return ((Collection)e.getValue()).stream().map(v -> new AbstractMap.SimpleImmutableEntry<Object, Object>(k, v));
        });
    }

    public <E extends Throwable> void forEach(CheckedAction2<? super K, ? super C, E> action) throws E {
        for (Map.Entry<K, C> entry : this.backingMap.entrySet()) {
            action.apply(entry.getKey(), this.unmodifiableCollection((Collection)entry.getValue()));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Multimap that = (Multimap)o;
        return this.backingMap.equals(that.backingMap);
    }

    public int hashCode() {
        return Objects.hash(this.backingMap);
    }

    public String toString() {
        return this.backingMap.toString();
    }
}

