/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.util.collection;

import io.usethesource.capsule.Map;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.metaborg.util.collection.CapsuleUtil;
import org.metaborg.util.collection.ImList;
import org.metaborg.util.collection.MultiSet;
import org.metaborg.util.tuple.Tuple2;

public abstract class MultiSetMap<K, V>
implements Serializable {
    public static final long serialVersionUID = 1L;
    private static final Immutable EMPTY = new Immutable(Map.Immutable.of());

    protected abstract Map<K, MultiSet.Immutable<V>> asMap();

    public Set<Map.Entry<K, MultiSet.Immutable<V>>> entrySet() {
        return this.asMap().entrySet();
    }

    public Collection<Map.Entry<K, V>> entries() {
        return this.entryStream().collect(ImList.toImmutableList());
    }

    public void forEach(BiConsumer<? super K, ? super V> action) {
        this.entryStream().forEach((? super T e) -> action.accept((Object)e.getKey(), (Object)e.getValue()));
    }

    public Stream<Map.Entry<K, V>> entryStream() {
        return this.asMap().entrySet().stream().flatMap(e -> {
            Object key = e.getKey();
            return ((MultiSet.Immutable)e.getValue()).toCollection().stream().map(v -> Tuple2.of(key, v));
        });
    }

    public boolean isEmpty() {
        return this.asMap().isEmpty();
    }

    public int size() {
        return this.asMap().entrySet().stream().mapToInt(e -> ((MultiSet.Immutable)e.getValue()).size()).sum();
    }

    public boolean containsKey(K key) {
        return this.asMap().containsKey(key);
    }

    public boolean contains(K key, V value) {
        return this.get(key).contains(value);
    }

    public boolean containsValue(V value) {
        return this.asMap().values().stream().anyMatch(vs -> vs.contains(value));
    }

    public int count(K key, V value) {
        return this.get(key).count(value);
    }

    public MultiSet.Immutable<V> get(K key) {
        return this.asMap().getOrDefault(key, MultiSet.Immutable.of());
    }

    public Set<K> keySet() {
        return this.asMap().keySet();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MultiSetMap)) {
            return false;
        }
        MultiSetMap that = (MultiSetMap)obj;
        return this.asMap().equals(that.asMap());
    }

    public int hashCode() {
        return this.asMap().hashCode();
    }

    public String toString() {
        return this.asMap().entrySet().stream().map(e -> e.getKey() + ": " + e.getValue()).collect(Collectors.joining(", ", "{", "}"));
    }

    public static class Immutable<K, V>
    extends MultiSetMap<K, V>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Map.Immutable<K, MultiSet.Immutable<V>> entries;

        private Immutable(Map.Immutable<K, MultiSet.Immutable<V>> entries) {
            this.entries = entries;
        }

        public static <K, V> Immutable<K, V> of(K key, V value) {
            Immutable<K, V> result = Immutable.of();
            return result.put(key, value);
        }

        @Override
        public Map.Immutable<K, MultiSet.Immutable<V>> asMap() {
            return this.entries;
        }

        public Immutable<K, V> put(K key, V value) {
            MultiSet.Immutable values = (MultiSet.Immutable)this.entries.getOrDefault(key, MultiSet.Immutable.of());
            return new Immutable<K, V>(this.entries.__put(key, values.add(value, 1)));
        }

        public Immutable<K, V> put(K key, V value, int n) {
            if (n < 0) {
                throw new IllegalArgumentException("Negative count");
            }
            if (n == 0) {
                return this;
            }
            MultiSet.Immutable values = (MultiSet.Immutable)this.entries.getOrDefault(key, MultiSet.Immutable.of());
            MultiSet.Immutable<V> newValues = values.add(value, n);
            return new Immutable<K, V>(this.entries.__put(key, newValues));
        }

        public Immutable<K, V> putAll(K key, MultiSet.Immutable<V> values) {
            MultiSet.Immutable oldValues = (MultiSet.Immutable)this.entries.get(key);
            MultiSet.Immutable<V> newValues = oldValues != null ? MultiSet.Immutable.union(oldValues, values) : values;
            return new Immutable<K, V>(this.entries.__put(key, newValues));
        }

        public Immutable<K, V> removeKey(K key) {
            return new Immutable<K, V>(this.entries.__remove(key));
        }

        public Immutable<K, V> remove(K key, V value) {
            MultiSet.Immutable values = (MultiSet.Immutable)this.entries.get(key);
            if (values == null) {
                return this;
            }
            MultiSet.Immutable<V> newValues = values.remove(value, 1);
            Map.Immutable newEntries = newValues.isEmpty() ? this.entries.__remove(key) : this.entries.__put(key, newValues);
            return new Immutable<K, V>(newEntries);
        }

        public Immutable<K, V> removeAll(Set<K> keys) {
            Map.Transient newEntries = this.entries.asTransient();
            CapsuleUtil.filter(newEntries, k -> !keys.contains(k));
            return new Immutable<K, V>(newEntries.freeze());
        }

        public Immutable<K, V> retainAll(Set<K> keys) {
            Map.Transient newEntries = this.entries.asTransient();
            CapsuleUtil.filter(newEntries, k -> keys.contains(k));
            return new Immutable<K, V>(newEntries.freeze());
        }

        public Transient<K, V> melt() {
            return new Transient(this.entries.asTransient());
        }

        public static <K, V> Immutable<K, V> of() {
            return EMPTY;
        }
    }

    public static abstract class Mutable<K, V>
    extends MultiSetMap<K, V> {
        @Override
        public abstract Map<K, MultiSet.Immutable<V>> asMap();

        protected abstract MultiSet.Immutable<V> remove(K var1);

        protected abstract MultiSet.Immutable<V> put(K var1, MultiSet.Immutable<V> var2);

        public int put(K key, V value) {
            return this.put(key, value, 1);
        }

        public int put(K key, V value, int n) {
            MultiSet.Immutable<V> newValues;
            int oldCount;
            if (n < 0) {
                throw new IllegalArgumentException("Negative count");
            }
            MultiSet.Immutable<V> oldValues = this.remove(key);
            if (oldValues != null) {
                MultiSet.Transient<V> values = oldValues.melt();
                oldCount = values.add(value, n);
                newValues = values.freeze();
            } else {
                oldCount = 0;
                newValues = MultiSet.Immutable.of(value, n);
            }
            if (!newValues.isEmpty()) {
                this.put(key, newValues);
            }
            return oldCount;
        }

        public void putAll(K key, Iterable<V> values) {
            for (V value : values) {
                this.put(key, value);
            }
        }

        public void putAll(K key, MultiSet.Immutable<V> values) {
            MultiSet.Immutable<V> oldValues = this.remove(key);
            MultiSet.Immutable<V> newValues = oldValues != null ? MultiSet.Immutable.union(oldValues, values) : values;
            if (!newValues.isEmpty()) {
                this.put(key, newValues);
            }
        }

        public MultiSet.Immutable<V> removeKey(K key) {
            if (this.asMap().containsKey(key)) {
                return this.remove(key);
            }
            return MultiSet.Immutable.of();
        }

        public int remove(K key, V value) {
            return this.remove(key, value, 1);
        }

        public int remove(K key, V value, int n) {
            MultiSet.Immutable<Object> newValues;
            int oldCount;
            if (n < 0) {
                throw new IllegalArgumentException("Negative count");
            }
            MultiSet.Immutable<V> oldValues = this.remove(key);
            if (oldValues != null) {
                MultiSet.Transient<V> values = oldValues.melt();
                oldCount = values.remove(value, n);
                newValues = values.freeze();
            } else {
                oldCount = 0;
                newValues = MultiSet.Immutable.of();
            }
            if (!newValues.isEmpty()) {
                this.put(key, newValues);
            }
            return oldCount;
        }

        public Immutable<K, V> clear() {
            Immutable cleared = new Immutable(Map.Immutable.of().__putAll(this.asMap()));
            for (K k : this.asMap().keySet()) {
                this.remove(k);
            }
            return cleared;
        }

        public Collection<V> removeAll(K key) {
            MultiSet.Immutable<V> removed = this.remove(key);
            return removed != null ? removed.toCollection() : Collections.emptySet();
        }

        public boolean removeAll(Collection<K> keys, V value) {
            boolean changed = false;
            for (K key : keys) {
                changed |= this.remove(key, value) != 0;
            }
            return changed;
        }
    }

    public static class Ordered<K, V>
    extends Mutable<K, V> {
        private final LinkedHashMap<K, MultiSet.Immutable<V>> entries;

        private Ordered(LinkedHashMap<K, MultiSet.Immutable<V>> entries) {
            this.entries = entries;
        }

        @Override
        public Map<K, MultiSet.Immutable<V>> asMap() {
            return this.entries;
        }

        @Override
        protected MultiSet.Immutable<V> remove(K key) {
            return (MultiSet.Immutable)this.entries.remove(key);
        }

        @Override
        protected MultiSet.Immutable<V> put(K key, MultiSet.Immutable<V> value) {
            return this.entries.put(key, value);
        }
    }

    public static class Transient<K, V>
    extends Mutable<K, V> {
        private final Map.Transient<K, MultiSet.Immutable<V>> entries;

        private Transient(Map.Transient<K, MultiSet.Immutable<V>> entries) {
            this.entries = entries;
        }

        @Override
        public Map.Transient<K, MultiSet.Immutable<V>> asMap() {
            return this.entries;
        }

        @Override
        protected MultiSet.Immutable<V> remove(K key) {
            return (MultiSet.Immutable)this.entries.__remove(key);
        }

        @Override
        protected MultiSet.Immutable<V> put(K key, MultiSet.Immutable<V> value) {
            return (MultiSet.Immutable)this.entries.__put(key, value);
        }

        public Immutable<K, V> freeze() {
            return this.entries.isEmpty() ? EMPTY : new Immutable(this.entries.freeze());
        }

        public static <K, V> Transient<K, V> of() {
            return new Transient<K, V>(Map.Transient.of());
        }
    }
}

