/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.spoofax.core.stratego.primitive;

import jakarta.inject.Inject;
import java.util.ArrayList;
import org.metaborg.core.MetaborgException;
import org.metaborg.core.build.paths.ILanguagePathService;
import org.metaborg.core.context.IContext;
import org.metaborg.core.language.ILanguage;
import org.metaborg.core.language.ILanguageImpl;
import org.metaborg.core.language.ILanguageService;
import org.metaborg.core.language.IdentifiedResource;
import org.metaborg.core.project.IProject;
import org.metaborg.core.project.IProjectService;
import org.metaborg.spoofax.core.stratego.primitive.generic.ASpoofaxContextPrimitive;
import org.spoofax.interpreter.stratego.Strategy;
import org.spoofax.interpreter.terms.IStrategoString;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.terms.util.TermUtils;

public class LanguageSourceFilesPrimitive
extends ASpoofaxContextPrimitive {
    private final ILanguageService languageService;
    private final ILanguagePathService languagePathService;
    private final IProjectService projectService;

    @Inject
    public LanguageSourceFilesPrimitive(ILanguageService languageService, ILanguagePathService languagePathService, IProjectService projectService) {
        super("language_source_files", 0, 1);
        this.languageService = languageService;
        this.languagePathService = languagePathService;
        this.projectService = projectService;
    }

    @Override
    protected IStrategoTerm call(IStrategoTerm current, Strategy[] svars, IStrategoTerm[] tvars, ITermFactory factory, IContext context) throws MetaborgException {
        if (!TermUtils.isString(tvars[0])) {
            return null;
        }
        IProject project = this.projectService.get(context.location());
        if (project == null) {
            return factory.makeList();
        }
        String languageName = TermUtils.toJavaString(tvars[0]);
        ILanguage language = this.languageService.getLanguage(languageName);
        if (language == null) {
            String message = String.format("Getting include files for %s failed, language could not be found", languageName);
            throw new MetaborgException(message);
        }
        ILanguageImpl impl = language.activeImpl();
        if (impl == null) {
            String message = String.format("Getting include files for %s failed, no active language implementation could be found", languageName);
            throw new MetaborgException(message);
        }
        Iterable<IdentifiedResource> sourceFiles = this.languagePathService.sourceFiles(project, impl);
        ArrayList<IStrategoString> terms = new ArrayList<IStrategoString>();
        for (IdentifiedResource sourceFile : sourceFiles) {
            terms.add(factory.makeString(sourceFile.resource.getName().getURI()));
        }
        return factory.makeList(terms);
    }
}

