/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.spoofax.core.context.constraint;

import com.google.inject.Injector;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import mb.util.vfs2.file.FileUtils;
import mb.util.vfs2.resource.ResourceUtils;
import org.apache.commons.io.input.ClassLoaderObjectInputStream;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.metaborg.core.MetaborgRuntimeException;
import org.metaborg.core.build.CommonPaths;
import org.metaborg.core.context.ContextIdentifier;
import org.metaborg.core.language.ILanguageImpl;
import org.metaborg.core.project.IProject;
import org.metaborg.spoofax.core.context.constraint.IConstraintContext;
import org.metaborg.util.collection.ImList;
import org.metaborg.util.concurrent.ClosableLock;
import org.metaborg.util.concurrent.IClosableLock;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;
import org.metaborg.util.time.Timer;
import org.spoofax.interpreter.terms.IStrategoTerm;

public class ConstraintContext
implements IConstraintContext {
    private static final ILogger logger = LoggerUtils.logger(ConstraintContext.class);
    private final ContextIdentifier identifier;
    private final String persistentIdentifier;
    private final Injector injector;
    private final ReadWriteLock lock;
    private State state = null;

    public ConstraintContext(Injector injector, ContextIdentifier identifier) {
        this.identifier = identifier;
        this.persistentIdentifier = FileUtils.sanitize(identifier.language.id().toString());
        this.injector = injector;
        this.lock = new ReentrantReadWriteLock(true);
    }

    @Override
    public String resourceKey(FileObject resource) {
        return ResourceUtils.relativeName(resource.getName(), this.location().getName(), true);
    }

    @Override
    public FileObject keyResource(String resource) {
        try {
            return ResourceUtils.resolveFile(this.location(), resource);
        }
        catch (FileSystemException e) {
            throw new MetaborgRuntimeException(e);
        }
    }

    @Override
    public boolean contains(FileObject resource) {
        return this.state.entries.containsKey(this.resourceKey(resource));
    }

    @Override
    public boolean put(FileObject resource, int parseHash, IStrategoTerm analyzedAst, IStrategoTerm analysis, IStrategoTerm errors, IStrategoTerm warnings, IStrategoTerm notes, List<String> exceptions) {
        return this.state.entries.put(this.resourceKey(resource), new Entry(parseHash, analyzedAst, analysis, errors, warnings, notes, exceptions)) != null;
    }

    @Override
    public IConstraintContext.Entry get(FileObject resource) {
        return this.state.entries.get(this.resourceKey(resource));
    }

    @Override
    public boolean remove(FileObject resource) {
        return this.state.entries.remove(this.resourceKey(resource)) != null;
    }

    @Override
    public Set<Map.Entry<String, IConstraintContext.Entry>> entrySet() {
        return this.state.entries.entrySet();
    }

    @Override
    public void clear() {
        this.state.entries.clear();
    }

    @Override
    public FileObject location() {
        return this.identifier.location;
    }

    @Override
    public IProject project() {
        return this.identifier.project;
    }

    @Override
    public ILanguageImpl language() {
        return this.identifier.language;
    }

    @Override
    public Injector injector() {
        return this.injector;
    }

    @Override
    public IClosableLock read() {
        if (this.state == null) {
            Throwable throwable = null;
            Object var2_3 = null;
            try (IClosableLock lock = this.writeLock();){
                if (this.state == null) {
                    this.state = this.loadOrInitState();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return this.readLock();
    }

    private IClosableLock readLock() {
        Lock readLock = this.lock.readLock();
        ClosableLock lock = new ClosableLock(readLock);
        return lock;
    }

    public IClosableLock guard() {
        return this.read();
    }

    @Override
    public IClosableLock write() {
        IClosableLock lock = this.writeLock();
        if (this.state == null) {
            this.state = this.loadOrInitState();
        }
        return lock;
    }

    private IClosableLock writeLock() {
        Lock writeLock = this.lock.writeLock();
        ClosableLock lock = new ClosableLock(writeLock);
        return lock;
    }

    @Override
    public void persist() throws IOException {
        if (this.state == null) {
            return;
        }
        Throwable throwable = null;
        Object var2_3 = null;
        try (IClosableLock lock = this.readLock();){
            this.persistState();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void reset() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (IClosableLock lock = this.writeLock();){
            if (this.state != null) {
                this.state = null;
            }
            FileObject contextFile = this.contextFile();
            contextFile.delete();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public ContextIdentifier identifier() {
        return this.identifier;
    }

    @Override
    public void init() {
        if (this.state != null) {
            return;
        }
        Throwable throwable = null;
        Object var2_3 = null;
        try (IClosableLock lock = this.writeLock();){
            this.state = this.initState();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void load() {
        if (this.state != null) {
            return;
        }
        Throwable throwable = null;
        Object var2_3 = null;
        try (IClosableLock lock = this.writeLock();){
            this.state = this.loadOrInitState();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void unload() {
        if (this.state == null) {
            return;
        }
        Throwable throwable = null;
        Object var2_3 = null;
        try (IClosableLock lock = this.writeLock();){
            this.state = null;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private State loadOrInitState() {
        try {
            FileObject contextFile = this.contextFile();
            try {
                if (contextFile.exists()) {
                    return this.readContext(contextFile);
                }
            }
            catch (IOException | ClassNotFoundException e) {
                logger.warn("Load context {} failed: {}", contextFile, e.getMessage());
                this.deleteContextFile(contextFile);
            }
        }
        catch (IOException e) {
            logger.warn("Failed to locate context: {}", e.getMessage());
        }
        return this.initState();
    }

    private State initState() {
        return new State();
    }

    private FileObject contextFile() throws FileSystemException {
        CommonPaths paths = new CommonPaths(this.identifier.location);
        return paths.targetDir().resolveFile("analysis").resolveFile(this.persistentIdentifier).resolveFile("constraint");
    }

    private State readContext(FileObject file) throws IOException, ClassNotFoundException, ClassCastException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (ClassLoaderObjectInputStream ois = new ClassLoaderObjectInputStream(this.getClass().getClassLoader(), file.getContent().getInputStream());){
            State fileState;
            try {
                fileState = (State)ois.readObject();
            }
            catch (NotSerializableException ex) {
                logger.warn("Context could not be read: {}", ex.getMessage());
                fileState = this.initState();
            }
            catch (Exception ex) {
                String msg = logger.format("Context file could not be read: {}", ex.getMessage());
                throw new IOException(msg);
            }
            if (fileState == null) {
                throw new IOException("Context file is empty.");
            }
            return fileState;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void persistState() {
        try {
            FileObject contextFile = this.contextFile();
            try {
                this.writeContext(contextFile);
            }
            catch (IOException e) {
                logger.warn("Store context {} failed: {}", contextFile, e.getMessage());
            }
        }
        catch (IOException e) {
            logger.warn("Failed to locate context: {}", e.getMessage());
        }
    }

    private void writeContext(FileObject file) throws IOException {
        block16: {
            Timer timer = new Timer(true);
            try {
                Throwable throwable = null;
                Object var4_7 = null;
                try (ObjectOutputStream oos = new ObjectOutputStream(file.getContent().getOutputStream());){
                    oos.writeObject(this.state);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (NotSerializableException ex) {
                logger.warn("Constraint context persistence not serializable: {}", ex.getMessage());
                logger.debug("Context written in {} s", (double)timer.stop() / 1.0E9);
                break block16;
            }
            catch (Exception ex) {
                try {
                    throw new IOException("Context file could not be written.", ex);
                }
                catch (Throwable throwable) {
                    logger.debug("Context written in {} s", (double)timer.stop() / 1.0E9);
                    throw throwable;
                }
            }
            logger.debug("Context written in {} s", (double)timer.stop() / 1.0E9);
        }
    }

    private void deleteContextFile(FileObject file) {
        try {
            file.delete();
        }
        catch (FileSystemException e) {
            logger.warn("Deleting context {} failed: {}", file, e.getMessage());
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.identifier == null ? 0 : this.identifier.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConstraintContext other = (ConstraintContext)obj;
        return this.identifier.equals(other.identifier);
    }

    public String toString() {
        return String.format("Constraint context for %s, %s", this.identifier.location, this.identifier.language);
    }

    private static class Entry
    implements IConstraintContext.Entry,
    Serializable {
        private static final long serialVersionUID = 1L;
        public final int parseHash;
        public transient IStrategoTerm analyzedAst;
        public final IStrategoTerm analysis;
        public final IStrategoTerm errors;
        public final IStrategoTerm warnings;
        public final IStrategoTerm notes;
        public final List<String> exceptions;

        Entry(int parseHash, IStrategoTerm analyzedAst, IStrategoTerm analysis, IStrategoTerm errors, IStrategoTerm warnings, IStrategoTerm notes, List<String> exceptions) {
            this.parseHash = parseHash;
            this.analyzedAst = analyzedAst;
            this.analysis = analysis;
            this.errors = errors;
            this.warnings = warnings;
            this.notes = notes;
            this.exceptions = ImList.Immutable.copyOf(exceptions);
        }

        @Override
        public int parseHash() {
            return this.parseHash;
        }

        @Override
        public IStrategoTerm analyzedAst() {
            return this.analyzedAst;
        }

        @Override
        public IStrategoTerm analysis() {
            return this.analysis;
        }

        @Override
        public IStrategoTerm errors() {
            return this.errors;
        }

        @Override
        public IStrategoTerm warnings() {
            return this.warnings;
        }

        @Override
        public IStrategoTerm notes() {
            return this.notes;
        }

        @Override
        public List<String> exceptions() {
            return this.exceptions;
        }
    }

    private static class State
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final Map<String, IConstraintContext.Entry> entries = new HashMap<String, IConstraintContext.Entry>();
    }
}

