/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.spoofax.core.config.language;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mb.statix.spoofax.IStatixProjectConfig;
import mb.statix.spoofax.SolverMode;
import mb.statix.spoofax.StatixProjectConfig;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;

public class StatixProjectConfigReaderWriter {
    private static final ILogger logger = LoggerUtils.logger(StatixProjectConfigReaderWriter.class);
    private static final String PROP_CONCURRENT = "concurrent";
    private static final String PROP_MODES = "modes";
    private static final String PROP_MESSAGE_TRACE_LENGTH = "message-trace-length";
    private static final String PROP_MESSAGE_TERM_DEPTH = "message-term-depth";
    private static final String PROP_TESTLOG = "test-log";
    private static final String PROP_SUPPRESS_CASCADING_ERRORS = "suppress-cascading-errors";

    public static IStatixProjectConfig read(HierarchicalConfiguration<ImmutableNode> config) {
        List parallelLanguages = config.getList(String.class, PROP_CONCURRENT, Collections.emptyList());
        HashMap<String, SolverMode> modes = new HashMap<String, SolverMode>();
        if (!parallelLanguages.isEmpty()) {
            logger.warn("Option runtime.statix.concurrent is deprecated. Use runtime.statix.modes.<lang>: <mode> instead.");
        }
        parallelLanguages.forEach(languageName -> {
            SolverMode solverMode = modes.put((String)languageName, SolverMode.CONCURRENT);
        });
        config.getKeys(PROP_MODES).forEachRemaining(modeKey -> {
            String languageName = modeKey.substring(PROP_MODES.length() + 1);
            SolverMode mode = SolverMode.valueOf(config.getString(modeKey).toUpperCase().replace('-', '_'));
            modes.put(languageName, mode);
        });
        Integer messageStacktraceLength = config.getInteger(PROP_MESSAGE_TRACE_LENGTH, null);
        Integer messageTermDepth = config.getInteger(PROP_MESSAGE_TERM_DEPTH, null);
        String testLog = config.getString(PROP_TESTLOG, null);
        Boolean suppressCascadingErrors = config.getBoolean(PROP_SUPPRESS_CASCADING_ERRORS, true);
        return new StatixProjectConfig(modes, messageStacktraceLength, messageTermDepth, testLog, suppressCascadingErrors);
    }

    public static void write(IStatixProjectConfig statixConfig, HierarchicalConfiguration<ImmutableNode> config) {
        Boolean suppressCascadingErrors;
        String testLog;
        Integer messageTermDepth;
        Integer messageStacktraceLength;
        Map<String, SolverMode> languageModes = statixConfig.languageModes(null);
        if (languageModes != null) {
            for (String languageName : languageModes.keySet()) {
                config.setProperty(String.format("%s.%s", PROP_MODES, languageName), (Object)languageModes.get(languageName));
            }
        }
        if ((messageStacktraceLength = statixConfig.messageTraceLength(null)) != null) {
            config.setProperty(PROP_MESSAGE_TRACE_LENGTH, (Object)messageStacktraceLength);
        }
        if ((messageTermDepth = statixConfig.messageTermDepth(null)) != null) {
            config.setProperty(PROP_MESSAGE_TERM_DEPTH, (Object)messageTermDepth);
        }
        if ((testLog = statixConfig.testLogLevel(null)) != null) {
            config.setProperty(PROP_TESTLOG, (Object)testLog);
        }
        if ((suppressCascadingErrors = config.getBoolean(PROP_SUPPRESS_CASCADING_ERRORS, null)) != null) {
            config.setProperty(PROP_SUPPRESS_CASCADING_ERRORS, (Object)suppressCascadingErrors);
        }
    }
}

