/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.spoofax.core.analysis.constraint;

import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import mb.flowspec.terms.B;
import mb.nabl2.terms.stratego.StrategoTermIndices;
import mb.nabl2.terms.stratego.TermIndex;
import mb.nabl2.terms.stratego.TermOrigin;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.metaborg.core.MetaborgException;
import org.metaborg.core.analysis.AnalysisException;
import org.metaborg.core.analysis.IAnalyzeResults;
import org.metaborg.core.context.IContext;
import org.metaborg.core.language.FacetContribution;
import org.metaborg.core.language.ILanguageImpl;
import org.metaborg.core.messages.IMessage;
import org.metaborg.core.messages.MessageFactory;
import org.metaborg.core.messages.MessageSeverity;
import org.metaborg.core.resource.IResourceService;
import org.metaborg.core.unit.IUnit;
import org.metaborg.spoofax.core.analysis.AnalysisCommon;
import org.metaborg.spoofax.core.analysis.AnalysisFacet;
import org.metaborg.spoofax.core.analysis.ISpoofaxAnalyzeResult;
import org.metaborg.spoofax.core.analysis.ISpoofaxAnalyzeResults;
import org.metaborg.spoofax.core.analysis.ISpoofaxAnalyzer;
import org.metaborg.spoofax.core.analysis.SpoofaxAnalyzeResult;
import org.metaborg.spoofax.core.analysis.SpoofaxAnalyzeResults;
import org.metaborg.spoofax.core.context.constraint.IConstraintContext;
import org.metaborg.spoofax.core.stratego.IStrategoCommon;
import org.metaborg.spoofax.core.stratego.IStrategoRuntimeService;
import org.metaborg.spoofax.core.tracing.ISpoofaxTracingService;
import org.metaborg.spoofax.core.unit.AnalyzeContrib;
import org.metaborg.spoofax.core.unit.AnalyzeUpdateData;
import org.metaborg.spoofax.core.unit.ISpoofaxAnalyzeUnit;
import org.metaborg.spoofax.core.unit.ISpoofaxAnalyzeUnitUpdate;
import org.metaborg.spoofax.core.unit.ISpoofaxParseUnit;
import org.metaborg.spoofax.core.unit.ISpoofaxUnitService;
import org.metaborg.util.Ref;
import org.metaborg.util.collection.ImList;
import org.metaborg.util.collection.ListMultimap;
import org.metaborg.util.iterators.Iterables2;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;
import org.metaborg.util.task.ICancel;
import org.metaborg.util.task.IProgress;
import org.metaborg.util.time.Timer;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.IStrategoTuple;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.terms.util.TermUtils;
import org.strategoxt.HybridInterpreter;

public abstract class AbstractConstraintAnalyzer
implements ISpoofaxAnalyzer {
    private static final ILogger logger = LoggerUtils.logger(AbstractConstraintAnalyzer.class);
    protected final AnalysisCommon analysisCommon;
    protected final IResourceService resourceService;
    protected final IStrategoRuntimeService runtimeService;
    protected final IStrategoCommon strategoCommon;
    protected final ISpoofaxTracingService tracingService;
    protected final ISpoofaxUnitService unitService;
    protected final ITermFactory termFactory;

    public AbstractConstraintAnalyzer(AnalysisCommon analysisCommon, IResourceService resourceService, IStrategoRuntimeService runtimeService, IStrategoCommon strategoCommon, ITermFactory termFactory, ISpoofaxTracingService tracingService, ISpoofaxUnitService unitService) {
        this.analysisCommon = analysisCommon;
        this.resourceService = resourceService;
        this.runtimeService = runtimeService;
        this.strategoCommon = strategoCommon;
        this.tracingService = tracingService;
        this.unitService = unitService;
        this.termFactory = termFactory;
    }

    protected abstract boolean multifile();

    @Override
    public ISpoofaxAnalyzeResult analyze(ISpoofaxParseUnit input, IContext genericContext, IProgress progress, ICancel cancel) throws AnalysisException {
        IAnalyzeResults results = this.analyzeAll((Iterable)Iterables2.singleton(input), genericContext, progress, cancel);
        if (results.results().isEmpty() && results.updates().isEmpty()) {
            throw new AnalysisException(genericContext, "Analysis failed, no result was returned.");
        }
        ISpoofaxAnalyzeUnit unitResult = (ISpoofaxAnalyzeUnit)Iterables2.getOnlyElement(results.results());
        return new SpoofaxAnalyzeResult(unitResult, results.updates(), results.context());
    }

    @Override
    public ISpoofaxAnalyzeResults analyzeAll(Iterable<ISpoofaxParseUnit> inputs, IContext genericContext, IProgress progress, ICancel cancel) throws AnalysisException {
        ISpoofaxAnalyzeResults iSpoofaxAnalyzeResults;
        HybridInterpreter runtime;
        IConstraintContext context;
        try {
            context = (IConstraintContext)genericContext;
        }
        catch (ClassCastException ex) {
            throw new AnalysisException(genericContext, "Constraint context required.", ex);
        }
        ILanguageImpl langImpl = context.language();
        FacetContribution<AnalysisFacet> facetContribution = langImpl.facetContribution(AnalysisFacet.class);
        if (facetContribution == null) {
            logger.debug("No analysis required for {}", langImpl);
            return new SpoofaxAnalyzeResults(context);
        }
        AnalysisFacet facet = (AnalysisFacet)facetContribution.facet;
        try {
            runtime = this.runtimeService.runtime(facetContribution.contributor, context);
        }
        catch (MetaborgException e) {
            throw new AnalysisException(context, "Failed to get Stratego runtime", e);
        }
        HashMap<String, ISpoofaxParseUnit> changed = new HashMap<String, ISpoofaxParseUnit>();
        HashMap<String, ISpoofaxAnalyzeUnit> removed = new HashMap<String, ISpoofaxAnalyzeUnit>();
        HashMap<String, ISpoofaxAnalyzeUnit> invalid = new HashMap<String, ISpoofaxAnalyzeUnit>();
        for (ISpoofaxParseUnit input : inputs) {
            if (input.detached() || input.source() == null) {
                logger.warn("Ignoring detached units");
                continue;
            }
            String source = context.resourceKey(input.source());
            if (!input.valid() || !input.success()) {
                invalid.put(source, (ISpoofaxAnalyzeUnit)this.unitService.emptyAnalyzeUnit(input, context));
                continue;
            }
            if (!this.isEmptyAST(input.ast())) {
                changed.put(source, input);
                continue;
            }
            removed.put(source, (ISpoofaxAnalyzeUnit)this.unitService.emptyAnalyzeUnit(input, context));
        }
        Timer timer = new Timer(true);
        try {
            iSpoofaxAnalyzeResults = this.doAnalysis(changed, removed, invalid, context, runtime, facet.strategyName, progress, cancel);
        }
        catch (Throwable throwable) {
            logger.debug("Analysis finished in {} s", (double)timer.stop() / 1.0E9);
            throw throwable;
        }
        logger.debug("Analysis finished in {} s", (double)timer.stop() / 1.0E9);
        return iSpoofaxAnalyzeResults;
    }

    private boolean isEmptyAST(IStrategoTerm ast) {
        return TermUtils.isTuple(ast, 0);
    }

    private ISpoofaxAnalyzeResults doAnalysis(Map<String, ISpoofaxParseUnit> changed, Map<String, ISpoofaxAnalyzeUnit> removed, Map<String, ISpoofaxAnalyzeUnit> invalid, IConstraintContext context, HybridInterpreter runtime, String strategy, IProgress progress, ICancel cancel) throws AnalysisException {
        Ref<IStrategoTerm> projectChange = new Ref<IStrategoTerm>();
        ArrayList<IStrategoTerm> changes = new ArrayList<IStrategoTerm>();
        HashMap<String, Expect> expects = new HashMap<String, Expect>();
        boolean realChange = this.computeChanges(context, changed, removed, projectChange, changes, expects);
        HashMap<String, IStrategoTerm> results = new HashMap<String, IStrategoTerm>();
        if (realChange) {
            this.callAnalysis(context, changed, projectChange.get(), changes, expects, runtime, strategy, cancel, progress, results);
        }
        HashSet<ISpoofaxAnalyzeUnit> fullResults = new HashSet<ISpoofaxAnalyzeUnit>();
        HashSet<ISpoofaxAnalyzeUnitUpdate> updateResults = new HashSet<ISpoofaxAnalyzeUnitUpdate>();
        ListMultimap<FileName, IMessage> messages = new ListMultimap<FileName, IMessage>();
        this.processResults(changed, expects, results, messages);
        for (Expect expect : expects.values()) {
            Object fileMessages = messages.get(expect.resource().getName());
            expect.result((Collection<IMessage>)fileMessages, (Collection<ISpoofaxAnalyzeUnit>)fullResults, (Collection<ISpoofaxAnalyzeUnitUpdate>)updateResults);
        }
        fullResults.addAll(removed.values());
        fullResults.addAll(invalid.values());
        return new SpoofaxAnalyzeResults(fullResults, updateResults, context, null);
    }

    private boolean computeChanges(IConstraintContext context, Map<String, ISpoofaxParseUnit> changed, Map<String, ISpoofaxAnalyzeUnit> removed, Ref<IStrategoTerm> projectChange, List<IStrategoTerm> changes, Map<String, Expect> expects) {
        IStrategoTerm change;
        IConstraintContext.Entry ctxEntry;
        String resource;
        boolean realChange = false;
        if (this.multifile()) {
            IStrategoTerm change2;
            Expect expect;
            String string = context.resourceKey(context.location());
            IStrategoTerm projectAst = this.projectAST(string);
            if (context.contains(string)) {
                IConstraintContext.Entry ctxEntry2 = context.get(string);
                IStrategoTerm change3 = this.build("Cached", ctxEntry2.analysis());
                expect = new CachedUpdate(string, projectAst.hashCode(), projectAst, ctxEntry2.analysis(), ctxEntry2.errors(), ctxEntry2.warnings(), ctxEntry2.notes(), ctxEntry2.exceptions(), context);
                context.remove(string);
            } else {
                change2 = this.build("Added", projectAst);
                expect = new ProjectFull(string, projectAst.hashCode(), projectAst, context);
                realChange = true;
            }
            expects.put(string, expect);
            projectChange.set(this.termFactory.makeTuple(this.termFactory.makeString(string), change2));
        } else {
            projectChange.set(null);
        }
        for (Map.Entry<String, ISpoofaxAnalyzeUnit> entry : removed.entrySet()) {
            resource = entry.getKey();
            if (!context.contains(entry.getKey())) continue;
            ctxEntry = context.get(resource);
            changes.add(this.termFactory.makeTuple(this.termFactory.makeString(resource), this.build("Removed", ctxEntry.analysis())));
            context.remove(resource);
            realChange = true;
        }
        for (Map.Entry<String, IUnit> entry : changed.entrySet()) {
            Expect expect;
            resource = entry.getKey();
            ISpoofaxParseUnit input = (ISpoofaxParseUnit)entry.getValue();
            IStrategoTerm parseAst = input.ast();
            int parseHash = parseAst.hashCode();
            if (context.contains(resource)) {
                IConstraintContext.Entry ctxEntry3 = context.get(resource);
                IStrategoTerm analyzedAst = ctxEntry3.analyzedAst();
                if (ctxEntry3.parseHash() != parseHash || analyzedAst == null) {
                    change = this.build("Changed", parseAst, ctxEntry3.analysis());
                    expect = new ChangedFull(resource, parseHash, input, context);
                    realChange = true;
                } else {
                    change = this.build("Cached", ctxEntry3.analysis());
                    expect = new UpdateFull(resource, parseHash, analyzedAst, ctxEntry3.analysis(), ctxEntry3.errors(), ctxEntry3.warnings(), ctxEntry3.notes(), ctxEntry3.exceptions(), input, context);
                }
            } else {
                change = this.build("Added", parseAst);
                expect = new ChangedFull(resource, parseHash, input, context);
                realChange = true;
            }
            context.remove(resource);
            expects.put(resource, expect);
            changes.add(this.termFactory.makeTuple(this.termFactory.makeString(resource), change));
        }
        if (this.multifile()) {
            for (Map.Entry<String, Object> entry : context.entrySet()) {
                resource = entry.getKey();
                if (changed.containsKey(resource)) continue;
                ctxEntry = (IConstraintContext.Entry)entry.getValue();
                IStrategoTerm analyzedAst = ctxEntry.analyzedAst();
                IStrategoTerm analysis = ctxEntry.analysis();
                change = this.build("Cached", analysis);
                expects.put(resource, new CachedUpdate(resource, ctxEntry.parseHash(), analyzedAst, analysis, ctxEntry.errors(), ctxEntry.warnings(), ctxEntry.notes(), ctxEntry.exceptions(), context));
                changes.add(this.termFactory.makeTuple(this.termFactory.makeString(resource), change));
            }
        }
        return realChange;
    }

    private void callAnalysis(IConstraintContext context, Map<String, ISpoofaxParseUnit> changed, IStrategoTerm projectChange, List<IStrategoTerm> changes, Map<String, Expect> expects, HybridInterpreter runtime, String strategy, ICancel cancel, IProgress progress, Map<String, IStrategoTerm> results) throws AnalysisException {
        IStrategoTerm allResultsTerm;
        IStrategoTerm action = this.multifile() ? this.build("AnalyzeMulti", projectChange, this.termFactory.makeList(changes), B.blob(progress), B.blob(cancel)) : this.build("AnalyzeSingle", this.termFactory.makeList(changes), B.blob(progress), B.blob(cancel));
        try {
            allResultsTerm = this.strategoCommon.invoke(runtime, action, strategy);
        }
        catch (MetaborgException ex) {
            throw new AnalysisException((IContext)context, (Throwable)ex);
        }
        if (allResultsTerm == null) {
            throw new AnalysisException((IContext)context, "Analysis strategy failed");
        }
        List<IStrategoTerm> allResultTerms = this.match(allResultsTerm, "AnalysisResult", 1);
        if (allResultTerms == null) {
            throw new AnalysisException((IContext)context, "Invalid analysis result, got " + allResultsTerm);
        }
        IStrategoTerm resultsTerm = allResultTerms.get(0);
        if (!TermUtils.isList(resultsTerm)) {
            throw new AnalysisException((IContext)context, "Expected list of results, got " + resultsTerm);
        }
        IStrategoTerm[] iStrategoTermArray = resultsTerm.getAllSubterms();
        int n = iStrategoTermArray.length;
        int n2 = 0;
        while (n2 < n) {
            IStrategoTerm iStrategoTerm = iStrategoTermArray[n2];
            if (!TermUtils.isTuple(iStrategoTerm, 2)) {
                throw new AnalysisException((IContext)context, "Expected tuple result, got " + iStrategoTerm);
            }
            IStrategoTerm resourceTerm = iStrategoTerm.getSubterm(0);
            IStrategoTerm resultTerm = iStrategoTerm.getSubterm(1);
            if (!TermUtils.isString(resourceTerm)) {
                throw new AnalysisException((IContext)context, "Expected resource string as first component, got " + resourceTerm);
            }
            String resource = TermUtils.toJavaString(resourceTerm);
            results.put(resource, resultTerm);
            ++n2;
        }
        for (Map.Entry<String, Expect> entry : expects.entrySet()) {
            String resource = entry.getKey();
            Expect expect = entry.getValue();
            if (!expect.requireResult() || results.containsKey(resource)) continue;
            expect.failMessage("Missing analysis result");
        }
    }

    private void processResults(Map<String, ISpoofaxParseUnit> changed, Map<String, Expect> expects, Map<String, IStrategoTerm> results, ListMultimap<FileName, IMessage> messages) {
        for (Map.Entry<String, IStrategoTerm> entry : results.entrySet()) {
            String resource = entry.getKey();
            IStrategoTerm result = entry.getValue();
            if (expects.containsKey(resource)) {
                expects.get(resource).accept(result);
                continue;
            }
            logger.warn("Got result for invalid file.");
        }
        for (Map.Entry<String, Object> entry : expects.entrySet()) {
            Expect expect = (Expect)entry.getValue();
            ListMultimap<FileName, IMessage> msgs = expect.messages();
            messages.putAll(msgs);
        }
    }

    private IStrategoTerm projectAST(String resource) {
        IStrategoTuple ast = this.termFactory.makeTuple(new IStrategoTerm[0]);
        ast = StrategoTermIndices.put(TermIndex.of(resource, 0), ast, this.termFactory);
        TermOrigin.of(resource).put(ast);
        return ast;
    }

    protected boolean success(Collection<IMessage> messages) {
        return messages.stream().noneMatch(m -> m.severity().equals(MessageSeverity.ERROR));
    }

    protected IStrategoTerm build(String op, IStrategoTerm ... subterms) {
        return this.termFactory.makeAppl(this.termFactory.makeConstructor(op, subterms.length), subterms);
    }

    @Nullable
    protected List<IStrategoTerm> match(IStrategoTerm term, String op, int n) {
        if (term == null || !TermUtils.isAppl(term) || !TermUtils.isAppl(term, op, n)) {
            return null;
        }
        return ImList.Immutable.copyOf(term.getAllSubterms());
    }

    private class CachedUpdate
    extends Expect {
        private IStrategoTerm analyzedAst;
        private IStrategoTerm analysis;

        private CachedUpdate(String resource, int parseHash, IStrategoTerm analyzedAst, IStrategoTerm analysis, IStrategoTerm errors, IStrategoTerm warnings, IStrategoTerm notes, List<String> exceptions, IConstraintContext context) {
            super(resource, parseHash, errors, warnings, notes, exceptions, context);
            this.analyzedAst = analyzedAst;
            this.analysis = analysis;
        }

        @Override
        boolean requireResult() {
            return false;
        }

        @Override
        public void accept(IStrategoTerm result) {
            List<IStrategoTerm> results = AbstractConstraintAnalyzer.this.match(result, "Update", 4);
            if (results != null) {
                this.analysis = results.get(0);
                this.resultMessages(results.get(1), results.get(2), results.get(3));
            } else if (AbstractConstraintAnalyzer.this.match(result, "Failed", 0) != null) {
                this.failMessage("Analysis failed");
            } else {
                this.analyzedAst = null;
                this.analysis = null;
                this.failMessage("Analysis returned incorrect result");
            }
        }

        @Override
        public void result(Collection<IMessage> messages, Collection<ISpoofaxAnalyzeUnit> fullResults, Collection<ISpoofaxAnalyzeUnitUpdate> updateResults) {
            if (this.analysis != null) {
                this.context.put(this.resource, this.parseHash, this.analyzedAst, this.analysis, this.errors, this.warnings, this.notes, (List<String>)this.exceptions);
            } else {
                this.context.remove(this.resource);
            }
            updateResults.add(AbstractConstraintAnalyzer.this.unitService.analyzeUnitUpdate(this.resource(), new AnalyzeUpdateData(messages), this.context));
        }
    }

    private class ChangedFull
    extends Expect {
        private ISpoofaxParseUnit input;
        private IStrategoTerm analyzedAst;
        private IStrategoTerm analysis;

        public ChangedFull(String resource, int parseHash, ISpoofaxParseUnit input, IConstraintContext context) {
            super(resource, parseHash, null, null, null, null, context);
            this.input = input;
        }

        @Override
        boolean requireResult() {
            return true;
        }

        @Override
        public void accept(IStrategoTerm result) {
            List<IStrategoTerm> results = AbstractConstraintAnalyzer.this.match(result, "Full", 5);
            if (results != null) {
                this.analyzedAst = results.get(0);
                this.analysis = results.get(1);
                this.resultMessages(results.get(2), results.get(3), results.get(4));
            } else if (AbstractConstraintAnalyzer.this.match(result, "Failed", 0) != null) {
                this.failMessage("Analysis failed");
            } else {
                this.analyzedAst = null;
                this.analysis = null;
                this.failMessage("Analysis returned incorrect result");
            }
        }

        @Override
        public void result(Collection<IMessage> messages, Collection<ISpoofaxAnalyzeUnit> fullResults, Collection<ISpoofaxAnalyzeUnitUpdate> updateResults) {
            if (!this.input.detached()) {
                if (this.analysis != null) {
                    this.context.put(this.resource, this.parseHash, this.analyzedAst, this.analysis, this.errors, this.warnings, this.notes, (List<String>)this.exceptions);
                } else {
                    this.context.remove(this.resource);
                }
            }
            fullResults.add(AbstractConstraintAnalyzer.this.unitService.analyzeUnit(this.input, new AnalyzeContrib(this.analyzedAst != null, AbstractConstraintAnalyzer.this.success(messages), true, this.analyzedAst, messages, -1L), this.context));
        }
    }

    private abstract class Expect {
        protected final String resource;
        protected final int parseHash;
        protected final IConstraintContext context;
        protected IStrategoTerm errors;
        protected IStrategoTerm warnings;
        protected IStrategoTerm notes;
        protected List<String> exceptions;

        protected Expect(String resource, int parseHash, IStrategoTerm errors, IStrategoTerm warnings, IStrategoTerm notes, List<String> exceptions, IConstraintContext context) {
            this.resource = resource;
            this.parseHash = parseHash;
            this.errors = errors;
            this.warnings = warnings;
            this.notes = notes;
            this.exceptions = exceptions != null ? new ArrayList<String>(exceptions) : new ArrayList();
            this.context = context;
        }

        protected FileObject resource() {
            return this.context.keyResource(this.resource);
        }

        abstract boolean requireResult();

        protected void resultMessages(IStrategoTerm errors, IStrategoTerm warnings, IStrategoTerm notes) {
            this.errors = errors;
            this.warnings = warnings;
            this.notes = notes;
            this.exceptions.clear();
        }

        protected void failMessage(String message) {
            this.exceptions.add(message);
        }

        abstract void accept(IStrategoTerm var1);

        abstract void result(Collection<IMessage> var1, Collection<ISpoofaxAnalyzeUnit> var2, Collection<ISpoofaxAnalyzeUnitUpdate> var3);

        ListMultimap<FileName, IMessage> messages() {
            ListMultimap<FileName, IMessage> messages = new ListMultimap<FileName, IMessage>();
            this.messages(MessageSeverity.ERROR, this.errors, messages);
            this.messages(MessageSeverity.WARNING, this.warnings, messages);
            this.messages(MessageSeverity.NOTE, this.notes, messages);
            for (String exception : this.exceptions) {
                messages.put(this.resource().getName(), MessageFactory.newAnalysisErrorAtTop(this.resource(), exception, null));
            }
            return messages;
        }

        private void messages(MessageSeverity severity, IStrategoTerm messagesTerm, ListMultimap<FileName, IMessage> messages) {
            if (messagesTerm == null) {
                return;
            }
            FileName fileName = this.resource().getName();
            if (AbstractConstraintAnalyzer.this.multifile()) {
                for (IMessage m : AbstractConstraintAnalyzer.this.analysisCommon.messages(severity, messagesTerm)) {
                    if (m.source() == null) {
                        m = MessageFactory.newAnalysisMessageAtTop(this.resource(), m.message(), m.severity(), m.exception());
                    }
                    messages.put(m.source() != null ? m.source().getName() : fileName, m);
                }
            } else {
                for (IMessage m : AbstractConstraintAnalyzer.this.analysisCommon.messages(this.resource(), severity, messagesTerm)) {
                    if (m.source() == null) {
                        m = MessageFactory.newAnalysisMessageAtTop(this.resource(), m.message(), m.severity(), m.exception());
                    }
                    messages.put(fileName, m);
                }
            }
        }
    }

    private class ProjectFull
    extends Expect {
        private IStrategoTerm analyzedAst;
        private IStrategoTerm analysis;

        public ProjectFull(String resource, int parseHash, IStrategoTerm analyzedAst, IConstraintContext context) {
            super(resource, parseHash, null, null, null, null, context);
            this.analyzedAst = analyzedAst;
        }

        @Override
        boolean requireResult() {
            return true;
        }

        @Override
        public void accept(IStrategoTerm result) {
            List<IStrategoTerm> results = AbstractConstraintAnalyzer.this.match(result, "Full", 5);
            if (results != null) {
                this.analysis = results.get(1);
                this.resultMessages(results.get(2), results.get(3), results.get(4));
            } else if (AbstractConstraintAnalyzer.this.match(result, "Failed", 0) != null) {
                this.failMessage("Analysis failed");
            } else {
                this.analyzedAst = null;
                this.analysis = null;
                this.failMessage("Analysis returned incorrect result");
            }
        }

        @Override
        public void result(Collection<IMessage> messages, Collection<ISpoofaxAnalyzeUnit> fullResults, Collection<ISpoofaxAnalyzeUnitUpdate> updateResults) {
            if (this.analysis != null) {
                this.context.put(this.resource, this.parseHash, this.analyzedAst, this.analysis, this.errors, this.warnings, this.notes, (List<String>)this.exceptions);
            } else {
                this.context.remove(this.resource);
            }
            updateResults.add(AbstractConstraintAnalyzer.this.unitService.analyzeUnitUpdate(this.resource(), new AnalyzeUpdateData(messages), this.context));
        }
    }

    private class UpdateFull
    extends Expect {
        private ISpoofaxParseUnit input;
        private IStrategoTerm analyzedAst;
        private IStrategoTerm analysis;

        public UpdateFull(String resource, int parseHash, IStrategoTerm analyzedAst, IStrategoTerm analysis, IStrategoTerm errors, IStrategoTerm warnings, IStrategoTerm notes, List<String> exceptions, ISpoofaxParseUnit input, IConstraintContext context) {
            super(resource, parseHash, errors, warnings, notes, exceptions, context);
            this.input = input;
            this.analyzedAst = analyzedAst;
            this.analysis = analysis;
        }

        @Override
        boolean requireResult() {
            return false;
        }

        @Override
        public void accept(IStrategoTerm result) {
            List<IStrategoTerm> results = AbstractConstraintAnalyzer.this.match(result, "Update", 4);
            if (results != null) {
                this.analysis = results.get(0);
                this.resultMessages(results.get(1), results.get(2), results.get(3));
            } else if (AbstractConstraintAnalyzer.this.match(result, "Failed", 0) != null) {
                this.failMessage("Analysis failed");
            } else {
                this.analyzedAst = null;
                this.analysis = null;
                this.failMessage("Analysis returned incorrect result");
            }
        }

        @Override
        public void result(Collection<IMessage> messages, Collection<ISpoofaxAnalyzeUnit> fullResults, Collection<ISpoofaxAnalyzeUnitUpdate> updateResults) {
            if (this.analysis != null) {
                this.context.put(this.resource, this.parseHash, this.analyzedAst, this.analysis, this.errors, this.warnings, this.notes, (List<String>)this.exceptions);
            } else {
                this.context.remove(this.resource);
            }
            fullResults.add(AbstractConstraintAnalyzer.this.unitService.analyzeUnit(this.input, new AnalyzeContrib(this.analyzedAst != null, AbstractConstraintAnalyzer.this.success(messages), true, this.analyzedAst, messages, -1L), this.context));
        }
    }
}

