/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.sdf2table.grammar;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.metaborg.sdf2table.deepconflicts.ContextualProduction;
import org.metaborg.sdf2table.deepconflicts.ContextualSymbol;
import org.metaborg.sdf2table.grammar.ConstructorAttribute;
import org.metaborg.sdf2table.grammar.GrammarFactory;
import org.metaborg.sdf2table.grammar.IAttribute;
import org.metaborg.sdf2table.grammar.INormGrammar;
import org.metaborg.sdf2table.grammar.IProduction;
import org.metaborg.sdf2table.grammar.ISymbol;
import org.metaborg.sdf2table.grammar.Priority;
import org.metaborg.sdf2table.grammar.Production;
import org.metaborg.sdf2table.grammar.ProductionReference;
import org.metaborg.sdf2table.grammar.Symbol;
import org.metaborg.sdf2table.grammar.UniqueProduction;
import org.metaborg.util.collection.BiMap2;
import org.metaborg.util.collection.LinkedSetMultimap;
import org.metaborg.util.collection.SetMultimap;

public class NormGrammar
implements INormGrammar,
Serializable {
    private static final long serialVersionUID = -13739894962185282L;
    private final Set<String> modulesRead = new HashSet<String>();
    private final GrammarFactory gf = new GrammarFactory();
    private IProduction initialProduction;
    private final Set<ISymbol> symbols;
    private final Map<ProductionReference, Production> sortConsProductionMapping;
    private final SetMultimap<IProduction, IAttribute> productionAttributesMapping;
    private final Map<IProduction, ConstructorAttribute> constructors;
    private final Map<UniqueProduction, Production> uniqueProductionMapping = new LinkedHashMap<UniqueProduction, Production>();
    private final BiMap2<IProduction, ContextualProduction> prodContextualProdMapping;
    private final Set<ContextualProduction> derivedContextualProds;
    private final Set<ContextualSymbol> contextualSymbols;
    private final SetMultimap<ISymbol, ISymbol> leftRecursiveSymbolsMapping;
    private final SetMultimap<ISymbol, ISymbol> rightRecursiveSymbolsMapping;
    private final LinkedSetMultimap<Symbol, Production> longestMatchProdsFront;
    private final LinkedSetMultimap<Symbol, Production> shortestMatchProdsFront;
    private final LinkedSetMultimap<Symbol, Production> longestMatchProdsBack;
    private final LinkedSetMultimap<Symbol, Production> shortestMatchProdsBack;
    private final Set<Priority> transitivePriorities;
    private final Set<Priority> nonTransitivePriorities;
    private final SetMultimap<Priority, Integer> priorities;
    private final SetMultimap<Priority, Integer> indexedPriorities;
    private final Set<Production> productionsOnPriorities;
    private final SetMultimap<Priority, Integer> transitivePriorityArgs;
    private final SetMultimap<Priority, Integer> nonTransitivePriorityArgs;
    private final SetMultimap<Production, Priority> higherPriorityProductions;
    private final HashMap<String, Symbol> cacheSymbolsRead;
    private final HashMap<String, Production> cacheProductionsRead;
    private final SetMultimap<ISymbol, IProduction> symbolProductionsMapping;
    private final SetMultimap<ISymbol, IProduction> literalProductionsMapping;
    private final SetMultimap<ISymbol, IProduction> expressionGrammars;
    private final Set<Set<IProduction>> combinedExpressionGrammars;
    private final SetMultimap<ISymbol, ISymbol> leftDerivable;
    private final SetMultimap<ISymbol, ISymbol> rightDerivable;

    public NormGrammar() {
        this.sortConsProductionMapping = new HashMap<ProductionReference, Production>();
        this.prodContextualProdMapping = new BiMap2();
        this.leftRecursiveSymbolsMapping = new SetMultimap();
        this.rightRecursiveSymbolsMapping = new SetMultimap();
        this.derivedContextualProds = new HashSet<ContextualProduction>();
        this.contextualSymbols = new HashSet<ContextualSymbol>();
        this.longestMatchProdsFront = new LinkedSetMultimap();
        this.longestMatchProdsBack = new LinkedSetMultimap();
        this.shortestMatchProdsFront = new LinkedSetMultimap();
        this.shortestMatchProdsBack = new LinkedSetMultimap();
        this.productionAttributesMapping = new SetMultimap();
        this.priorities = new SetMultimap();
        this.indexedPriorities = new SetMultimap();
        this.constructors = new HashMap<IProduction, ConstructorAttribute>();
        this.transitivePriorities = new HashSet<Priority>();
        this.nonTransitivePriorities = new HashSet<Priority>();
        this.productionsOnPriorities = new HashSet<Production>();
        this.transitivePriorityArgs = new SetMultimap();
        this.nonTransitivePriorityArgs = new SetMultimap();
        this.higherPriorityProductions = new SetMultimap();
        this.symbolProductionsMapping = new SetMultimap();
        this.cacheSymbolsRead = new HashMap();
        this.cacheProductionsRead = new HashMap();
        this.symbols = new HashSet<ISymbol>();
        this.literalProductionsMapping = new SetMultimap();
        this.expressionGrammars = new SetMultimap();
        this.combinedExpressionGrammars = new HashSet<Set<IProduction>>();
        this.leftDerivable = new SetMultimap();
        this.rightDerivable = new SetMultimap();
    }

    public Map<UniqueProduction, Production> syntax() {
        return this.getUniqueProductionMapping();
    }

    public void priorityTransitiveClosure() {
        for (Production intermediate_prod : this.getProductionsOnPriorities()) {
            for (Production first_prod : this.getProductionsOnPriorities()) {
                for (Production second_prod : this.getProductionsOnPriorities()) {
                    Priority first_sec = this.gf.createPriority(first_prod, second_prod, true);
                    Priority first_k = this.gf.createPriority(first_prod, intermediate_prod, true);
                    Priority k_second = this.gf.createPriority(intermediate_prod, second_prod, true);
                    if (!this.getTransitivePriorities().contains(first_sec)) {
                        if (!this.getTransitivePriorities().contains(first_k) || !this.getTransitivePriorities().contains(k_second)) continue;
                        this.getTransitivePriorities().add(first_sec);
                        this.getTransitivePriorityArgs().putAll(first_sec, (Collection<Integer>)this.getTransitivePriorityArgs().get(first_k));
                        continue;
                    }
                    if (!this.getTransitivePriorities().contains(first_k) || !this.getTransitivePriorities().contains(k_second)) continue;
                    this.getTransitivePriorityArgs().putAll(first_sec, (Collection<Integer>)this.getTransitivePriorityArgs().get(first_k));
                }
            }
        }
        this.priorities.putAll(this.getNonTransitivePriorityArgs());
        this.priorities.putAll(this.getTransitivePriorityArgs());
    }

    public IProduction getInitialProduction() {
        return this.initialProduction;
    }

    public SetMultimap<Priority, Integer> priorities() {
        return this.priorities;
    }

    public Set<String> getModulesRead() {
        return this.modulesRead;
    }

    public Set<ISymbol> getSymbols() {
        return this.symbols;
    }

    public Map<ProductionReference, Production> getSortConsProductionMapping() {
        return this.sortConsProductionMapping;
    }

    public SetMultimap<IProduction, IAttribute> getProductionAttributesMapping() {
        return this.productionAttributesMapping;
    }

    public Map<UniqueProduction, Production> getUniqueProductionMapping() {
        return this.uniqueProductionMapping;
    }

    public BiMap2<IProduction, ContextualProduction> getProdContextualProdMapping() {
        return this.prodContextualProdMapping;
    }

    public Set<ContextualProduction> getDerivedContextualProds() {
        return this.derivedContextualProds;
    }

    public Set<ContextualSymbol> getContextualSymbols() {
        return this.contextualSymbols;
    }

    public SetMultimap<ISymbol, ISymbol> getLeftRecursiveSymbolsMapping() {
        return this.leftRecursiveSymbolsMapping;
    }

    public SetMultimap<ISymbol, ISymbol> getRightRecursiveSymbolsMapping() {
        return this.rightRecursiveSymbolsMapping;
    }

    public LinkedSetMultimap<Symbol, Production> getLongestMatchProdsFront() {
        return this.longestMatchProdsFront;
    }

    public LinkedSetMultimap<Symbol, Production> getLongestMatchProdsBack() {
        return this.longestMatchProdsBack;
    }

    public LinkedSetMultimap<Symbol, Production> getShortestMatchProdsFront() {
        return this.shortestMatchProdsFront;
    }

    public LinkedSetMultimap<Symbol, Production> getShortestMatchProdsBack() {
        return this.shortestMatchProdsBack;
    }

    public Set<Priority> getTransitivePriorities() {
        return this.transitivePriorities;
    }

    public Set<Priority> getNonTransitivePriorities() {
        return this.nonTransitivePriorities;
    }

    public Set<Production> getProductionsOnPriorities() {
        return this.productionsOnPriorities;
    }

    public SetMultimap<Priority, Integer> getTransitivePriorityArgs() {
        return this.transitivePriorityArgs;
    }

    public SetMultimap<Priority, Integer> getNonTransitivePriorityArgs() {
        return this.nonTransitivePriorityArgs;
    }

    public HashMap<String, Symbol> getCacheSymbolsRead() {
        return this.cacheSymbolsRead;
    }

    public HashMap<String, Production> getCacheProductionsRead() {
        return this.cacheProductionsRead;
    }

    public SetMultimap<ISymbol, IProduction> getSymbolProductionsMapping() {
        return this.symbolProductionsMapping;
    }

    public SetMultimap<Production, Priority> getHigherPriorityProductions() {
        return this.higherPriorityProductions;
    }

    public void normalizeFollowRestrictionLookahead() {
        for (ISymbol s : this.symbols) {
            s.normalizeFollowRestrictionLookahead();
        }
    }

    public Map<IProduction, ConstructorAttribute> getConstructors() {
        return this.constructors;
    }

    public SetMultimap<ISymbol, IProduction> getLiteralProductionsMapping() {
        return this.literalProductionsMapping;
    }

    public SetMultimap<ISymbol, IProduction> getExpressionGrammars() {
        return this.expressionGrammars;
    }

    public Set<Set<IProduction>> getCombinedExpressionGrammars() {
        return this.combinedExpressionGrammars;
    }

    public void setInitialProduction(Production prod) {
        this.initialProduction = prod;
    }

    public SetMultimap<Priority, Integer> getIndexedPriorities() {
        return this.indexedPriorities;
    }

    public GrammarFactory getGrammarFactory() {
        return this.gf;
    }

    public void cleanupGrammar() {
        this.cacheProductionsRead.clear();
        this.cacheSymbolsRead.clear();
        this.combinedExpressionGrammars.clear();
        this.contextualSymbols.clear();
        this.derivedContextualProds.clear();
        this.expressionGrammars.clear();
        this.leftRecursiveSymbolsMapping.clear();
        this.rightRecursiveSymbolsMapping.clear();
        this.literalProductionsMapping.clear();
        this.longestMatchProdsBack.clear();
        this.longestMatchProdsFront.clear();
        this.nonTransitivePriorities.clear();
        this.nonTransitivePriorityArgs.clear();
        this.productionsOnPriorities.clear();
        this.symbolProductionsMapping.clear();
        this.transitivePriorities.clear();
        this.transitivePriorityArgs.clear();
    }

    public SetMultimap<ISymbol, ISymbol> getLeftDerivable() {
        return this.leftDerivable;
    }

    public SetMultimap<ISymbol, ISymbol> getRightDerivable() {
        return this.rightDerivable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NormGrammar that = (NormGrammar)o;
        return Objects.equals(this.modulesRead, that.modulesRead) && Objects.equals(this.gf, that.gf) && Objects.equals(this.initialProduction, that.initialProduction) && Objects.equals(this.symbols, that.symbols) && Objects.equals(this.sortConsProductionMapping, that.sortConsProductionMapping) && Objects.equals(this.productionAttributesMapping, that.productionAttributesMapping) && Objects.equals(this.constructors, that.constructors) && Objects.equals(this.uniqueProductionMapping, that.uniqueProductionMapping) && Objects.equals(this.prodContextualProdMapping, that.prodContextualProdMapping) && Objects.equals(this.derivedContextualProds, that.derivedContextualProds) && Objects.equals(this.contextualSymbols, that.contextualSymbols) && Objects.equals(this.leftRecursiveSymbolsMapping, that.leftRecursiveSymbolsMapping) && Objects.equals(this.rightRecursiveSymbolsMapping, that.rightRecursiveSymbolsMapping) && Objects.equals(this.longestMatchProdsFront, that.longestMatchProdsFront) && Objects.equals(this.shortestMatchProdsFront, that.shortestMatchProdsFront) && Objects.equals(this.longestMatchProdsBack, that.longestMatchProdsBack) && Objects.equals(this.shortestMatchProdsBack, that.shortestMatchProdsBack) && Objects.equals(this.transitivePriorities, that.transitivePriorities) && Objects.equals(this.nonTransitivePriorities, that.nonTransitivePriorities) && Objects.equals(this.priorities, that.priorities) && Objects.equals(this.indexedPriorities, that.indexedPriorities) && Objects.equals(this.productionsOnPriorities, that.productionsOnPriorities) && Objects.equals(this.transitivePriorityArgs, that.transitivePriorityArgs) && Objects.equals(this.nonTransitivePriorityArgs, that.nonTransitivePriorityArgs) && Objects.equals(this.higherPriorityProductions, that.higherPriorityProductions) && Objects.equals(this.cacheSymbolsRead, that.cacheSymbolsRead) && Objects.equals(this.cacheProductionsRead, that.cacheProductionsRead) && Objects.equals(this.symbolProductionsMapping, that.symbolProductionsMapping) && Objects.equals(this.literalProductionsMapping, that.literalProductionsMapping) && Objects.equals(this.expressionGrammars, that.expressionGrammars) && Objects.equals(this.combinedExpressionGrammars, that.combinedExpressionGrammars) && Objects.equals(this.leftDerivable, that.leftDerivable) && Objects.equals(this.rightDerivable, that.rightDerivable);
    }

    public int hashCode() {
        return Objects.hash(this.modulesRead, this.gf, this.initialProduction, this.symbols, this.sortConsProductionMapping, this.productionAttributesMapping, this.constructors, this.uniqueProductionMapping, this.prodContextualProdMapping, this.derivedContextualProds, this.contextualSymbols, this.leftRecursiveSymbolsMapping, this.rightRecursiveSymbolsMapping, this.longestMatchProdsFront, this.shortestMatchProdsFront, this.longestMatchProdsBack, this.shortestMatchProdsBack, this.transitivePriorities, this.nonTransitivePriorities, this.priorities, this.indexedPriorities, this.productionsOnPriorities, this.transitivePriorityArgs, this.nonTransitivePriorityArgs, this.higherPriorityProductions, this.cacheSymbolsRead, this.cacheProductionsRead, this.symbolProductionsMapping, this.literalProductionsMapping, this.expressionGrammars, this.combinedExpressionGrammars, this.leftDerivable, this.rightDerivable);
    }
}

