/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.sdf2table.grammar;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.metaborg.parsetable.characterclasses.ICharacterClass;
import org.metaborg.sdf2table.grammar.AltSymbol;
import org.metaborg.sdf2table.grammar.CharacterClassSymbol;
import org.metaborg.sdf2table.grammar.ConstructorAttribute;
import org.metaborg.sdf2table.grammar.ContextFreeSymbol;
import org.metaborg.sdf2table.grammar.DeprecatedAttribute;
import org.metaborg.sdf2table.grammar.EOFSymbol;
import org.metaborg.sdf2table.grammar.FileStartSymbol;
import org.metaborg.sdf2table.grammar.GeneralAttribute;
import org.metaborg.sdf2table.grammar.IterSepSymbol;
import org.metaborg.sdf2table.grammar.IterStarSepSymbol;
import org.metaborg.sdf2table.grammar.IterStarSymbol;
import org.metaborg.sdf2table.grammar.IterSymbol;
import org.metaborg.sdf2table.grammar.Layout;
import org.metaborg.sdf2table.grammar.LayoutConstraintAttribute;
import org.metaborg.sdf2table.grammar.LexicalSymbol;
import org.metaborg.sdf2table.grammar.LiteralType;
import org.metaborg.sdf2table.grammar.OptionalSymbol;
import org.metaborg.sdf2table.grammar.Priority;
import org.metaborg.sdf2table.grammar.Production;
import org.metaborg.sdf2table.grammar.ProductionReference;
import org.metaborg.sdf2table.grammar.SequenceSymbol;
import org.metaborg.sdf2table.grammar.Sort;
import org.metaborg.sdf2table.grammar.StartSymbol;
import org.metaborg.sdf2table.grammar.Symbol;
import org.metaborg.sdf2table.grammar.TermAttribute;
import org.metaborg.sdf2table.grammar.UniqueProduction;
import org.spoofax.interpreter.terms.IStrategoTerm;

public class GrammarFactory
implements Serializable {
    private static final long serialVersionUID = -3963847554036972197L;
    private final Map<List<Object>, AltSymbol> altSymbols = new HashMap<List<Object>, AltSymbol>();
    private final Map<ICharacterClass, CharacterClassSymbol> characterClassSymbols = new HashMap<ICharacterClass, CharacterClassSymbol>();
    private final Map<String, ConstructorAttribute> constructorAttributes = new HashMap<String, ConstructorAttribute>();
    private final Map<Symbol, ContextFreeSymbol> contextFreeSymbols = new HashMap<Symbol, ContextFreeSymbol>();
    private final Map<Symbol, LexicalSymbol> lexicalSymbols = new HashMap<Symbol, LexicalSymbol>();
    private final Map<Symbol, OptionalSymbol> optionalSymbols = new HashMap<Symbol, OptionalSymbol>();
    private final Map<String, DeprecatedAttribute> deprecatedAttributes = new HashMap<String, DeprecatedAttribute>();
    private final Map<String, GeneralAttribute> generalAttributes = new HashMap<String, GeneralAttribute>();
    private final Map<List<Object>, IterSepSymbol> iterSepSymbols = new HashMap<List<Object>, IterSepSymbol>();
    private final Map<List<Object>, IterStarSepSymbol> iterStarSepSymbols = new HashMap<List<Object>, IterStarSepSymbol>();
    private final Map<Symbol, IterStarSymbol> iterStarSymbols = new HashMap<Symbol, IterStarSymbol>();
    private final Map<Symbol, IterSymbol> iterSymbols = new HashMap<Symbol, IterSymbol>();
    private final Map<List<Object>, SequenceSymbol> sequenceSymbols;
    private final Map<List<Object>, Sort> sorts;
    private final Map<List<Object>, Priority> priorities = new HashMap<List<Object>, Priority>();
    private final Map<List<Object>, Production> productions;
    private final Map<List<Object>, UniqueProduction> uniqueProductions;
    private final Map<List<Object>, ProductionReference> productionReferences;
    private final Map<List<Object>, TermAttribute> termAttributes;
    private Layout layoutSymbol;
    private FileStartSymbol fileStartSymbol;
    private StartSymbol startSymbol;
    private EOFSymbol eofSymbol;

    public GrammarFactory() {
        this.sequenceSymbols = new HashMap<List<Object>, SequenceSymbol>();
        this.productions = new HashMap<List<Object>, Production>();
        this.uniqueProductions = new HashMap<List<Object>, UniqueProduction>();
        this.productionReferences = new HashMap<List<Object>, ProductionReference>();
        this.sorts = new HashMap<List<Object>, Sort>();
        this.termAttributes = new HashMap<List<Object>, TermAttribute>();
    }

    public AltSymbol createAltSymbol(Symbol s1, Symbol s2) {
        ArrayList<Symbol> altSymbolFields = new ArrayList<Symbol>();
        altSymbolFields.add(s1);
        altSymbolFields.add(s2);
        if (this.altSymbols.containsKey(altSymbolFields)) {
            return this.altSymbols.get(altSymbolFields);
        }
        AltSymbol altSymbol = new AltSymbol(s1, s2);
        this.altSymbols.put(altSymbolFields, altSymbol);
        return altSymbol;
    }

    public CharacterClassSymbol createCharClassSymbol(ICharacterClass cc) {
        if (this.characterClassSymbols.containsKey(cc)) {
            return this.characterClassSymbols.get(cc);
        }
        CharacterClassSymbol ccSymbol = new CharacterClassSymbol(cc);
        this.characterClassSymbols.put(cc, ccSymbol);
        return ccSymbol;
    }

    public ConstructorAttribute createConstructorAttribute(String cons) {
        if (this.constructorAttributes.containsKey(cons)) {
            return this.constructorAttributes.get(cons);
        }
        ConstructorAttribute ca = new ConstructorAttribute(cons);
        this.constructorAttributes.put(cons, ca);
        return ca;
    }

    public ContextFreeSymbol createContextFreeSymbol(Symbol symbol) {
        if (this.contextFreeSymbols.containsKey(symbol)) {
            return this.contextFreeSymbols.get(symbol);
        }
        ContextFreeSymbol cfs = new ContextFreeSymbol(symbol);
        this.contextFreeSymbols.put(symbol, cfs);
        return cfs;
    }

    public LexicalSymbol createLexicalSymbol(Symbol s) {
        if (this.lexicalSymbols.containsKey(s)) {
            return this.lexicalSymbols.get(s);
        }
        LexicalSymbol cfs = new LexicalSymbol(s);
        this.lexicalSymbols.put(s, cfs);
        return cfs;
    }

    public IterSymbol createIterSymbol(Symbol s) {
        if (this.iterSymbols.containsKey(s)) {
            return this.iterSymbols.get(s);
        }
        IterSymbol is = new IterSymbol(s);
        this.iterSymbols.put(s, is);
        return is;
    }

    public IterStarSymbol createIterStarSymbol(Symbol s) {
        if (this.iterStarSymbols.containsKey(s)) {
            return this.iterStarSymbols.get(s);
        }
        IterStarSymbol iss = new IterStarSymbol(s);
        this.iterStarSymbols.put(s, iss);
        return iss;
    }

    public IterSepSymbol createIterSepSymbol(Symbol symbol, Sort separator) {
        ArrayList<Symbol> iterSepFields = new ArrayList<Symbol>();
        iterSepFields.add(symbol);
        iterSepFields.add(separator);
        if (this.iterSepSymbols.containsKey(iterSepFields)) {
            return this.iterSepSymbols.get(iterSepFields);
        }
        IterSepSymbol iterSepSymbol = new IterSepSymbol(symbol, separator);
        this.iterSepSymbols.put(iterSepFields, iterSepSymbol);
        return iterSepSymbol;
    }

    public IterStarSepSymbol createIterStarSepSymbol(Symbol s, Sort sep) {
        ArrayList<Symbol> iterStarSepFields = new ArrayList<Symbol>();
        iterStarSepFields.add(s);
        iterStarSepFields.add(sep);
        if (this.iterStarSepSymbols.containsKey(iterStarSepFields)) {
            return this.iterStarSepSymbols.get(iterStarSepFields);
        }
        IterStarSepSymbol iterStarSepSymbol = new IterStarSepSymbol(s, sep);
        this.iterStarSepSymbols.put(iterStarSepFields, iterStarSepSymbol);
        return iterStarSepSymbol;
    }

    public OptionalSymbol createOptionalSymbol(Symbol s) {
        if (this.optionalSymbols.containsKey(s)) {
            return this.optionalSymbols.get(s);
        }
        OptionalSymbol os = new OptionalSymbol(s);
        this.optionalSymbols.put(s, os);
        return os;
    }

    public DeprecatedAttribute createDeprecatedAttribute(String message) {
        if (this.deprecatedAttributes.containsKey(message)) {
            return this.deprecatedAttributes.get(message);
        }
        DeprecatedAttribute da = new DeprecatedAttribute(message);
        this.deprecatedAttributes.put(message, da);
        return da;
    }

    public GeneralAttribute createGeneralAttribute(String name) {
        if (this.generalAttributes.containsKey(name)) {
            return this.generalAttributes.get(name);
        }
        GeneralAttribute ga = new GeneralAttribute(name);
        this.generalAttributes.put(name, ga);
        return ga;
    }

    public LayoutConstraintAttribute createLayoutConstraintAttribute(IStrategoTerm t) throws Exception {
        LayoutConstraintAttribute lca = new LayoutConstraintAttribute(t);
        return lca;
    }

    public Priority createPriority(Production higher, Production lower, boolean transitive) {
        ArrayList<Serializable> priorityFields = new ArrayList<Serializable>();
        priorityFields.add(higher);
        priorityFields.add(lower);
        priorityFields.add(Boolean.valueOf(transitive));
        if (this.priorities.containsKey(priorityFields)) {
            return this.priorities.get(priorityFields);
        }
        Priority p = new Priority(higher, lower, transitive);
        this.priorities.put(priorityFields, p);
        return p;
    }

    public Production createProduction(Symbol lhs, List<Symbol> rhs) {
        ArrayList<Symbol> productionFields = new ArrayList<Symbol>();
        productionFields.add(lhs);
        productionFields.addAll(rhs);
        if (this.productions.containsKey(productionFields)) {
            return this.productions.get(productionFields);
        }
        Production p = new Production(lhs, rhs);
        this.productions.put(productionFields, p);
        return p;
    }

    public Production createProduction(Symbol lhs, List<Symbol> rhs, int leftRecursivePos, int rightRecursivePos) {
        ArrayList<Symbol> productionFields = new ArrayList<Symbol>();
        productionFields.add(lhs);
        productionFields.addAll(rhs);
        if (this.productions.containsKey(productionFields)) {
            Production p = this.productions.get(productionFields);
            p.setLeftRecursivePosition(leftRecursivePos);
            p.setRightRecursivePosition(rightRecursivePos);
            return p;
        }
        Production p = new Production(lhs, rhs, leftRecursivePos, rightRecursivePos);
        this.productions.put(productionFields, p);
        return p;
    }

    public ProductionReference createProductionReference(Symbol s, ConstructorAttribute cons) {
        List<Object> productionReferenceFields = Arrays.asList(s, cons);
        if (this.productionReferences.containsKey(productionReferenceFields)) {
            return this.productionReferences.get(productionReferenceFields);
        }
        ProductionReference pr = new ProductionReference(s, cons);
        this.productionReferences.put(productionReferenceFields, pr);
        return pr;
    }

    public SequenceSymbol createSequenceSymbol(Symbol first, List<Symbol> tail) {
        ArrayList<Symbol> sequenceSymbolFields = new ArrayList<Symbol>(Arrays.asList(first));
        sequenceSymbolFields.addAll(tail);
        if (this.sequenceSymbols.containsKey(sequenceSymbolFields)) {
            return this.sequenceSymbols.get(sequenceSymbolFields);
        }
        SequenceSymbol ss = new SequenceSymbol(first, tail);
        this.sequenceSymbols.put(sequenceSymbolFields, ss);
        return ss;
    }

    public Sort createSort(String s) {
        ArrayList<String> sortFields = new ArrayList<String>(Arrays.asList(s, null));
        if (this.sorts.containsKey(sortFields)) {
            return this.sorts.get(sortFields);
        }
        Sort sort = new Sort(s);
        this.sorts.put(sortFields, sort);
        return sort;
    }

    public Symbol createSort(String s, LiteralType lit) {
        List<Object> sortFields = Arrays.asList(new Object[]{s, lit});
        if (this.sorts.containsKey(sortFields)) {
            return this.sorts.get(sortFields);
        }
        Sort sort = new Sort(s, lit);
        this.sorts.put(sortFields, sort);
        return sort;
    }

    public Layout createLayoutSymbol() {
        if (this.layoutSymbol == null) {
            this.layoutSymbol = new Layout();
        }
        return this.layoutSymbol;
    }

    public FileStartSymbol createFileStartSymbol() {
        if (this.fileStartSymbol == null) {
            this.fileStartSymbol = new FileStartSymbol();
        }
        return this.fileStartSymbol;
    }

    public Symbol createStartSymbol() {
        if (this.startSymbol == null) {
            this.startSymbol = new StartSymbol();
        }
        return this.startSymbol;
    }

    public Symbol createEOFSymbol() {
        if (this.eofSymbol == null) {
            this.eofSymbol = new EOFSymbol();
        }
        return this.eofSymbol;
    }

    public TermAttribute createTermAttribute(IStrategoTerm t, String s) {
        List<Object> termAttributeFields = Arrays.asList(t, s);
        if (this.termAttributes.containsKey(termAttributeFields)) {
            return this.termAttributes.get(termAttributeFields);
        }
        TermAttribute ta = new TermAttribute(t, s);
        this.termAttributes.put(termAttributeFields, ta);
        return ta;
    }

    public UniqueProduction createUniqueProduction(Symbol lhs, List<Symbol> rhs) {
        ArrayList<Symbol> uniqueProductionFields = new ArrayList<Symbol>();
        uniqueProductionFields.add(lhs);
        uniqueProductionFields.addAll(rhs);
        if (this.uniqueProductions.containsKey(uniqueProductionFields)) {
            return this.uniqueProductions.get(uniqueProductionFields);
        }
        UniqueProduction up = new UniqueProduction(lhs, rhs);
        this.uniqueProductions.put(uniqueProductionFields, up);
        return up;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GrammarFactory that = (GrammarFactory)o;
        return Objects.equals(this.altSymbols, that.altSymbols) && Objects.equals(this.characterClassSymbols, that.characterClassSymbols) && Objects.equals(this.constructorAttributes, that.constructorAttributes) && Objects.equals(this.contextFreeSymbols, that.contextFreeSymbols) && Objects.equals(this.lexicalSymbols, that.lexicalSymbols) && Objects.equals(this.optionalSymbols, that.optionalSymbols) && Objects.equals(this.deprecatedAttributes, that.deprecatedAttributes) && Objects.equals(this.generalAttributes, that.generalAttributes) && Objects.equals(this.iterSepSymbols, that.iterSepSymbols) && Objects.equals(this.iterStarSepSymbols, that.iterStarSepSymbols) && Objects.equals(this.iterStarSymbols, that.iterStarSymbols) && Objects.equals(this.iterSymbols, that.iterSymbols) && Objects.equals(this.sequenceSymbols, that.sequenceSymbols) && Objects.equals(this.sorts, that.sorts) && Objects.equals(this.priorities, that.priorities) && Objects.equals(this.productions, that.productions) && Objects.equals(this.uniqueProductions, that.uniqueProductions) && Objects.equals(this.productionReferences, that.productionReferences) && Objects.equals(this.termAttributes, that.termAttributes) && Objects.equals(this.layoutSymbol, that.layoutSymbol) && Objects.equals(this.fileStartSymbol, that.fileStartSymbol) && Objects.equals(this.startSymbol, that.startSymbol) && Objects.equals(this.eofSymbol, that.eofSymbol);
    }

    public int hashCode() {
        return Objects.hash(this.altSymbols, this.characterClassSymbols, this.constructorAttributes, this.contextFreeSymbols, this.lexicalSymbols, this.optionalSymbols, this.deprecatedAttributes, this.generalAttributes, this.iterSepSymbols, this.iterStarSepSymbols, this.iterStarSymbols, this.iterSymbols, this.sequenceSymbols, this.sorts, this.priorities, this.productions, this.uniqueProductions, this.productionReferences, this.termAttributes, this.layoutSymbol, this.fileStartSymbol, this.startSymbol, this.eofSymbol);
    }
}

