/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.core.testing;

import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.Stack;
import org.metaborg.core.testing.ITestReporterService;

public abstract class TestReporterServiceBase
implements ITestReporterService {
    private boolean started = false;
    private final Stack<String> testSuites = new Stack();
    @Nullable
    private String testCase = null;

    protected abstract void onSessionStarted();

    protected abstract void onSessionFinished();

    protected abstract void onTestSuiteStarted(String var1);

    protected abstract void onTestSuiteFinished(String var1);

    protected abstract void onTestStarted(String var1);

    protected abstract void onTestFailed(String var1, @Nullable String var2, @Nullable String var3);

    protected abstract void onTestPassed(String var1);

    protected abstract void onTestIgnored(String var1, @Nullable String var2);

    @Override
    public final void sessionStarted() {
        this.assertState(!this.started);
        this.onSessionStarted();
        this.started = true;
    }

    @Override
    public final void sessionFinished() {
        this.assertState(this.started);
        this.onSessionFinished();
        this.started = false;
    }

    @Override
    public final void testSuiteStarted(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument name may not be null.");
        }
        this.assertState(this.started);
        this.testSuites.push(name);
        this.onTestSuiteStarted(name);
    }

    @Override
    public final void testSuiteFinished(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument name may not be null.");
        }
        this.assertState(this.started);
        this.assertState(this.testSuites.peek().equals(name));
        this.onTestSuiteFinished(name);
        this.testSuites.pop();
    }

    @Override
    public final void testStarted(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument name may not be null.");
        }
        this.assertState(this.started);
        this.assertState(this.testCase == null);
        this.testCase = name;
        this.onTestStarted(name);
    }

    @Override
    public final void testFailed(String name, @Nullable String reason, @Nullable String details) {
        if (name == null) {
            throw new IllegalArgumentException("Argument name may not be null.");
        }
        this.assertState(this.started);
        this.assertState(Objects.equals(this.testCase, name));
        this.onTestFailed(name, reason, details);
        this.testCase = null;
    }

    @Override
    public final void testPassed(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument name may not be null.");
        }
        this.assertState(this.started);
        this.assertState(Objects.equals(this.testCase, name));
        this.onTestPassed(name);
        this.testCase = null;
    }

    @Override
    public final void testIgnored(String name, @Nullable String reason) {
        if (name == null) {
            throw new IllegalArgumentException("Argument name may not be null.");
        }
        this.assertState(this.started);
        this.assertState(Objects.equals(this.testCase, name));
        this.onTestIgnored(name, reason);
        this.testCase = null;
    }

    private void assertState(boolean condition) {
        if (!condition) {
            throw new IllegalStateException("Call not allowed in this state.");
        }
    }
}

