/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.core.testing;

import jakarta.annotation.Nullable;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

public class TeamCityWriter {
    private final PrintStream output;
    @Nullable
    private final String flowID;

    public TeamCityWriter() {
        this(System.out, null);
    }

    public TeamCityWriter(PrintStream output, @Nullable String flowID) {
        if (output == null) {
            throw new IllegalArgumentException("Argument output must not be null.");
        }
        this.output = output;
        this.flowID = flowID;
    }

    public void send(String name, Attribute ... attributes) {
        String timestamp = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").format(new Date());
        ArrayList<Attribute> expandedAttributes = new ArrayList<Attribute>(Arrays.asList(attributes));
        expandedAttributes.add(new Attribute("timestamp", timestamp));
        expandedAttributes.add(new Attribute("flowId", this.flowID));
        String message = this.buildMessage(name, expandedAttributes);
        this.output.println(message);
    }

    private String buildMessage(String name, List<Attribute> attributes) {
        String attributeString = attributes.stream().filter(attribute -> attribute.value != null).map(attribute -> String.valueOf(attribute.name) + "='" + this.escape(attribute.value) + "'").collect(Collectors.joining(" "));
        return "\n##teamcity[" + name + " " + attributeString + "]";
    }

    @Nullable
    private String escape(@Nullable Object value) {
        if (value == null) {
            return null;
        }
        return value.toString().replace("|", "||").replace("[", "|[").replace("]", "|]").replace("'", "|'").replace("\r", "|r").replace("\n", "|n");
    }

    public static final class Attribute {
        public final String name;
        @Nullable
        public final Object value;

        public Attribute(String name, Object value) {
            this.name = name;
            this.value = value;
        }
    }
}

