/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.core.processing;

import jakarta.inject.Inject;
import java.util.Set;
import org.metaborg.core.context.IContextProcessor;
import org.metaborg.core.editor.IEditor;
import org.metaborg.core.editor.IEditorRegistry;
import org.metaborg.core.language.ILanguageCache;
import org.metaborg.core.language.ILanguageComponent;
import org.metaborg.core.language.ILanguageImpl;
import org.metaborg.core.language.LanguageComponentChange;
import org.metaborg.core.language.LanguageImplChange;
import org.metaborg.core.language.dialect.IDialectProcessor;
import org.metaborg.core.processing.ILanguageChangeProcessor;
import org.metaborg.core.processing.analyze.IAnalysisResultProcessor;
import org.metaborg.core.processing.parse.IParseResultProcessor;

public class LanguageChangeProcessor
implements ILanguageChangeProcessor {
    private final IDialectProcessor dialectProcessor;
    private final IContextProcessor contextProcessor;
    private final IParseResultProcessor<?, ?> parseResultProcessor;
    private final IAnalysisResultProcessor<?, ?, ?> analysisResultProcessor;
    private final IEditorRegistry editorRegistry;
    private final Set<ILanguageCache> languageCaches;

    @Inject
    public LanguageChangeProcessor(IDialectProcessor dialectProcessor, IContextProcessor contextProcessor, IParseResultProcessor<?, ?> parseResultProcessor, IAnalysisResultProcessor<?, ?, ?> analysisResultProcessor, IEditorRegistry editorRegistry, Set<ILanguageCache> languageCaches) {
        this.dialectProcessor = dialectProcessor;
        this.contextProcessor = contextProcessor;
        this.parseResultProcessor = parseResultProcessor;
        this.analysisResultProcessor = analysisResultProcessor;
        this.editorRegistry = editorRegistry;
        this.languageCaches = languageCaches;
    }

    @Override
    public void processComponentChange(LanguageComponentChange change) {
        switch (change.kind) {
            case Add: {
                this.addedComponent(change.newComponent);
                break;
            }
            case Reload: {
                this.reloadedComponent(change.oldComponent, change.newComponent);
                break;
            }
            case Remove: {
                this.removedComponent(change.oldComponent);
            }
        }
    }

    protected void addedComponent(ILanguageComponent component) {
    }

    protected void reloadedComponent(ILanguageComponent oldComponent, ILanguageComponent newComponent) {
        for (ILanguageCache languageCache : this.languageCaches) {
            languageCache.invalidateCache(oldComponent);
        }
    }

    protected void removedComponent(ILanguageComponent component) {
        for (ILanguageCache languageCache : this.languageCaches) {
            languageCache.invalidateCache(component);
        }
    }

    @Override
    public void processImplChange(LanguageImplChange change) {
        switch (change.kind) {
            case Add: {
                this.addedImpl(change.impl);
                break;
            }
            case Reload: {
                this.reloadedImpl(change.impl);
                break;
            }
            case Remove: {
                this.removedImpl(change.impl);
            }
        }
        this.dialectProcessor.update(change);
        this.contextProcessor.update(change);
    }

    protected void addedImpl(ILanguageImpl impl) {
        Iterable<IEditor> editors = this.editorRegistry.openEditors();
        for (IEditor editor : editors) {
            if (editor.language() == null) {
                editor.reconfigure();
            }
            if (editor.enabled() || !impl.equals(editor.language())) continue;
            editor.enable();
        }
    }

    protected void reloadedImpl(ILanguageImpl impl) {
        for (ILanguageCache languageCache : this.languageCaches) {
            languageCache.invalidateCache(impl);
        }
        this.parseResultProcessor.invalidate(impl);
        this.analysisResultProcessor.invalidate(impl);
        Iterable<IEditor> editors = this.editorRegistry.openEditors();
        for (IEditor editor : editors) {
            ILanguageImpl editorLanguage = editor.language();
            if (editorLanguage != null && !impl.equals(editorLanguage)) continue;
            editor.reconfigure();
            editor.forceUpdate();
        }
    }

    protected void removedImpl(ILanguageImpl impl) {
        for (ILanguageCache languageCache : this.languageCaches) {
            languageCache.invalidateCache(impl);
        }
        this.parseResultProcessor.invalidate(impl);
        this.analysisResultProcessor.invalidate(impl);
        Iterable<IEditor> editors = this.editorRegistry.openEditors();
        for (IEditor editor : editors) {
            ILanguageImpl language = editor.language();
            if (language == null || !language.equals(impl)) continue;
            editor.reconfigure();
            editor.disable();
        }
    }
}

