/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.core.processing;

import jakarta.annotation.Nullable;
import jakarta.inject.Inject;
import org.apache.commons.vfs2.FileObject;
import org.metaborg.core.analysis.IAnalyzeUnit;
import org.metaborg.core.analysis.IAnalyzeUnitUpdate;
import org.metaborg.core.build.BuildInput;
import org.metaborg.core.build.CleanInput;
import org.metaborg.core.build.IBuildOutput;
import org.metaborg.core.build.IBuilder;
import org.metaborg.core.language.LanguageComponentChange;
import org.metaborg.core.language.LanguageImplChange;
import org.metaborg.core.language.dialect.IDialectProcessor;
import org.metaborg.core.processing.BlockingTask;
import org.metaborg.core.processing.ILanguageChangeProcessor;
import org.metaborg.core.processing.IProcessor;
import org.metaborg.core.processing.ITask;
import org.metaborg.core.resource.ResourceChange;
import org.metaborg.core.syntax.IParseUnit;
import org.metaborg.core.transform.ITransformUnit;
import org.metaborg.util.task.ICancel;
import org.metaborg.util.task.IProgress;
import org.metaborg.util.task.NullCancel;
import org.metaborg.util.task.NullProgress;

public class BlockingProcessor<P extends IParseUnit, A extends IAnalyzeUnit, AU extends IAnalyzeUnitUpdate, T extends ITransformUnit<?>>
implements IProcessor<P, A, AU, T> {
    private final IDialectProcessor dialectProcessor;
    private final IBuilder<P, A, AU, T> builder;
    private final ILanguageChangeProcessor languageChangeProcessor;

    @Inject
    public BlockingProcessor(IDialectProcessor dialectProcessor, IBuilder<P, A, AU, T> builder, ILanguageChangeProcessor languageChangeProcessor) {
        this.dialectProcessor = dialectProcessor;
        this.builder = builder;
        this.languageChangeProcessor = languageChangeProcessor;
    }

    @Override
    public ITask<? extends IBuildOutput<P, A, AU, T>> build(BuildInput input, @Nullable IProgress progressReporter, @Nullable ICancel cancellationToken) {
        return new BlockingTask<IBuildOutput>(() -> {
            IProgress pr = progressReporter != null ? progressReporter : new NullProgress();
            ICancel ct = cancellationToken != null ? cancellationToken : new NullCancel();
            try {
                return this.builder.build(input, pr, ct);
            }
            catch (InterruptedException interruptedException) {
                return null;
            }
        });
    }

    @Override
    public ITask<?> clean(CleanInput input, @Nullable IProgress progressReporter, @Nullable ICancel cancellationToken) {
        return new BlockingTask<Object>(() -> {
            IProgress pr = progressReporter != null ? progressReporter : new NullProgress();
            ICancel ct = cancellationToken != null ? cancellationToken : new NullCancel();
            try {
                this.builder.clean(input, pr, ct);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return null;
        });
    }

    @Override
    public ITask<?> updateDialects(FileObject location, Iterable<ResourceChange> changes) {
        return new BlockingTask<Object>(() -> {
            this.dialectProcessor.update(location, changes);
            return null;
        });
    }

    @Override
    public ITask<?> languageChange(LanguageComponentChange change) {
        return new BlockingTask<Object>(() -> {
            this.languageChangeProcessor.processComponentChange(change);
            return null;
        });
    }

    @Override
    public ITask<?> languageChange(LanguageImplChange change) {
        return new BlockingTask<Object>(() -> {
            this.languageChangeProcessor.processImplChange(change);
            return null;
        });
    }
}

