/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.core.plugin;

import com.google.inject.Module;
import java.util.LinkedList;
import java.util.ServiceLoader;
import org.metaborg.core.MetaborgException;
import org.metaborg.core.plugin.IModulePluginLoader;
import org.metaborg.core.plugin.IServiceModulePlugin;
import org.metaborg.util.iterators.Iterables2;

public class ServiceModulePluginLoader<T extends IServiceModulePlugin>
implements IModulePluginLoader {
    private final Class<T> serviceClass;

    public ServiceModulePluginLoader(Class<T> serviceClass) {
        this.serviceClass = serviceClass;
    }

    @Override
    public Iterable<Module> modules() throws MetaborgException {
        try {
            ServiceLoader<IServiceModulePlugin> modulePlugins = ServiceLoader.load(this.serviceClass);
            LinkedList<Module> modules = new LinkedList<Module>();
            for (IServiceModulePlugin plugin : modulePlugins) {
                Iterables2.addAll(modules, plugin.modules());
            }
            return modules;
        }
        catch (Exception e) {
            throw new MetaborgException("Unhandled exception while loading module plugins with Java's ServiceLoader", e);
        }
    }
}

