/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.core.language;

import java.util.LinkedList;
import org.apache.commons.vfs2.FileObject;
import org.metaborg.core.MetaborgRuntimeException;
import org.metaborg.core.config.ILanguageComponentConfig;
import org.metaborg.core.language.FacetContribution;
import org.metaborg.core.language.IFacet;
import org.metaborg.core.language.ILanguageComponentInternal;
import org.metaborg.core.language.ILanguageImpl;
import org.metaborg.core.language.ILanguageImplInternal;
import org.metaborg.core.language.LanguageIdentifier;
import org.metaborg.util.collection.ListMultimap;
import org.metaborg.util.iterators.Iterables2;

public class LanguageComponent
implements ILanguageComponentInternal {
    private final LanguageIdentifier id;
    private final FileObject location;
    private final int sequenceId;
    private Iterable<ILanguageImplInternal> contributesTo;
    private final ILanguageComponentConfig config;
    private final ListMultimap<Class<? extends IFacet>, IFacet> facets = new ListMultimap();

    public LanguageComponent(LanguageIdentifier identifier, FileObject location, int sequenceId, Iterable<ILanguageImplInternal> contributesTo, ILanguageComponentConfig config, Iterable<? extends IFacet> facets) {
        this.id = identifier;
        this.location = location;
        this.sequenceId = sequenceId;
        this.contributesTo = contributesTo;
        this.config = config;
        for (IFacet iFacet : facets) {
            this.facets.put(iFacet.getClass(), iFacet);
        }
    }

    @Override
    public LanguageIdentifier id() {
        return this.id;
    }

    @Override
    public FileObject location() {
        return this.location;
    }

    @Override
    public int sequenceId() {
        return this.sequenceId;
    }

    @Override
    public Iterable<? extends ILanguageImpl> contributesTo() {
        return this.contributesTo;
    }

    @Override
    public Iterable<? extends ILanguageImplInternal> contributesToInternal() {
        return this.contributesTo;
    }

    @Override
    public void clearContributions() {
        this.contributesTo = Iterables2.empty();
    }

    @Override
    public ILanguageComponentConfig config() {
        return this.config;
    }

    @Override
    public boolean hasFacet(Class<? extends IFacet> type) {
        return this.facets.containsKey(type);
    }

    @Override
    public <T extends IFacet> Iterable<T> facets(Class<T> type) {
        return this.facets.get(type);
    }

    @Override
    public <T extends IFacet> Iterable<FacetContribution<T>> facetContributions(Class<T> type) {
        LinkedList<FacetContribution<T>> contributions = new LinkedList<FacetContribution<T>>();
        for (IFacet facet : this.facets(type)) {
            contributions.add(new FacetContribution<IFacet>(facet, this));
        }
        return contributions;
    }

    @Override
    public <T extends IFacet> T facet(Class<T> type) {
        Iterable<T> facets = this.facets(type);
        int size = Iterables2.size(facets);
        if (size == 0) {
            return null;
        }
        if (size > 1) {
            throw new MetaborgRuntimeException("Multiple facets of " + type + " found, while only a single facet is supported");
        }
        return (T)((IFacet)facets.iterator().next());
    }

    @Override
    public <T extends IFacet> FacetContribution<T> facetContribution(Class<T> type) {
        Iterable<FacetContribution<T>> facetContributions = this.facetContributions(type);
        int size = Iterables2.size(facetContributions);
        if (size == 0) {
            return null;
        }
        if (size > 1) {
            throw new MetaborgRuntimeException("Multiple facets of " + type + " found, while only a single facet is supported");
        }
        return facetContributions.iterator().next();
    }

    @Override
    public Iterable<IFacet> facets() {
        return this.facets.values();
    }

    @Override
    public Iterable<FacetContribution<IFacet>> facetContributions() {
        LinkedList<FacetContribution<IFacet>> contributions = new LinkedList<FacetContribution<IFacet>>();
        for (IFacet facet : this.facets()) {
            contributions.add(new FacetContribution<IFacet>(facet, this));
        }
        return contributions;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id.hashCode();
        result = 31 * result + this.location.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LanguageComponent other = (LanguageComponent)obj;
        if (!this.id.equals(other.id)) {
            return false;
        }
        return this.location.equals(other.location);
    }

    public String toString() {
        return "language comp. " + this.id + "@" + this.location;
    }
}

