/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.core.build.dependency;

import org.metaborg.core.language.LanguageIdentifier;
import org.metaborg.util.iterators.Iterables2;

public class MissingDependencies {
    public final Iterable<LanguageIdentifier> compile;
    public final Iterable<LanguageIdentifier> runtime;

    public MissingDependencies(Iterable<LanguageIdentifier> compile, Iterable<LanguageIdentifier> runtime) {
        this.compile = compile;
        this.runtime = runtime;
    }

    public MissingDependencies() {
        this(Iterables2.empty(), Iterables2.empty());
    }

    public boolean empty() {
        return Iterables2.isEmpty(this.compile) && Iterables2.isEmpty(this.runtime);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("The following dependencies are missing: \n");
        sb.append("  Compile-time: \n");
        this.printIdentifiers(this.compile, sb);
        sb.append("  Runtime: \n");
        this.printIdentifiers(this.runtime, sb);
        return sb.toString();
    }

    private void printIdentifiers(Iterable<LanguageIdentifier> identifiers, StringBuilder sb) {
        for (LanguageIdentifier identifier : identifiers) {
            sb.append("    ");
            sb.append(identifier);
            sb.append('\n');
        }
    }
}

