/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.core;

import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.name.Names;
import com.google.inject.util.Types;
import jakarta.annotation.Nullable;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.vfs2.FileObject;
import org.metaborg.core.MetaborgException;
import org.metaborg.core.MetaborgModule;
import org.metaborg.core.build.dependency.IDependencyService;
import org.metaborg.core.build.paths.ILanguagePathService;
import org.metaborg.core.context.IContextService;
import org.metaborg.core.editor.IEditorRegistry;
import org.metaborg.core.language.ILanguageComponent;
import org.metaborg.core.language.ILanguageComponentFactory;
import org.metaborg.core.language.ILanguageDiscoveryService;
import org.metaborg.core.language.ILanguageIdentifierService;
import org.metaborg.core.language.ILanguageImpl;
import org.metaborg.core.language.ILanguageService;
import org.metaborg.core.language.dialect.IDialectProcessor;
import org.metaborg.core.plugin.IModulePluginLoader;
import org.metaborg.core.plugin.IServiceModulePlugin;
import org.metaborg.core.plugin.InjectorFactory;
import org.metaborg.core.plugin.ServiceModulePluginLoader;
import org.metaborg.core.project.IProjectService;
import org.metaborg.core.resource.IResourceService;
import org.metaborg.core.source.ISourceTextService;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;

public class MetaBorg
implements AutoCloseable {
    private static final ILogger logger = LoggerUtils.logger(MetaBorg.class);
    public final Injector injector;
    public final Set<AutoCloseable> autoCloseables;
    public final Set<AutoCloseable> lateAutoCloseables;
    public final IResourceService resourceService;
    public final ILanguageService languageService;
    public final ILanguageComponentFactory languageComponentFactory;
    public final ILanguageDiscoveryService languageDiscoveryService;
    public final ILanguageIdentifierService languageIdentifierService;
    public final ILanguagePathService languagePathService;
    public final IDialectProcessor dialectProcessor;
    public final IContextService contextService;
    public final IDependencyService dependencyService;
    public final IProjectService projectService;
    public final ISourceTextService sourceTextService;
    public final IEditorRegistry editorRegistry;

    public MetaBorg(IModulePluginLoader loader, MetaborgModule module, Module ... additionalModules) throws MetaborgException {
        ArrayList<Module> metaborgModules = new ArrayList<Module>(additionalModules.length + 1);
        Collections.addAll(metaborgModules, additionalModules);
        metaborgModules.add((Module)module);
        Iterable<Module> modules = InjectorFactory.modules(loader, metaborgModules);
        this.injector = InjectorFactory.create(modules);
        this.autoCloseables = (Set)this.injector.getInstance(Key.get((Type)Types.setOf(AutoCloseable.class)));
        this.lateAutoCloseables = (Set)this.injector.getInstance(Key.get((Type)Types.setOf(AutoCloseable.class), (Annotation)Names.named((String)"late")));
        this.resourceService = (IResourceService)this.injector.getInstance(IResourceService.class);
        this.languageService = (ILanguageService)this.injector.getInstance(ILanguageService.class);
        this.languageComponentFactory = (ILanguageComponentFactory)this.injector.getInstance(ILanguageComponentFactory.class);
        this.languageDiscoveryService = (ILanguageDiscoveryService)this.injector.getInstance(ILanguageDiscoveryService.class);
        this.languageIdentifierService = (ILanguageIdentifierService)this.injector.getInstance(ILanguageIdentifierService.class);
        this.languagePathService = (ILanguagePathService)this.injector.getInstance(ILanguagePathService.class);
        this.dialectProcessor = (IDialectProcessor)this.injector.getInstance(IDialectProcessor.class);
        this.contextService = (IContextService)this.injector.getInstance(IContextService.class);
        this.dependencyService = (IDependencyService)this.injector.getInstance(IDependencyService.class);
        this.projectService = (IProjectService)this.injector.getInstance(IProjectService.class);
        this.sourceTextService = (ISourceTextService)this.injector.getInstance(ISourceTextService.class);
        this.editorRegistry = (IEditorRegistry)this.injector.getInstance(IEditorRegistry.class);
    }

    public MetaBorg(MetaborgModule module, Module ... additionalModules) throws MetaborgException {
        this(MetaBorg.defaultPluginLoader(), module, additionalModules);
    }

    public MetaBorg(IModulePluginLoader loader, Module ... additionalModules) throws MetaborgException {
        this(loader, MetaBorg.defaultModule(), additionalModules);
    }

    public MetaBorg(Module ... additionalModules) throws MetaborgException {
        this(MetaBorg.defaultPluginLoader(), MetaBorg.defaultModule(), additionalModules);
    }

    @Override
    public void close() {
        logger.debug("Closing the MetaBorg API");
        for (AutoCloseable autoCloseable : this.autoCloseables) {
            try {
                autoCloseable.close();
            }
            catch (Exception e) {
                logger.error("Error while closing {}", e, autoCloseable);
            }
        }
        for (AutoCloseable autoCloseable : this.lateAutoCloseables) {
            try {
                autoCloseable.close();
            }
            catch (Exception e) {
                logger.error("Error while closing (late) {}", e, autoCloseable);
            }
        }
    }

    public FileObject resolve(String uri) {
        return this.resourceService.resolve(uri);
    }

    public FileObject resolve(File file) {
        return this.resourceService.resolve(file);
    }

    public FileObject resolve(URI uri) {
        return this.resourceService.resolve(uri);
    }

    public Set<ILanguageImpl> scanLanguagesInDirectory(FileObject directory) throws MetaborgException {
        return this.languageDiscoveryService.scanLanguagesInDirectory(directory);
    }

    @Deprecated
    public Iterable<ILanguageComponent> discoverLanguages(FileObject location) throws MetaborgException {
        return this.languageDiscoveryService.discover(this.languageDiscoveryService.request(location));
    }

    public boolean identifyResource(FileObject resource, ILanguageImpl language) {
        return this.languageIdentifierService.identify(resource, language);
    }

    @Nullable
    public ILanguageImpl identifyResource(FileObject resource) {
        return this.languageIdentifierService.identify(resource);
    }

    public void configureAsHeadlessApplication() {
        System.setProperty("java.awt.headless", "true");
        System.setProperty("apple.awt.UIElement", "true");
    }

    protected static MetaborgModule defaultModule() {
        return new MetaborgModule();
    }

    protected static IModulePluginLoader defaultPluginLoader() {
        return new ServiceModulePluginLoader<IServiceModulePlugin>(IServiceModulePlugin.class);
    }
}

