/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.spec;

import io.usethesource.capsule.Map;
import io.usethesource.capsule.Set;
import io.usethesource.capsule.SetMultimap;
import java.io.Serializable;
import mb.statix.constraints.Constraints;
import mb.statix.solver.IConstraint;
import mb.statix.spec.Rule;
import mb.statix.spec.RuleName;
import org.metaborg.util.collection.ImList;
import org.metaborg.util.unit.Unit;

class SubConstraintGraph
implements Serializable {
    private static final long serialVersionUID = 42L;
    private final SetMultimap.Immutable<RuleName, String> subConstraints;
    private final SetMultimap.Immutable<String, RuleName> invokingRules;

    public SubConstraintGraph(SetMultimap.Immutable<RuleName, String> subConstraints, SetMultimap.Immutable<String, RuleName> invokingRules) {
        this.subConstraints = subConstraints;
        this.invokingRules = invokingRules;
    }

    public Set.Immutable<String> subConstraints(RuleName rule) {
        return this.subConstraints.get((Object)rule);
    }

    public Set.Immutable<RuleName> invokingRules(String rule) {
        return this.invokingRules.get((Object)rule);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static SubConstraintGraph of(Map.Immutable<String, ImList.Immutable<Rule>> rules) {
        Builder builder = SubConstraintGraph.newBuilder();
        for (ImList.Immutable ruleList : rules.values()) {
            ruleList.forEach(builder::addRule);
        }
        return builder.build();
    }

    public static class Builder {
        private final SetMultimap.Transient<RuleName, String> subConstraints = SetMultimap.Transient.of();
        private final SetMultimap.Transient<String, RuleName> invokingRules = SetMultimap.Transient.of();

        public Builder addRule(Rule rule) {
            if (!rule.label().isEmpty()) {
                this.addCalls(rule.label(), rule.body());
            }
            return this;
        }

        private void addCalls(RuleName label, IConstraint constraint) {
            constraint.match(Constraints.cases().conj(cc -> {
                Constraints.disjoin(cc, c -> this.addCalls(label, (IConstraint)c));
                return Unit.unit;
            }).exists(exists -> {
                this.addCalls(label, exists.constraint());
                return Unit.unit;
            }).user(user -> {
                this.subConstraints.__insert((Object)label, (Object)user.name());
                this.invokingRules.__insert((Object)user.name(), (Object)label);
                return Unit.unit;
            }).otherwise(c -> Unit.unit));
        }

        public SubConstraintGraph build() {
            return new SubConstraintGraph((SetMultimap.Immutable<RuleName, String>)this.subConstraints.freeze(), (SetMultimap.Immutable<String, RuleName>)this.invokingRules.freeze());
        }
    }
}

