/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.spec;

import io.usethesource.capsule.Map;
import io.usethesource.capsule.Set;
import io.usethesource.capsule.SetMultimap;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mb.nabl2.terms.ITerm;
import mb.statix.solver.completeness.CompletenessUtil;
import mb.statix.spec.ARule;
import mb.statix.spec.Rule;
import mb.statix.spec.RuleName;
import mb.statix.spec.RuleSet;
import mb.statix.spec.RuleUtil;
import mb.statix.spec.SubConstraintGraph;
import org.metaborg.util.collection.CapsuleUtil;
import org.metaborg.util.collection.ImList;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;
import org.metaborg.util.tuple.Tuple2;

public final class BaseRuleSet
implements Serializable,
RuleSet {
    private static final ILogger logger = LoggerUtils.logger(RuleSet.class);
    private static final long serialVersionUID = 1L;
    private final Map.Immutable<String, ImList.Immutable<Rule>> rules;
    private final Map.Immutable<RuleName, Rule> rulesByLabel;
    private final SubConstraintGraph subConstraintGraph;
    private final HashMap<String, Set.Immutable<Rule>> independentRules = new HashMap();
    private final HashMap<RuleName, Rule> independentRulesByName = new HashMap();
    private final HashMap<RuleName, Map.Immutable<String, ImList.Immutable<Rule>>> subConstraints = new HashMap();
    private final HashMap<String, Collection<Rule>> invokingRules = new HashMap();

    public static RuleSet of(Collection<Rule> rules) {
        return new BaseRuleSet(BaseRuleSet.buildRuleSet(rules.stream()));
    }

    public BaseRuleSet(Map.Immutable<String, ImList.Immutable<Rule>> rules) {
        this(rules, BaseRuleSet.buildLabelMap(rules));
    }

    private BaseRuleSet(Map.Immutable<String, ImList.Immutable<Rule>> rules, Map.Immutable<RuleName, Rule> rulesByLabel) {
        this(rules, rulesByLabel, SubConstraintGraph.of(rules));
    }

    private BaseRuleSet(Map.Immutable<String, ImList.Immutable<Rule>> rules, SubConstraintGraph subConstraintGraph) {
        this(rules, BaseRuleSet.buildLabelMap(rules), subConstraintGraph);
    }

    private BaseRuleSet(Map.Immutable<String, ImList.Immutable<Rule>> rules, Map.Immutable<RuleName, Rule> rulesByLabel, SubConstraintGraph subConstraintGraph) {
        this.rules = rules;
        this.rulesByLabel = rulesByLabel;
        this.subConstraintGraph = subConstraintGraph;
    }

    @Override
    public Map.Immutable<String, ImList.Immutable<Rule>> getRuleMap() {
        return this.rules;
    }

    @Override
    public Set<String> getRuleNames() {
        return this.rules.keySet();
    }

    @Override
    public List<Rule> getAllRules() {
        return this.rules.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Override
    public List<Rule> getAllOrderIndependentRulesList() {
        ArrayList<Rule> independentRules = new ArrayList<Rule>();
        this.rules.keySet().forEach(name -> {
            Set.Immutable<Rule> orderIndependentRules = this.getOrderIndependentRules((String)name);
            independentRules.addAll((Collection<Rule>)orderIndependentRules);
        });
        return independentRules;
    }

    @Override
    public ImList.Immutable<Rule> getRules(String name) {
        ImList.Immutable rules = (ImList.Immutable)this.rules.get((Object)name);
        if (rules == null) {
            String qualified = this.getRuleNames().stream().filter(n -> n.endsWith(name)).findAny().orElse(null);
            if (qualified != null) {
                throw new NullPointerException("No rule with name " + name + ". Did you mean " + qualified + "?");
            }
            throw new NullPointerException("No rule with name " + name);
        }
        return rules;
    }

    @Override
    @Nullable
    public Rule getRule(RuleName name) {
        return (Rule)this.rulesByLabel.get((Object)name);
    }

    @Override
    public Map.Immutable<String, ImList.Immutable<Rule>> subConstraints(RuleName rule) {
        return this.subConstraints.computeIfAbsent(rule, _rule -> {
            Set.Immutable<String> subConstraintNames = this.subConstraintGraph.subConstraints((RuleName)_rule);
            Map.Transient _rules = this.rules.asTransient();
            CapsuleUtil.filter(_rules, arg_0 -> subConstraintNames.contains(arg_0));
            return _rules.freeze();
        });
    }

    @Override
    public Collection<Rule> invokingRules(String constraint) {
        return this.invokingRules.computeIfAbsent(constraint, _constraint -> {
            Set.Immutable<RuleName> superRuleNames = this.subConstraintGraph.invokingRules((String)_constraint);
            Map.Transient _rules = this.rulesByLabel.asTransient();
            CapsuleUtil.filter(_rules, arg_0 -> superRuleNames.contains(arg_0));
            return _rules.freeze().values();
        });
    }

    @Override
    public Map<String, Set<Rule>> getAllOrderIndependentRules() {
        HashMap<String, Set<Rule>> independentRules = new HashMap<String, Set<Rule>>();
        this.rules.keySet().forEach(name -> {
            Set.Immutable<Rule> orderIndependentRules = this.getOrderIndependentRules((String)name);
            if (!orderIndependentRules.isEmpty()) {
                independentRules.put((String)name, (Set<Rule>)orderIndependentRules);
            }
        });
        return independentRules;
    }

    @Override
    public Set.Immutable<Rule> getOrderIndependentRules(String name) {
        return this.independentRules.computeIfAbsent(name, n -> RuleUtil.computeOrderIndependentRules(this.getRules(name)));
    }

    @Override
    public Rule getOrderIndependentRule(RuleName label) {
        Rule rule = this.independentRulesByName.get(label);
        if (rule != null) {
            return rule;
        }
        String ruleName = this.getRule(label).name();
        Set.Immutable<Rule> orderIndependentRules = this.getOrderIndependentRules(ruleName);
        Rule target = null;
        for (Rule r : orderIndependentRules) {
            this.independentRulesByName.put(r.label(), r);
            if (!r.label().equals(label)) continue;
            target = r;
        }
        return target;
    }

    @Override
    public Map<String, Set<Rule>> getAllEquivalentRules() {
        HashMap<String, Set<Rule>> overlappingRules = new HashMap<String, Set<Rule>>();
        this.rules.keySet().forEach(name -> {
            Set<Rule> equivalentRules = this.getEquivalentRules((String)name);
            if (!equivalentRules.isEmpty()) {
                overlappingRules.computeIfAbsent((String)name, k -> new HashSet()).addAll(equivalentRules);
            }
        });
        return overlappingRules;
    }

    @Override
    public Set<Rule> getEquivalentRules(String name) {
        ImList.Immutable<Rule> rules = this.getRules(name);
        return rules.stream().filter(a -> rules.stream().anyMatch(b -> !a.equals(b) && ARule.LeftRightOrder.compare(a, b).map(c -> c == 0).orElse(false) != false)).collect(Collectors.toSet());
    }

    @Override
    public BaseRuleSet precomputeCriticalEdges(SetMultimap.Immutable<String, Tuple2<Integer, ITerm>> scopeExtensions) {
        return new BaseRuleSet(BaseRuleSet.buildRuleSet(this.rules.keySet().stream().flatMap(name -> ((ImList.Immutable)this.rules.get(name)).stream()).map(rule -> CompletenessUtil.precomputeCriticalEdges(rule, (SetMultimap<String, Tuple2<Integer, ITerm>>)scopeExtensions))), this.subConstraintGraph);
    }

    private static Map.Immutable<String, ImList.Immutable<Rule>> buildRuleSet(Stream<Rule> rules) {
        HashMap builder = new HashMap();
        rules.forEach(rule -> {
            List value = builder.computeIfAbsent(rule.name(), k -> new ArrayList());
            value.add(rule);
        });
        return CapsuleUtil.toMap(builder, value -> ImList.Immutable.sortedCopyOf(value, ARule.LeftRightOrder.asComparator()));
    }

    private static Map.Immutable<RuleName, Rule> buildLabelMap(Map.Immutable<String, ImList.Immutable<Rule>> rules) {
        Map.Transient rulesByLabel = CapsuleUtil.transientMap();
        for (ImList.Immutable ruleList : rules.values()) {
            for (Rule rule : ruleList) {
                if (!rule.label().isEmpty()) {
                    Rule old = (Rule)rulesByLabel.__put((Object)rule.label(), (Object)rule);
                    if (old == null) continue;
                    logger.warn("Duplicate rule name {}. ", rule.label());
                    logger.debug("* rule 1: {}", old);
                    logger.debug("* rule 2: {}", rule);
                    continue;
                }
                logger.warn("Rule without name for constraint {}/{}: {}.", rule.name(), rule.params().size(), rule);
            }
        }
        return rulesByLabel.freeze();
    }
}

