/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.spec;

import io.usethesource.capsule.Set;
import io.usethesource.capsule.util.stream.CapsuleCollectors;
import jakarta.annotation.Nullable;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.build.TermBuild;
import mb.nabl2.terms.matching.Pattern;
import mb.nabl2.terms.matching.TermPattern;
import mb.nabl2.terms.substitution.FreshVars;
import mb.nabl2.terms.substitution.IRenaming;
import mb.nabl2.terms.substitution.ISubstitution;
import mb.nabl2.terms.unification.ud.PersistentUniDisunifier;
import mb.nabl2.util.TermFormatter;
import mb.statix.constraints.Constraints;
import mb.statix.solver.Delay;
import mb.statix.solver.IConstraint;
import mb.statix.solver.completeness.ICompleteness;
import mb.statix.spec.ApplyMode;
import mb.statix.spec.ApplyResult;
import mb.statix.spec.Rule;
import mb.statix.spec.RuleName;
import mb.statix.spec.RuleUtil;
import org.immutables.serial.Serial;
import org.immutables.value.Value;
import org.metaborg.util.collection.CapsuleUtil;
import org.metaborg.util.collection.ImList;
import org.metaborg.util.functions.Action1;

@Value.Immutable
@Serial.Version(value=42L)
public abstract class ARule {
    private volatile Set.Immutable<ITermVar> freeVars;
    public static final LeftRightOrder leftRightPatternOrdering = new LeftRightOrder();

    @Value.Parameter
    public abstract String name();

    @Value.Parameter
    public abstract RuleName label();

    @Value.Parameter
    public abstract ImList.Immutable<Pattern> params();

    @Value.Lazy
    public Set.Immutable<ITermVar> paramVars() {
        return (Set.Immutable)this.params().stream().flatMap(t -> t.getVars().stream()).collect(CapsuleCollectors.toSet());
    }

    @Value.Parameter
    public abstract IConstraint body();

    @Nullable
    @Value.Default
    public ICompleteness.Immutable bodyCriticalEdges() {
        return null;
    }

    @Value.Lazy
    public Optional<Boolean> isAlways() throws InterruptedException {
        ApplyResult applyResult;
        List args = IntStream.range(0, this.params().size()).mapToObj(idx -> TermBuild.B.newVar("", "arg" + idx)).collect(Collectors.toList());
        try {
            applyResult = RuleUtil.apply(PersistentUniDisunifier.Immutable.of(), (Rule)this, args, null, ApplyMode.STRICT, ApplyMode.Safety.SAFE, false).orElse(null);
            if (applyResult == null) {
                return Optional.empty();
            }
        }
        catch (Delay d) {
            return Optional.empty();
        }
        if (applyResult.guard().isPresent()) {
            return Optional.empty();
        }
        return Constraints.trivial(this.body());
    }

    public Set.Immutable<ITermVar> freeVars() {
        Set.Immutable result = this.freeVars;
        if (result == null) {
            Set.Transient _freeVars = CapsuleUtil.transientSet();
            this.doVisitFreeVars(arg_0 -> _freeVars.__insert(arg_0));
            this.freeVars = result = _freeVars.freeze();
        }
        return result;
    }

    public void visitFreeVars(Action1<ITermVar> onFreeVar) {
        this.freeVars().forEach(onFreeVar::apply);
    }

    private void doVisitFreeVars(Action1<ITermVar> onFreeVar) {
        Set.Immutable<ITermVar> paramVars = this.paramVars();
        this.body().visitFreeVars(v -> {
            if (!paramVars.contains(v)) {
                onFreeVar.apply((ITermVar)v);
            }
        });
    }

    protected Rule setFreeVars(Set.Immutable<ITermVar> freeVars) {
        this.freeVars = freeVars;
        return (Rule)this;
    }

    public Rule apply(ISubstitution.Immutable subst) {
        return this.apply(subst, false);
    }

    public Rule unsafeApply(ISubstitution.Immutable subst) {
        return this.unsafeApply(subst, false);
    }

    public Rule apply(IRenaming subst) {
        return this.apply(subst, false);
    }

    public Rule apply(ISubstitution.Immutable subst, boolean trackOrigins) {
        ISubstitution.Immutable localSubst = subst.removeAll((Iterable<ITermVar>)this.paramVars()).retainAll((Iterable<ITermVar>)this.freeVars());
        if (localSubst.isEmpty()) {
            return (Rule)this;
        }
        ImList.Immutable<Pattern> params = this.params();
        IConstraint body = this.body();
        ICompleteness.Immutable bodyCriticalEdges = this.bodyCriticalEdges();
        Set.Immutable freeVars = this.freeVars;
        if (freeVars != null) {
            freeVars = freeVars.__removeAll(localSubst.domainSet()).__insertAll(localSubst.rangeSet());
        }
        FreshVars fresh = new FreshVars(new Set[]{localSubst.domainSet(), localSubst.rangeSet(), this.freeVars()});
        IRenaming ren = fresh.fresh((Set<ITermVar>)this.paramVars());
        fresh.fix();
        if (!ren.isEmpty()) {
            params = this.params().stream().map(p -> p.apply(ren)).collect(ImList.Immutable.toImmutableList());
            localSubst = ren.asSubstitution().compose(localSubst);
        }
        body = body.apply(localSubst, trackOrigins);
        if (bodyCriticalEdges != null) {
            bodyCriticalEdges = bodyCriticalEdges.apply(localSubst);
        }
        return Rule.of(this.name(), this.label(), params, body).withBodyCriticalEdges(bodyCriticalEdges).setFreeVars((Set.Immutable<ITermVar>)freeVars);
    }

    public Rule unsafeApply(ISubstitution.Immutable subst, boolean trackOrigins) {
        ISubstitution.Immutable localSubst = subst.removeAll((Iterable<ITermVar>)this.paramVars());
        if (localSubst.isEmpty()) {
            return (Rule)this;
        }
        ImList.Immutable<Pattern> params = this.params();
        IConstraint body = this.body();
        ICompleteness.Immutable bodyCriticalEdges = this.bodyCriticalEdges();
        body = body.unsafeApply(localSubst, trackOrigins);
        if (bodyCriticalEdges != null) {
            bodyCriticalEdges = bodyCriticalEdges.apply(localSubst);
        }
        return Rule.of(this.name(), this.label(), params, body).withBodyCriticalEdges(bodyCriticalEdges);
    }

    public Rule apply(IRenaming subst, boolean trackOrigins) {
        ImList.Immutable<Pattern> params = this.params();
        IConstraint body = this.body();
        ICompleteness.Immutable bodyCriticalEdges = this.bodyCriticalEdges();
        params = this.params().stream().map(p -> p.apply(subst)).collect(ImList.Immutable.toImmutableList());
        body = body.apply(subst, trackOrigins);
        if (bodyCriticalEdges != null) {
            bodyCriticalEdges = bodyCriticalEdges.apply(subst);
        }
        return Rule.of(this.name(), this.label(), params, body).withBodyCriticalEdges(bodyCriticalEdges);
    }

    public String toString(TermFormatter termToString) {
        StringBuilder sb = new StringBuilder();
        if (!this.label().isEmpty()) {
            sb.append("[").append(this.label()).append("] ");
        }
        if (this.name().isEmpty()) {
            sb.append("{ ");
        } else {
            sb.append(this.name()).append("(");
        }
        sb.append(this.params().stream().map(Object::toString).collect(Collectors.joining(", ")));
        if (!this.name().isEmpty()) {
            sb.append(")");
        }
        sb.append(" :- ");
        sb.append(this.body().toString(termToString));
        if (this.name().isEmpty()) {
            sb.append(" }");
        } else {
            sb.append(".");
        }
        return sb.toString();
    }

    public String toString() {
        return this.toString(Object::toString);
    }

    public static class LeftRightOrder {
        public static Optional<Integer> compare(Rule r1, Rule r2) {
            Pattern p1 = TermPattern.P.newTuple(r1.params());
            Pattern p2 = TermPattern.P.newTuple(r2.params());
            return Pattern.leftRightOrdering.compare(p1, p2);
        }

        public static Comparator<Rule> asComparator() {
            return (r1, r2) -> LeftRightOrder.compare(r1, r2).orElse(0);
        }
    }
}

