/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.solver.persistent.step;

import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Objects;
import mb.statix.constraints.CUser;
import mb.statix.solver.persistent.step.ACUserStep;
import mb.statix.solver.persistent.step.IStep;
import mb.statix.solver.persistent.step.StepResult;
import mb.statix.spec.ApplyResult;
import mb.statix.spec.Rule;

public final class CUserStep
extends ACUserStep {
    private final CUser constraint;
    private final StepResult result;
    @Nullable
    private final ApplyResult applyResult;
    @Nullable
    private final Rule rule;
    private final boolean onlyMatch;
    private transient int hashCode;

    private CUserStep(CUser constraint, StepResult result, @Nullable ApplyResult applyResult, @Nullable Rule rule, boolean onlyMatch) {
        this.constraint = Objects.requireNonNull(constraint, "constraint");
        this.result = Objects.requireNonNull(result, "result");
        this.applyResult = applyResult;
        this.rule = rule;
        this.onlyMatch = onlyMatch;
    }

    private CUserStep(CUserStep original, CUser constraint, StepResult result, @Nullable ApplyResult applyResult, @Nullable Rule rule, boolean onlyMatch) {
        this.constraint = constraint;
        this.result = result;
        this.applyResult = applyResult;
        this.rule = rule;
        this.onlyMatch = onlyMatch;
    }

    @Override
    public CUser constraint() {
        return this.constraint;
    }

    @Override
    public StepResult result() {
        return this.result;
    }

    @Override
    @Nullable
    public ApplyResult applyResult() {
        return this.applyResult;
    }

    @Override
    @Nullable
    public Rule rule() {
        return this.rule;
    }

    @Override
    public boolean isOnlyMatch() {
        return this.onlyMatch;
    }

    public final CUserStep withConstraint(CUser value) {
        if (this.constraint == value) {
            return this;
        }
        CUser newValue = Objects.requireNonNull(value, "constraint");
        return new CUserStep(this, newValue, this.result, this.applyResult, this.rule, this.onlyMatch);
    }

    public final CUserStep withResult(StepResult value) {
        if (this.result == value) {
            return this;
        }
        StepResult newValue = Objects.requireNonNull(value, "result");
        return new CUserStep(this, this.constraint, newValue, this.applyResult, this.rule, this.onlyMatch);
    }

    public final CUserStep withApplyResult(@Nullable ApplyResult value) {
        if (this.applyResult == value) {
            return this;
        }
        return new CUserStep(this, this.constraint, this.result, value, this.rule, this.onlyMatch);
    }

    public final CUserStep withRule(@Nullable Rule value) {
        if (this.rule == value) {
            return this;
        }
        return new CUserStep(this, this.constraint, this.result, this.applyResult, value, this.onlyMatch);
    }

    public final CUserStep withOnlyMatch(boolean value) {
        if (this.onlyMatch == value) {
            return this;
        }
        return new CUserStep(this, this.constraint, this.result, this.applyResult, this.rule, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CUserStep && this.equalTo(0, (CUserStep)another);
    }

    private boolean equalTo(int synthetic, CUserStep another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.constraint.equals(another.constraint) && this.result.equals(another.result) && Objects.equals(this.applyResult, another.applyResult) && Objects.equals(this.rule, another.rule) && this.onlyMatch == another.onlyMatch;
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.constraint.hashCode();
        h += (h << 5) + this.result.hashCode();
        h += (h << 5) + Objects.hashCode(this.applyResult);
        h += (h << 5) + Objects.hashCode(this.rule);
        h += (h << 5) + Boolean.hashCode(this.onlyMatch);
        return h;
    }

    public String toString() {
        return "CUserStep{constraint=" + this.constraint + ", result=" + this.result + ", applyResult=" + this.applyResult + ", rule=" + this.rule + ", onlyMatch=" + this.onlyMatch + "}";
    }

    public static CUserStep of(CUser constraint, StepResult result, @Nullable ApplyResult applyResult, @Nullable Rule rule, boolean onlyMatch) {
        return new CUserStep(constraint, result, applyResult, rule, onlyMatch);
    }

    public static CUserStep copyOf(ACUserStep instance) {
        if (instance instanceof CUserStep) {
            return (CUserStep)instance;
        }
        return CUserStep.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    /* synthetic */ CUserStep(CUserStep cUserStep, CUser cUser, StepResult stepResult, ApplyResult applyResult, Rule rule, boolean bl, CUserStep cUserStep2) {
        this(cUserStep, cUser, stepResult, applyResult, rule, bl);
    }

    public static final class Builder {
        private static final long INIT_BIT_CONSTRAINT = 1L;
        private static final long INIT_BIT_RESULT = 2L;
        private static final long INIT_BIT_ONLY_MATCH = 4L;
        private long initBits = 7L;
        private CUser constraint;
        private StepResult result;
        private ApplyResult applyResult;
        private Rule rule;
        private boolean onlyMatch;

        private Builder() {
        }

        public final Builder from(IStep instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(ACUserStep instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            IStep instance;
            if (object instanceof IStep) {
                instance = (IStep)object;
                this.result(instance.result());
            }
            if (object instanceof ACUserStep) {
                instance = (ACUserStep)object;
                Rule ruleValue = ((ACUserStep)instance).rule();
                if (ruleValue != null) {
                    this.rule(ruleValue);
                }
                this.onlyMatch(((ACUserStep)instance).isOnlyMatch());
                this.constraint(((ACUserStep)instance).constraint());
                ApplyResult applyResultValue = ((ACUserStep)instance).applyResult();
                if (applyResultValue != null) {
                    this.applyResult(applyResultValue);
                }
            }
        }

        public final Builder constraint(CUser constraint) {
            this.constraint = Objects.requireNonNull(constraint, "constraint");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder result(StepResult result) {
            this.result = Objects.requireNonNull(result, "result");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder applyResult(@Nullable ApplyResult applyResult) {
            this.applyResult = applyResult;
            return this;
        }

        public final Builder rule(@Nullable Rule rule) {
            this.rule = rule;
            return this;
        }

        public final Builder onlyMatch(boolean onlyMatch) {
            this.onlyMatch = onlyMatch;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public CUserStep build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new CUserStep(null, this.constraint, this.result, this.applyResult, this.rule, this.onlyMatch, null);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("constraint");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("result");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("onlyMatch");
            }
            return "Cannot build CUserStep, some of required attributes are not set " + attributes;
        }
    }
}

