/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.solver.persistent.step;

import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Objects;
import mb.nabl2.terms.unification.u.IUnifier;
import mb.statix.constraints.CEqual;
import mb.statix.solver.persistent.step.ACEqualStep;
import mb.statix.solver.persistent.step.IStep;
import mb.statix.solver.persistent.step.StepResult;

public final class CEqualStep
extends ACEqualStep {
    private final CEqual constraint;
    private final StepResult result;
    @Nullable
    private final IUnifier.Result<IUnifier.Immutable> unifierResult;
    private transient int hashCode;

    private CEqualStep(CEqual constraint, StepResult result, @Nullable IUnifier.Result<IUnifier.Immutable> unifierResult) {
        this.constraint = Objects.requireNonNull(constraint, "constraint");
        this.result = Objects.requireNonNull(result, "result");
        this.unifierResult = unifierResult;
    }

    private CEqualStep(CEqualStep original, CEqual constraint, StepResult result, @Nullable IUnifier.Result<IUnifier.Immutable> unifierResult) {
        this.constraint = constraint;
        this.result = result;
        this.unifierResult = unifierResult;
    }

    @Override
    public CEqual constraint() {
        return this.constraint;
    }

    @Override
    public StepResult result() {
        return this.result;
    }

    @Override
    @Nullable
    public IUnifier.Result<IUnifier.Immutable> unifierResult() {
        return this.unifierResult;
    }

    public final CEqualStep withConstraint(CEqual value) {
        if (this.constraint == value) {
            return this;
        }
        CEqual newValue = Objects.requireNonNull(value, "constraint");
        return new CEqualStep(this, newValue, this.result, this.unifierResult);
    }

    public final CEqualStep withResult(StepResult value) {
        if (this.result == value) {
            return this;
        }
        StepResult newValue = Objects.requireNonNull(value, "result");
        return new CEqualStep(this, this.constraint, newValue, this.unifierResult);
    }

    public final CEqualStep withUnifierResult(@Nullable IUnifier.Result<IUnifier.Immutable> value) {
        if (this.unifierResult == value) {
            return this;
        }
        return new CEqualStep(this, this.constraint, this.result, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CEqualStep && this.equalTo(0, (CEqualStep)another);
    }

    private boolean equalTo(int synthetic, CEqualStep another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.constraint.equals(another.constraint) && this.result.equals(another.result) && Objects.equals(this.unifierResult, another.unifierResult);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.constraint.hashCode();
        h += (h << 5) + this.result.hashCode();
        h += (h << 5) + Objects.hashCode(this.unifierResult);
        return h;
    }

    public String toString() {
        return "CEqualStep{constraint=" + this.constraint + ", result=" + this.result + ", unifierResult=" + this.unifierResult + "}";
    }

    public static CEqualStep of(CEqual constraint, StepResult result, @Nullable IUnifier.Result<IUnifier.Immutable> unifierResult) {
        return new CEqualStep(constraint, result, unifierResult);
    }

    public static CEqualStep copyOf(ACEqualStep instance) {
        if (instance instanceof CEqualStep) {
            return (CEqualStep)instance;
        }
        return CEqualStep.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    /* synthetic */ CEqualStep(CEqualStep cEqualStep, CEqual cEqual, StepResult stepResult, IUnifier.Result result, CEqualStep cEqualStep2) {
        this(cEqualStep, cEqual, stepResult, result);
    }

    public static final class Builder {
        private static final long INIT_BIT_CONSTRAINT = 1L;
        private static final long INIT_BIT_RESULT = 2L;
        private long initBits = 3L;
        private CEqual constraint;
        private StepResult result;
        private IUnifier.Result<IUnifier.Immutable> unifierResult;

        private Builder() {
        }

        public final Builder from(IStep instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(ACEqualStep instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            IStep instance;
            if (object instanceof IStep) {
                instance = (IStep)object;
                this.result(instance.result());
            }
            if (object instanceof ACEqualStep) {
                instance = (ACEqualStep)object;
                IUnifier.Result<IUnifier.Immutable> unifierResultValue = ((ACEqualStep)instance).unifierResult();
                if (unifierResultValue != null) {
                    this.unifierResult(unifierResultValue);
                }
                this.constraint(((ACEqualStep)instance).constraint());
            }
        }

        public final Builder constraint(CEqual constraint) {
            this.constraint = Objects.requireNonNull(constraint, "constraint");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder result(StepResult result) {
            this.result = Objects.requireNonNull(result, "result");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder unifierResult(@Nullable IUnifier.Result<IUnifier.Immutable> unifierResult) {
            this.unifierResult = unifierResult;
            return this;
        }

        public CEqualStep build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new CEqualStep(null, this.constraint, this.result, this.unifierResult, null);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("constraint");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("result");
            }
            return "Cannot build CEqualStep, some of required attributes are not set " + attributes;
        }
    }
}

