/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.solver.persistent.step;

import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.stratego.TermIndex;
import mb.statix.constraints.CAstId;
import mb.statix.scopegraph.Scope;
import mb.statix.solver.persistent.step.ACAstIdStep;
import mb.statix.solver.persistent.step.IStep;
import mb.statix.solver.persistent.step.StepResult;

public final class CAstIdStep
extends ACAstIdStep {
    private final CAstId constraint;
    private final StepResult result;
    @Nullable
    private final ITerm index;
    private transient int hashCode;
    private volatile transient long lazyInitBitmap;
    private static final long INDEX_AS_TERM_INDEX_LAZY_INIT_BIT = 1L;
    private transient Optional<TermIndex> indexAsTermIndex;
    private static final long INDEX_AS_SCOPE_LAZY_INIT_BIT = 2L;
    private transient Optional<Scope> indexAsScope;

    private CAstIdStep(CAstId constraint, StepResult result, @Nullable ITerm index) {
        this.constraint = Objects.requireNonNull(constraint, "constraint");
        this.result = Objects.requireNonNull(result, "result");
        this.index = index;
    }

    private CAstIdStep(CAstIdStep original, CAstId constraint, StepResult result, @Nullable ITerm index) {
        this.constraint = constraint;
        this.result = result;
        this.index = index;
    }

    @Override
    public CAstId constraint() {
        return this.constraint;
    }

    @Override
    public StepResult result() {
        return this.result;
    }

    @Override
    @Nullable
    public ITerm index() {
        return this.index;
    }

    public final CAstIdStep withConstraint(CAstId value) {
        if (this.constraint == value) {
            return this;
        }
        CAstId newValue = Objects.requireNonNull(value, "constraint");
        return new CAstIdStep(this, newValue, this.result, this.index);
    }

    public final CAstIdStep withResult(StepResult value) {
        if (this.result == value) {
            return this;
        }
        StepResult newValue = Objects.requireNonNull(value, "result");
        return new CAstIdStep(this, this.constraint, newValue, this.index);
    }

    public final CAstIdStep withIndex(@Nullable ITerm value) {
        if (this.index == value) {
            return this;
        }
        return new CAstIdStep(this, this.constraint, this.result, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CAstIdStep && this.equalTo(0, (CAstIdStep)another);
    }

    private boolean equalTo(int synthetic, CAstIdStep another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.constraint.equals(another.constraint) && this.result.equals(another.result) && Objects.equals(this.index, another.index);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.constraint.hashCode();
        h += (h << 5) + this.result.hashCode();
        h += (h << 5) + Objects.hashCode(this.index);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("CAstIdStep{");
        builder.append("constraint=").append(this.constraint);
        builder.append(", ");
        builder.append("result=").append(this.result);
        if (this.index != null) {
            builder.append(", ");
            builder.append("index=").append(this.index);
        }
        return builder.append("}").toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<TermIndex> indexAsTermIndex() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            CAstIdStep cAstIdStep = this;
            synchronized (cAstIdStep) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.indexAsTermIndex = Objects.requireNonNull(super.indexAsTermIndex(), "indexAsTermIndex");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.indexAsTermIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<Scope> indexAsScope() {
        if ((this.lazyInitBitmap & 2L) == 0L) {
            CAstIdStep cAstIdStep = this;
            synchronized (cAstIdStep) {
                if ((this.lazyInitBitmap & 2L) == 0L) {
                    this.indexAsScope = Objects.requireNonNull(super.indexAsScope(), "indexAsScope");
                    this.lazyInitBitmap |= 2L;
                }
            }
        }
        return this.indexAsScope;
    }

    public static CAstIdStep of(CAstId constraint, StepResult result, @Nullable ITerm index) {
        return new CAstIdStep(constraint, result, index);
    }

    public static CAstIdStep copyOf(ACAstIdStep instance) {
        if (instance instanceof CAstIdStep) {
            return (CAstIdStep)instance;
        }
        return CAstIdStep.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    /* synthetic */ CAstIdStep(CAstIdStep cAstIdStep, CAstId cAstId, StepResult stepResult, ITerm iTerm, CAstIdStep cAstIdStep2) {
        this(cAstIdStep, cAstId, stepResult, iTerm);
    }

    public static final class Builder {
        private static final long INIT_BIT_CONSTRAINT = 1L;
        private static final long INIT_BIT_RESULT = 2L;
        private long initBits = 3L;
        private CAstId constraint;
        private StepResult result;
        private ITerm index;

        private Builder() {
        }

        public final Builder from(ACAstIdStep instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(IStep instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            IStep instance;
            if (object instanceof ACAstIdStep) {
                instance = (ACAstIdStep)object;
                ITerm indexValue = ((ACAstIdStep)instance).index();
                if (indexValue != null) {
                    this.index(indexValue);
                }
                this.constraint(((ACAstIdStep)instance).constraint());
            }
            if (object instanceof IStep) {
                instance = (IStep)object;
                this.result(instance.result());
            }
        }

        public final Builder constraint(CAstId constraint) {
            this.constraint = Objects.requireNonNull(constraint, "constraint");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder result(StepResult result) {
            this.result = Objects.requireNonNull(result, "result");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder index(@Nullable ITerm index) {
            this.index = index;
            return this;
        }

        public CAstIdStep build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new CAstIdStep(null, this.constraint, this.result, this.index, null);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("constraint");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("result");
            }
            return "Cannot build CAstIdStep, some of required attributes are not set " + attributes;
        }
    }
}

