/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.constraints;

import io.usethesource.capsule.Set;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.substitution.IRenaming;
import mb.nabl2.terms.substitution.ISubstitution;
import mb.nabl2.util.TermFormatter;
import mb.statix.solver.IConstraint;
import mb.statix.solver.completeness.ICompleteness;
import org.metaborg.util.collection.CapsuleUtil;
import org.metaborg.util.functions.Action1;

public final class CNew
implements IConstraint,
Serializable {
    private static final long serialVersionUID = 1L;
    private final ITerm scopeTerm;
    private final ITerm datumTerm;
    @Nullable
    private final IConstraint cause;
    @Nullable
    private final ICompleteness.Immutable ownCriticalEdges;
    @Nullable
    private final CNew origin;
    private final int hashCode = this.computeHashCode();

    public CNew(ITerm scopeTerm, ITerm datumTerm) {
        this(scopeTerm, datumTerm, null, null, null);
    }

    private CNew(ITerm scopeTerm, ITerm datumTerm, @Nullable IConstraint cause, @Nullable CNew origin, @Nullable ICompleteness.Immutable ownCriticalEdges) {
        this.scopeTerm = scopeTerm;
        this.datumTerm = datumTerm;
        this.cause = cause;
        this.origin = origin;
        this.ownCriticalEdges = ownCriticalEdges;
    }

    public ITerm scopeTerm() {
        return this.scopeTerm;
    }

    public ITerm datumTerm() {
        return this.datumTerm;
    }

    public CNew withArguments(ITerm scopeTerm, ITerm datumTerm) {
        if (this.scopeTerm == scopeTerm && this.datumTerm == datumTerm) {
            return this;
        }
        return new CNew(scopeTerm, datumTerm, this.cause, this.origin, this.ownCriticalEdges);
    }

    @Override
    public <R> R match(IConstraint.Cases<R> cases) {
        return cases.caseNew(this);
    }

    @Override
    public <R, E extends Throwable> R matchOrThrow(IConstraint.CheckedCases<R, E> cases) throws E {
        return cases.caseNew(this);
    }

    @Override
    public Set.Immutable<ITermVar> getVars() {
        return Set.Immutable.union(this.scopeTerm.getVars(), this.datumTerm.getVars());
    }

    @Override
    public Optional<IConstraint> cause() {
        return Optional.ofNullable(this.cause);
    }

    @Override
    public CNew withCause(@Nullable IConstraint cause) {
        if (this.cause == cause) {
            return this;
        }
        return new CNew(this.scopeTerm, this.datumTerm, cause, this.origin, this.ownCriticalEdges);
    }

    @Override
    @Nullable
    public CNew origin() {
        return this.origin;
    }

    @Override
    public Optional<ICompleteness.Immutable> ownCriticalEdges() {
        return Optional.ofNullable(this.ownCriticalEdges);
    }

    @Override
    public CNew withOwnCriticalEdges(ICompleteness.Immutable criticalEdges) {
        if (this.ownCriticalEdges == criticalEdges) {
            return this;
        }
        return new CNew(this.scopeTerm, this.datumTerm, this.cause, this.origin, criticalEdges);
    }

    @Override
    public Set.Immutable<ITermVar> freeVars() {
        Set.Transient freeVars = CapsuleUtil.transientSet();
        this.doVisitFreeVars(arg_0 -> freeVars.__insert(arg_0));
        return freeVars.freeze();
    }

    @Override
    public void visitFreeVars(Action1<ITermVar> onFreeVar) {
        this.doVisitFreeVars(onFreeVar);
    }

    private void doVisitFreeVars(Action1<ITermVar> onFreeVar) {
        this.scopeTerm.getVars().stream().forEach(onFreeVar::apply);
        this.datumTerm.getVars().stream().forEach(onFreeVar::apply);
    }

    @Override
    public CNew apply(ISubstitution.Immutable subst) {
        return this.apply(subst, false);
    }

    @Override
    public CNew unsafeApply(ISubstitution.Immutable subst) {
        return this.unsafeApply(subst, false);
    }

    @Override
    public CNew apply(IRenaming subst) {
        return this.apply(subst, false);
    }

    @Override
    public CNew apply(ISubstitution.Immutable subst, boolean trackOrigin) {
        return new CNew(subst.apply(this.scopeTerm), subst.apply(this.datumTerm), this.cause, this.origin == null && trackOrigin ? this : this.origin, this.ownCriticalEdges == null ? null : this.ownCriticalEdges.apply(subst));
    }

    @Override
    public CNew unsafeApply(ISubstitution.Immutable subst, boolean trackOrigin) {
        return this.apply(subst, trackOrigin);
    }

    @Override
    public CNew apply(IRenaming subst, boolean trackOrigin) {
        return new CNew(subst.apply(this.scopeTerm), subst.apply(this.datumTerm), this.cause, this.origin == null && trackOrigin ? this : this.origin, this.ownCriticalEdges == null ? null : this.ownCriticalEdges.apply(subst));
    }

    @Override
    public String toString(TermFormatter termToString) {
        StringBuilder sb = new StringBuilder();
        sb.append("new ");
        sb.append(termToString.format(this.scopeTerm));
        sb.append(" : ");
        sb.append(termToString.format(this.datumTerm));
        return sb.toString();
    }

    public String toString() {
        return this.toString(Object::toString);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CNew that = (CNew)o;
        return this.hashCode == that.hashCode && Objects.equals(this.scopeTerm, that.scopeTerm) && Objects.equals(this.datumTerm, that.datumTerm) && Objects.equals(this.cause, that.cause) && Objects.equals(this.origin, that.origin);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        return Objects.hash(this.scopeTerm, this.datumTerm, this.cause, this.origin);
    }
}

