/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.constraints;

import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.util.Objects;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.substitution.IRenaming;
import mb.nabl2.terms.substitution.ISubstitution;
import mb.nabl2.util.TermFormatter;
import mb.scopegraph.oopsla20.reference.ResolutionException;
import mb.scopegraph.resolution.StateMachine;
import mb.statix.constraints.AResolveQuery;
import mb.statix.constraints.CResolveQuery;
import mb.statix.constraints.IResolveQuery;
import mb.statix.constraints.messages.IMessage;
import mb.statix.solver.IConstraint;
import mb.statix.solver.query.QueryFilter;
import mb.statix.solver.query.QueryMin;
import mb.statix.solver.query.QueryProject;

public final class CCompiledQuery
extends AResolveQuery
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final StateMachine<ITerm> stateMachine;
    @Nullable
    private final CCompiledQuery origin;
    private final int hashCode = this.computeHashCode();

    public CCompiledQuery(QueryFilter filter, QueryMin min2, QueryProject project, ITerm scopeTerm, ITerm resultTerm, StateMachine<ITerm> stateMachine) {
        this(filter, min2, project, scopeTerm, resultTerm, null, null, null, stateMachine);
    }

    public CCompiledQuery(QueryFilter filter, QueryMin min2, QueryProject project, ITerm scopeTerm, ITerm resultTerm, @Nullable IMessage message, StateMachine<ITerm> stateMachine) {
        this(filter, min2, project, scopeTerm, resultTerm, null, message, null, stateMachine);
    }

    private CCompiledQuery(QueryFilter filter, QueryMin min2, QueryProject project, ITerm scopeTerm, ITerm resultTerm, @Nullable IConstraint cause, @Nullable IMessage message, @Nullable CCompiledQuery origin, StateMachine<ITerm> stateMachine) {
        super(filter, min2, project, scopeTerm, resultTerm, cause, message);
        this.origin = origin;
        this.stateMachine = stateMachine;
    }

    public CCompiledQuery withArguments(QueryFilter filter, QueryMin min2, QueryProject project, ITerm scopeTerm, ITerm resultTerm, StateMachine<ITerm> stateMachine) {
        if (this.filter == filter && this.min == min2 && this.project == project && this.scopeTerm == scopeTerm && this.resultTerm == resultTerm && this.stateMachine == stateMachine) {
            return this;
        }
        return new CCompiledQuery(filter, min2, project, scopeTerm, resultTerm, this.cause, this.message, this.origin, stateMachine);
    }

    @Override
    @Nullable
    public CCompiledQuery origin() {
        return this.origin;
    }

    public StateMachine<ITerm> stateMachine() {
        return this.stateMachine;
    }

    @Override
    public <R> R match(IResolveQuery.Cases<R> cases) {
        return cases.caseCompiledQuery(this);
    }

    @Override
    public <R, E extends Throwable> R matchInResolution(IResolveQuery.ResolutionFunction1<CResolveQuery, R> onResolveQuery, IResolveQuery.ResolutionFunction1<CCompiledQuery, R> onCompiledQuery) throws ResolutionException, InterruptedException {
        return onCompiledQuery.apply(this);
    }

    @Override
    public CCompiledQuery withCause(IConstraint cause) {
        if (this.cause == cause) {
            return this;
        }
        return new CCompiledQuery(this.filter, this.min, this.project, this.scopeTerm, this.resultTerm, cause, this.message, this.origin, this.stateMachine);
    }

    @Override
    public CCompiledQuery apply(ISubstitution.Immutable subst) {
        return this.apply(subst, false);
    }

    @Override
    public CCompiledQuery unsafeApply(ISubstitution.Immutable subst) {
        return this.unsafeApply(subst, false);
    }

    @Override
    public CCompiledQuery apply(IRenaming subst) {
        return this.apply(subst, false);
    }

    @Override
    public CCompiledQuery apply(ISubstitution.Immutable subst, boolean trackOrigin) {
        return new CCompiledQuery(this.filter.apply(subst, trackOrigin), this.min.apply(subst, trackOrigin), this.project, subst.apply(this.scopeTerm), subst.apply(this.resultTerm), this.cause, this.message == null ? null : this.message.apply(subst), this.origin == null && trackOrigin ? this : this.origin, this.stateMachine);
    }

    @Override
    public CCompiledQuery unsafeApply(ISubstitution.Immutable subst, boolean trackOrigin) {
        return new CCompiledQuery(this.filter.unsafeApply(subst, trackOrigin), this.min.unsafeApply(subst, trackOrigin), this.project, subst.apply(this.scopeTerm), subst.apply(this.resultTerm), this.cause, this.message == null ? null : this.message.apply(subst), this.origin == null && trackOrigin ? this : this.origin, this.stateMachine);
    }

    @Override
    public CCompiledQuery apply(IRenaming subst, boolean trackOrigin) {
        return new CCompiledQuery(this.filter.apply(subst, trackOrigin), this.min.apply(subst, trackOrigin), this.project, subst.apply(this.scopeTerm), subst.apply(this.resultTerm), this.cause, this.message == null ? null : this.message.apply(subst), this.origin == null && trackOrigin ? this : this.origin, this.stateMachine);
    }

    @Override
    public String toString(TermFormatter termToString) {
        StringBuilder sb = new StringBuilder();
        sb.append("compiled query ");
        sb.append(this.filter.toString(termToString));
        sb.append(" ");
        sb.append(this.min.toString(termToString));
        sb.append(" ");
        sb.append(this.project.toString(termToString));
        sb.append(" in ");
        sb.append(termToString.format(this.scopeTerm));
        sb.append(" |-> ");
        sb.append(termToString.format(this.resultTerm));
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CCompiledQuery that = (CCompiledQuery)o;
        return this.hashCode == that.hashCode && Objects.equals(this.filter, that.filter) && Objects.equals(this.min, that.min) && Objects.equals(this.project, that.project) && Objects.equals(this.scopeTerm, that.scopeTerm) && Objects.equals(this.resultTerm, that.resultTerm) && Objects.equals(this.cause, that.cause) && Objects.equals(this.message, that.message) && Objects.equals(this.origin, that.origin) && Objects.equals(this.stateMachine, that.stateMachine);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        return Objects.hash(this.filter, this.min, this.project, this.scopeTerm, this.resultTerm, this.cause, this.message, this.origin, this.stateMachine);
    }
}

