/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.constraints;

import io.usethesource.capsule.Set;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.substitution.IRenaming;
import mb.nabl2.terms.substitution.ISubstitution;
import mb.nabl2.util.TermFormatter;
import mb.statix.solver.IConstraint;
import org.metaborg.util.collection.CapsuleUtil;
import org.metaborg.util.functions.Action1;

public final class CAstId
implements IConstraint,
Serializable {
    private static final long serialVersionUID = 1L;
    private final ITerm term;
    private final ITerm idTerm;
    @Nullable
    private final IConstraint cause;
    @Nullable
    private final CAstId origin;
    private final int hashCode = this.computeHashCode();

    public CAstId(ITerm term, ITerm idTerm) {
        this(term, idTerm, null, null);
    }

    private CAstId(ITerm term, ITerm idTerm, @Nullable IConstraint cause, @Nullable CAstId origin) {
        this.term = term;
        this.idTerm = idTerm;
        this.cause = cause;
        this.origin = origin;
    }

    public ITerm astTerm() {
        return this.term;
    }

    public ITerm idTerm() {
        return this.idTerm;
    }

    public CAstId withArguments(ITerm term, ITerm idTerm) {
        if (this.term == term && this.idTerm == idTerm) {
            return this;
        }
        return new CAstId(term, idTerm, this.cause, this.origin);
    }

    @Override
    public Optional<IConstraint> cause() {
        return Optional.ofNullable(this.cause);
    }

    @Override
    public CAstId withCause(@Nullable IConstraint cause) {
        if (this.cause == cause) {
            return this;
        }
        return new CAstId(this.term, this.idTerm, cause, this.origin);
    }

    @Override
    @Nullable
    public CAstId origin() {
        return this.origin;
    }

    @Override
    public <R> R match(IConstraint.Cases<R> cases) {
        return cases.caseTermId(this);
    }

    @Override
    public <R, E extends Throwable> R matchOrThrow(IConstraint.CheckedCases<R, E> cases) throws E {
        return cases.caseTermId(this);
    }

    @Override
    public Set.Immutable<ITermVar> getVars() {
        return Set.Immutable.union(this.term.getVars(), this.idTerm.getVars());
    }

    @Override
    public Set.Immutable<ITermVar> freeVars() {
        Set.Transient freeVars = CapsuleUtil.transientSet();
        this.doVisitFreeVars(arg_0 -> freeVars.__insert(arg_0));
        return freeVars.freeze();
    }

    @Override
    public void visitFreeVars(Action1<ITermVar> onFreeVar) {
        this.doVisitFreeVars(onFreeVar);
    }

    private void doVisitFreeVars(Action1<ITermVar> onFreeVar) {
        this.term.getVars().forEach(onFreeVar::apply);
        this.idTerm.getVars().forEach(onFreeVar::apply);
    }

    @Override
    public CAstId apply(ISubstitution.Immutable subst) {
        return this.apply(subst, false);
    }

    @Override
    public CAstId unsafeApply(ISubstitution.Immutable subst) {
        return this.unsafeApply(subst, false);
    }

    @Override
    public CAstId apply(IRenaming subst) {
        return this.apply(subst, false);
    }

    @Override
    public CAstId apply(ISubstitution.Immutable subst, boolean trackOrigin) {
        return new CAstId(subst.apply(this.term), subst.apply(this.idTerm), this.cause, this.origin == null && trackOrigin ? this : this.origin);
    }

    @Override
    public CAstId unsafeApply(ISubstitution.Immutable subst, boolean trackOrigin) {
        return this.apply(subst, trackOrigin);
    }

    @Override
    public CAstId apply(IRenaming subst, boolean trackOrigin) {
        return new CAstId(subst.apply(this.term), subst.apply(this.idTerm), this.cause, this.origin == null && trackOrigin ? this : this.origin);
    }

    @Override
    public String toString(TermFormatter termToString) {
        StringBuilder sb = new StringBuilder();
        sb.append("termId(");
        sb.append(termToString.format(this.term));
        sb.append(", ");
        sb.append(termToString.format(this.idTerm));
        sb.append(")");
        return sb.toString();
    }

    public String toString() {
        return this.toString(Object::toString);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CAstId that = (CAstId)o;
        return this.hashCode == that.hashCode && Objects.equals(this.term, that.term) && Objects.equals(this.idTerm, that.idTerm) && Objects.equals(this.cause, that.cause) && Objects.equals(this.origin, that.origin);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        return Objects.hash(this.term, this.idTerm, this.cause, this.origin);
    }
}

