/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.concurrent;

import io.usethesource.capsule.Map;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import mb.nabl2.terms.ITerm;
import mb.p_raffrayi.IUnitResult;
import mb.p_raffrayi.impl.Result;
import mb.statix.concurrent.AStatixProject;
import mb.statix.concurrent.IStatixGroup;
import mb.statix.concurrent.IStatixUnit;
import mb.statix.concurrent.ProjectResult;
import mb.statix.concurrent.SolverState;
import mb.statix.library.IStatixLibrary;
import mb.statix.scopegraph.Scope;
import mb.statix.solver.tracer.SolverTracer;
import mb.statix.spec.Rule;

public final class StatixProject<TR extends SolverTracer.IResult<TR>>
extends AStatixProject<TR> {
    private final String resource;
    private final Rule rule;
    private final Map.Immutable<String, IStatixGroup> groups;
    private final Map.Immutable<String, IStatixUnit> units;
    private final Map.Immutable<String, IStatixLibrary> libraries;
    private final boolean changed;
    @Nullable
    private final IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, ProjectResult<TR>, SolverState>> previousResult;
    private transient int hashCode;

    private StatixProject(String resource, Optional<? extends Rule> rule, Map.Immutable<String, IStatixGroup> groups, Map.Immutable<String, IStatixUnit> units, Map.Immutable<String, IStatixLibrary> libraries, boolean changed, @Nullable IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, ProjectResult<TR>, SolverState>> previousResult) {
        this.resource = Objects.requireNonNull(resource, "resource");
        this.rule = rule.orElse(null);
        this.groups = Objects.requireNonNull(groups, "groups");
        this.units = Objects.requireNonNull(units, "units");
        this.libraries = Objects.requireNonNull(libraries, "libraries");
        this.changed = changed;
        this.previousResult = previousResult;
    }

    private StatixProject(StatixProject<TR> original, String resource, Rule rule, Map.Immutable<String, IStatixGroup> groups, Map.Immutable<String, IStatixUnit> units, Map.Immutable<String, IStatixLibrary> libraries, boolean changed, @Nullable IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, ProjectResult<TR>, SolverState>> previousResult) {
        this.resource = resource;
        this.rule = rule;
        this.groups = groups;
        this.units = units;
        this.libraries = libraries;
        this.changed = changed;
        this.previousResult = previousResult;
    }

    @Override
    public String resource() {
        return this.resource;
    }

    @Override
    public Optional<Rule> rule() {
        return Optional.ofNullable(this.rule);
    }

    @Override
    public Map.Immutable<String, IStatixGroup> groups() {
        return this.groups;
    }

    @Override
    public Map.Immutable<String, IStatixUnit> units() {
        return this.units;
    }

    @Override
    public Map.Immutable<String, IStatixLibrary> libraries() {
        return this.libraries;
    }

    @Override
    public boolean changed() {
        return this.changed;
    }

    @Override
    @Nullable
    public IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, ProjectResult<TR>, SolverState>> previousResult() {
        return this.previousResult;
    }

    public final StatixProject<TR> withResource(String value) {
        String newValue = Objects.requireNonNull(value, "resource");
        if (this.resource.equals(newValue)) {
            return this;
        }
        return new StatixProject<TR>(this, newValue, this.rule, this.groups, this.units, this.libraries, this.changed, this.previousResult);
    }

    public final StatixProject<TR> withRule(Rule value) {
        Rule newValue = Objects.requireNonNull(value, "rule");
        if (this.rule == newValue) {
            return this;
        }
        return new StatixProject<TR>(this, this.resource, newValue, this.groups, this.units, this.libraries, this.changed, this.previousResult);
    }

    public final StatixProject<TR> withRule(Optional<? extends Rule> optional) {
        Rule value = optional.orElse(null);
        if (this.rule == value) {
            return this;
        }
        return new StatixProject<TR>(this, this.resource, value, this.groups, this.units, this.libraries, this.changed, this.previousResult);
    }

    public final StatixProject<TR> withGroups(Map.Immutable<String, IStatixGroup> value) {
        if (this.groups == value) {
            return this;
        }
        Map.Immutable<String, IStatixGroup> newValue = Objects.requireNonNull(value, "groups");
        return new StatixProject<TR>(this, this.resource, this.rule, newValue, this.units, this.libraries, this.changed, this.previousResult);
    }

    public final StatixProject<TR> withUnits(Map.Immutable<String, IStatixUnit> value) {
        if (this.units == value) {
            return this;
        }
        Map.Immutable<String, IStatixUnit> newValue = Objects.requireNonNull(value, "units");
        return new StatixProject<TR>(this, this.resource, this.rule, this.groups, newValue, this.libraries, this.changed, this.previousResult);
    }

    public final StatixProject<TR> withLibraries(Map.Immutable<String, IStatixLibrary> value) {
        if (this.libraries == value) {
            return this;
        }
        Map.Immutable<String, IStatixLibrary> newValue = Objects.requireNonNull(value, "libraries");
        return new StatixProject<TR>(this, this.resource, this.rule, this.groups, this.units, newValue, this.changed, this.previousResult);
    }

    public final StatixProject<TR> withChanged(boolean value) {
        if (this.changed == value) {
            return this;
        }
        return new StatixProject<TR>(this, this.resource, this.rule, this.groups, this.units, this.libraries, value, this.previousResult);
    }

    public final StatixProject<TR> withPreviousResult(@Nullable IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, ProjectResult<TR>, SolverState>> value) {
        if (this.previousResult == value) {
            return this;
        }
        return new StatixProject<TR>(this, this.resource, this.rule, this.groups, this.units, this.libraries, this.changed, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof StatixProject && this.equalTo(0, (StatixProject)another);
    }

    private boolean equalTo(int synthetic, StatixProject<?> another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.resource.equals(another.resource) && Objects.equals(this.rule, another.rule) && this.groups.equals(another.groups) && this.units.equals(another.units) && this.libraries.equals(another.libraries) && this.changed == another.changed && Objects.equals(this.previousResult, another.previousResult);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.resource.hashCode();
        h += (h << 5) + Objects.hashCode(this.rule);
        h += (h << 5) + this.groups.hashCode();
        h += (h << 5) + this.units.hashCode();
        h += (h << 5) + this.libraries.hashCode();
        h += (h << 5) + Boolean.hashCode(this.changed);
        h += (h << 5) + Objects.hashCode(this.previousResult);
        return h;
    }

    public static <TR extends SolverTracer.IResult<TR>> StatixProject<TR> of(String resource, Optional<? extends Rule> rule, Map.Immutable<String, IStatixGroup> groups, Map.Immutable<String, IStatixUnit> units, Map.Immutable<String, IStatixLibrary> libraries, boolean changed, @Nullable IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, ProjectResult<TR>, SolverState>> previousResult) {
        return new StatixProject<TR>(resource, rule, groups, units, libraries, changed, previousResult);
    }

    public static <TR extends SolverTracer.IResult<TR>> StatixProject<TR> copyOf(AStatixProject<TR> instance) {
        if (instance instanceof StatixProject) {
            return (StatixProject)instance;
        }
        return StatixProject.builder().from(instance).build();
    }

    public static <TR extends SolverTracer.IResult<TR>> Builder<TR> builder() {
        return new Builder();
    }

    /* synthetic */ StatixProject(StatixProject statixProject, String string, Rule rule, Map.Immutable immutable, Map.Immutable immutable2, Map.Immutable immutable3, boolean bl, IUnitResult iUnitResult, StatixProject statixProject2) {
        this(statixProject, string, rule, (Map.Immutable<String, IStatixGroup>)immutable, (Map.Immutable<String, IStatixUnit>)immutable2, (Map.Immutable<String, IStatixLibrary>)immutable3, bl, iUnitResult);
    }

    public static final class Builder<TR extends SolverTracer.IResult<TR>> {
        private static final long INIT_BIT_RESOURCE = 1L;
        private static final long INIT_BIT_GROUPS = 2L;
        private static final long INIT_BIT_UNITS = 4L;
        private static final long INIT_BIT_LIBRARIES = 8L;
        private static final long INIT_BIT_CHANGED = 16L;
        private long initBits = 31L;
        private String resource;
        private Rule rule;
        private Map.Immutable<String, IStatixGroup> groups;
        private Map.Immutable<String, IStatixUnit> units;
        private Map.Immutable<String, IStatixLibrary> libraries;
        private boolean changed;
        private IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, ProjectResult<TR>, SolverState>> previousResult;

        private Builder() {
        }

        public final Builder<TR> from(AStatixProject<TR> instance) {
            Objects.requireNonNull(instance, "instance");
            this.resource(instance.resource());
            Optional<Rule> ruleOptional = instance.rule();
            if (ruleOptional.isPresent()) {
                this.rule(ruleOptional);
            }
            this.groups(instance.groups());
            this.units(instance.units());
            this.libraries(instance.libraries());
            this.changed(instance.changed());
            IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, ProjectResult<TR>, SolverState>> previousResultValue = instance.previousResult();
            if (previousResultValue != null) {
                this.previousResult(previousResultValue);
            }
            return this;
        }

        public final Builder<TR> resource(String resource) {
            this.resource = Objects.requireNonNull(resource, "resource");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder<TR> rule(Rule rule) {
            this.rule = Objects.requireNonNull(rule, "rule");
            return this;
        }

        public final Builder<TR> rule(Optional<? extends Rule> rule) {
            this.rule = rule.orElse(null);
            return this;
        }

        public final Builder<TR> groups(Map.Immutable<String, IStatixGroup> groups) {
            this.groups = Objects.requireNonNull(groups, "groups");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder<TR> units(Map.Immutable<String, IStatixUnit> units) {
            this.units = Objects.requireNonNull(units, "units");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder<TR> libraries(Map.Immutable<String, IStatixLibrary> libraries) {
            this.libraries = Objects.requireNonNull(libraries, "libraries");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder<TR> changed(boolean changed) {
            this.changed = changed;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder<TR> previousResult(@Nullable IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, ProjectResult<TR>, SolverState>> previousResult) {
            this.previousResult = previousResult;
            return this;
        }

        public StatixProject<TR> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new StatixProject(null, this.resource, this.rule, this.groups, this.units, this.libraries, this.changed, this.previousResult, null);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("resource");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("groups");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("units");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("libraries");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("changed");
            }
            return "Cannot build StatixProject, some of required attributes are not set " + attributes;
        }
    }
}

