/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.concurrent;

import io.usethesource.capsule.Map;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Objects;
import mb.nabl2.terms.ITerm;
import mb.p_raffrayi.IUnitResult;
import mb.p_raffrayi.impl.Result;
import mb.statix.concurrent.AProjectResult;
import mb.statix.concurrent.GroupResult;
import mb.statix.concurrent.SolverState;
import mb.statix.concurrent.UnitResult;
import mb.statix.scopegraph.Scope;
import mb.statix.solver.persistent.SolverResult;
import mb.statix.solver.tracer.SolverTracer;
import org.metaborg.util.unit.Unit;

public final class ProjectResult<TR extends SolverTracer.IResult<TR>>
extends AProjectResult<TR>
implements Serializable {
    private final String resource;
    private final Scope rootScope;
    private final Map.Immutable<String, IUnitResult<Scope, ITerm, ITerm, Unit>> libraryResults;
    private final Map.Immutable<String, IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, GroupResult<TR>, SolverState>>> groupResults;
    private final Map.Immutable<String, IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, UnitResult<TR>, SolverState>>> unitResults;
    @Nullable
    private final SolverResult<TR> solveResult;
    @Nullable
    private final Throwable exception;
    private transient int hashCode;
    private static final long serialVersionUID = 42L;

    private ProjectResult(String resource, Scope rootScope, Map.Immutable<String, IUnitResult<Scope, ITerm, ITerm, Unit>> libraryResults, Map.Immutable<String, IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, GroupResult<TR>, SolverState>>> groupResults, Map.Immutable<String, IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, UnitResult<TR>, SolverState>>> unitResults, @Nullable SolverResult<TR> solveResult, @Nullable Throwable exception) {
        this.resource = Objects.requireNonNull(resource, "resource");
        this.rootScope = Objects.requireNonNull(rootScope, "rootScope");
        this.libraryResults = Objects.requireNonNull(libraryResults, "libraryResults");
        this.groupResults = Objects.requireNonNull(groupResults, "groupResults");
        this.unitResults = Objects.requireNonNull(unitResults, "unitResults");
        this.solveResult = solveResult;
        this.exception = exception;
    }

    private ProjectResult(ProjectResult<TR> original, String resource, Scope rootScope, Map.Immutable<String, IUnitResult<Scope, ITerm, ITerm, Unit>> libraryResults, Map.Immutable<String, IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, GroupResult<TR>, SolverState>>> groupResults, Map.Immutable<String, IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, UnitResult<TR>, SolverState>>> unitResults, @Nullable SolverResult<TR> solveResult, @Nullable Throwable exception) {
        this.resource = resource;
        this.rootScope = rootScope;
        this.libraryResults = libraryResults;
        this.groupResults = groupResults;
        this.unitResults = unitResults;
        this.solveResult = solveResult;
        this.exception = exception;
    }

    @Override
    public String resource() {
        return this.resource;
    }

    @Override
    public Scope rootScope() {
        return this.rootScope;
    }

    @Override
    public Map.Immutable<String, IUnitResult<Scope, ITerm, ITerm, Unit>> libraryResults() {
        return this.libraryResults;
    }

    @Override
    public Map.Immutable<String, IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, GroupResult<TR>, SolverState>>> groupResults() {
        return this.groupResults;
    }

    @Override
    public Map.Immutable<String, IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, UnitResult<TR>, SolverState>>> unitResults() {
        return this.unitResults;
    }

    @Override
    @Nullable
    public SolverResult<TR> solveResult() {
        return this.solveResult;
    }

    @Override
    @Nullable
    public Throwable exception() {
        return this.exception;
    }

    public final ProjectResult<TR> withResource(String value) {
        String newValue = Objects.requireNonNull(value, "resource");
        if (this.resource.equals(newValue)) {
            return this;
        }
        return new ProjectResult<TR>(this, newValue, this.rootScope, this.libraryResults, this.groupResults, this.unitResults, this.solveResult, this.exception);
    }

    public final ProjectResult<TR> withRootScope(Scope value) {
        if (this.rootScope == value) {
            return this;
        }
        Scope newValue = Objects.requireNonNull(value, "rootScope");
        return new ProjectResult<TR>(this, this.resource, newValue, this.libraryResults, this.groupResults, this.unitResults, this.solveResult, this.exception);
    }

    public final ProjectResult<TR> withLibraryResults(Map.Immutable<String, IUnitResult<Scope, ITerm, ITerm, Unit>> value) {
        if (this.libraryResults == value) {
            return this;
        }
        Map.Immutable<String, IUnitResult<Scope, ITerm, ITerm, Unit>> newValue = Objects.requireNonNull(value, "libraryResults");
        return new ProjectResult<TR>(this, this.resource, this.rootScope, newValue, this.groupResults, this.unitResults, this.solveResult, this.exception);
    }

    public final ProjectResult<TR> withGroupResults(Map.Immutable<String, IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, GroupResult<TR>, SolverState>>> value) {
        if (this.groupResults == value) {
            return this;
        }
        Map.Immutable<String, IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, GroupResult<TR>, SolverState>>> newValue = Objects.requireNonNull(value, "groupResults");
        return new ProjectResult<TR>(this, this.resource, this.rootScope, this.libraryResults, newValue, this.unitResults, this.solveResult, this.exception);
    }

    public final ProjectResult<TR> withUnitResults(Map.Immutable<String, IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, UnitResult<TR>, SolverState>>> value) {
        if (this.unitResults == value) {
            return this;
        }
        Map.Immutable<String, IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, UnitResult<TR>, SolverState>>> newValue = Objects.requireNonNull(value, "unitResults");
        return new ProjectResult<TR>(this, this.resource, this.rootScope, this.libraryResults, this.groupResults, newValue, this.solveResult, this.exception);
    }

    public final ProjectResult<TR> withSolveResult(@Nullable SolverResult<TR> value) {
        if (this.solveResult == value) {
            return this;
        }
        return new ProjectResult<TR>(this, this.resource, this.rootScope, this.libraryResults, this.groupResults, this.unitResults, value, this.exception);
    }

    public final ProjectResult<TR> withException(@Nullable Throwable value) {
        if (this.exception == value) {
            return this;
        }
        return new ProjectResult<TR>(this, this.resource, this.rootScope, this.libraryResults, this.groupResults, this.unitResults, this.solveResult, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ProjectResult && this.equalTo(0, (ProjectResult)another);
    }

    private boolean equalTo(int synthetic, ProjectResult<?> another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.resource.equals(another.resource) && this.rootScope.equals(another.rootScope) && this.libraryResults.equals(another.libraryResults) && this.groupResults.equals(another.groupResults) && this.unitResults.equals(another.unitResults) && Objects.equals(this.solveResult, another.solveResult) && Objects.equals(this.exception, another.exception);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.resource.hashCode();
        h += (h << 5) + this.rootScope.hashCode();
        h += (h << 5) + this.libraryResults.hashCode();
        h += (h << 5) + this.groupResults.hashCode();
        h += (h << 5) + this.unitResults.hashCode();
        h += (h << 5) + Objects.hashCode(this.solveResult);
        h += (h << 5) + Objects.hashCode(this.exception);
        return h;
    }

    public static <TR extends SolverTracer.IResult<TR>> ProjectResult<TR> of(String resource, Scope rootScope, Map.Immutable<String, IUnitResult<Scope, ITerm, ITerm, Unit>> libraryResults, Map.Immutable<String, IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, GroupResult<TR>, SolverState>>> groupResults, Map.Immutable<String, IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, UnitResult<TR>, SolverState>>> unitResults, @Nullable SolverResult<TR> solveResult, @Nullable Throwable exception) {
        return new ProjectResult<TR>(resource, rootScope, libraryResults, groupResults, unitResults, solveResult, exception);
    }

    public static <TR extends SolverTracer.IResult<TR>> ProjectResult<TR> copyOf(AProjectResult<TR> instance) {
        if (instance instanceof ProjectResult) {
            return (ProjectResult)instance;
        }
        return ProjectResult.builder().from(instance).build();
    }

    public static <TR extends SolverTracer.IResult<TR>> Builder<TR> builder() {
        return new Builder();
    }

    /* synthetic */ ProjectResult(ProjectResult projectResult, String string, Scope scope, Map.Immutable immutable, Map.Immutable immutable2, Map.Immutable immutable3, SolverResult solverResult, Throwable throwable, ProjectResult projectResult2) {
        this(projectResult, string, scope, (Map.Immutable<String, IUnitResult<Scope, ITerm, ITerm, Unit>>)immutable, immutable2, immutable3, solverResult, throwable);
    }

    public static final class Builder<TR extends SolverTracer.IResult<TR>> {
        private static final long INIT_BIT_RESOURCE = 1L;
        private static final long INIT_BIT_ROOT_SCOPE = 2L;
        private static final long INIT_BIT_LIBRARY_RESULTS = 4L;
        private static final long INIT_BIT_GROUP_RESULTS = 8L;
        private static final long INIT_BIT_UNIT_RESULTS = 16L;
        private long initBits = 31L;
        private String resource;
        private Scope rootScope;
        private Map.Immutable<String, IUnitResult<Scope, ITerm, ITerm, Unit>> libraryResults;
        private Map.Immutable<String, IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, GroupResult<TR>, SolverState>>> groupResults;
        private Map.Immutable<String, IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, UnitResult<TR>, SolverState>>> unitResults;
        private SolverResult<TR> solveResult;
        private Throwable exception;

        private Builder() {
        }

        public final Builder<TR> from(AProjectResult<TR> instance) {
            Throwable exceptionValue;
            Objects.requireNonNull(instance, "instance");
            this.resource(instance.resource());
            this.rootScope(instance.rootScope());
            this.libraryResults(instance.libraryResults());
            this.groupResults(instance.groupResults());
            this.unitResults(instance.unitResults());
            SolverResult<TR> solveResultValue = instance.solveResult();
            if (solveResultValue != null) {
                this.solveResult(solveResultValue);
            }
            if ((exceptionValue = instance.exception()) != null) {
                this.exception(exceptionValue);
            }
            return this;
        }

        public final Builder<TR> resource(String resource) {
            this.resource = Objects.requireNonNull(resource, "resource");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder<TR> rootScope(Scope rootScope) {
            this.rootScope = Objects.requireNonNull(rootScope, "rootScope");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder<TR> libraryResults(Map.Immutable<String, IUnitResult<Scope, ITerm, ITerm, Unit>> libraryResults) {
            this.libraryResults = Objects.requireNonNull(libraryResults, "libraryResults");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder<TR> groupResults(Map.Immutable<String, IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, GroupResult<TR>, SolverState>>> groupResults) {
            this.groupResults = Objects.requireNonNull(groupResults, "groupResults");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder<TR> unitResults(Map.Immutable<String, IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, UnitResult<TR>, SolverState>>> unitResults) {
            this.unitResults = Objects.requireNonNull(unitResults, "unitResults");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder<TR> solveResult(@Nullable SolverResult<TR> solveResult) {
            this.solveResult = solveResult;
            return this;
        }

        public final Builder<TR> exception(@Nullable Throwable exception) {
            this.exception = exception;
            return this;
        }

        public ProjectResult<TR> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ProjectResult(null, this.resource, this.rootScope, this.libraryResults, this.groupResults, this.unitResults, this.solveResult, this.exception, null);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("resource");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("rootScope");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("libraryResults");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("groupResults");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("unitResults");
            }
            return "Cannot build ProjectResult, some of required attributes are not set " + attributes;
        }
    }
}

