/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.concurrent;

import io.usethesource.capsule.Map;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Objects;
import mb.nabl2.terms.ITerm;
import mb.p_raffrayi.IUnitResult;
import mb.p_raffrayi.impl.Result;
import mb.statix.concurrent.AGroupResult;
import mb.statix.concurrent.SolverState;
import mb.statix.concurrent.UnitResult;
import mb.statix.scopegraph.Scope;
import mb.statix.solver.persistent.SolverResult;
import mb.statix.solver.tracer.SolverTracer;

public final class GroupResult<TR extends SolverTracer.IResult<TR>>
extends AGroupResult<TR>
implements Serializable {
    private final String resource;
    private final Map.Immutable<String, IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, GroupResult<TR>, SolverState>>> groupResults;
    private final Map.Immutable<String, IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, UnitResult<TR>, SolverState>>> unitResults;
    @Nullable
    private final SolverResult<TR> solveResult;
    @Nullable
    private final Throwable exception;
    private transient int hashCode;
    private static final long serialVersionUID = 42L;

    private GroupResult(String resource, Map.Immutable<String, IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, GroupResult<TR>, SolverState>>> groupResults, Map.Immutable<String, IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, UnitResult<TR>, SolverState>>> unitResults, @Nullable SolverResult<TR> solveResult, @Nullable Throwable exception) {
        this.resource = Objects.requireNonNull(resource, "resource");
        this.groupResults = Objects.requireNonNull(groupResults, "groupResults");
        this.unitResults = Objects.requireNonNull(unitResults, "unitResults");
        this.solveResult = solveResult;
        this.exception = exception;
    }

    private GroupResult(GroupResult<TR> original, String resource, Map.Immutable<String, IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, GroupResult<TR>, SolverState>>> groupResults, Map.Immutable<String, IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, UnitResult<TR>, SolverState>>> unitResults, @Nullable SolverResult<TR> solveResult, @Nullable Throwable exception) {
        this.resource = resource;
        this.groupResults = groupResults;
        this.unitResults = unitResults;
        this.solveResult = solveResult;
        this.exception = exception;
    }

    @Override
    public String resource() {
        return this.resource;
    }

    @Override
    public Map.Immutable<String, IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, GroupResult<TR>, SolverState>>> groupResults() {
        return this.groupResults;
    }

    @Override
    public Map.Immutable<String, IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, UnitResult<TR>, SolverState>>> unitResults() {
        return this.unitResults;
    }

    @Override
    @Nullable
    public SolverResult<TR> solveResult() {
        return this.solveResult;
    }

    @Override
    @Nullable
    public Throwable exception() {
        return this.exception;
    }

    public final GroupResult<TR> withResource(String value) {
        String newValue = Objects.requireNonNull(value, "resource");
        if (this.resource.equals(newValue)) {
            return this;
        }
        return new GroupResult<TR>(this, newValue, this.groupResults, this.unitResults, this.solveResult, this.exception);
    }

    public final GroupResult<TR> withGroupResults(Map.Immutable<String, IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, GroupResult<TR>, SolverState>>> value) {
        if (this.groupResults == value) {
            return this;
        }
        Map.Immutable<String, IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, GroupResult<TR>, SolverState>>> newValue = Objects.requireNonNull(value, "groupResults");
        return new GroupResult<TR>(this, this.resource, newValue, this.unitResults, this.solveResult, this.exception);
    }

    public final GroupResult<TR> withUnitResults(Map.Immutable<String, IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, UnitResult<TR>, SolverState>>> value) {
        if (this.unitResults == value) {
            return this;
        }
        Map.Immutable<String, IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, UnitResult<TR>, SolverState>>> newValue = Objects.requireNonNull(value, "unitResults");
        return new GroupResult<TR>(this, this.resource, this.groupResults, newValue, this.solveResult, this.exception);
    }

    public final GroupResult<TR> withSolveResult(@Nullable SolverResult<TR> value) {
        if (this.solveResult == value) {
            return this;
        }
        return new GroupResult<TR>(this, this.resource, this.groupResults, this.unitResults, value, this.exception);
    }

    public final GroupResult<TR> withException(@Nullable Throwable value) {
        if (this.exception == value) {
            return this;
        }
        return new GroupResult<TR>(this, this.resource, this.groupResults, this.unitResults, this.solveResult, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof GroupResult && this.equalTo(0, (GroupResult)another);
    }

    private boolean equalTo(int synthetic, GroupResult<?> another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.resource.equals(another.resource) && this.groupResults.equals(another.groupResults) && this.unitResults.equals(another.unitResults) && Objects.equals(this.solveResult, another.solveResult) && Objects.equals(this.exception, another.exception);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.resource.hashCode();
        h += (h << 5) + this.groupResults.hashCode();
        h += (h << 5) + this.unitResults.hashCode();
        h += (h << 5) + Objects.hashCode(this.solveResult);
        h += (h << 5) + Objects.hashCode(this.exception);
        return h;
    }

    public String toString() {
        return "GroupResult{resource=" + this.resource + ", groupResults=" + this.groupResults + ", unitResults=" + this.unitResults + ", solveResult=" + this.solveResult + ", exception=" + this.exception + "}";
    }

    public static <TR extends SolverTracer.IResult<TR>> GroupResult<TR> of(String resource, Map.Immutable<String, IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, GroupResult<TR>, SolverState>>> groupResults, Map.Immutable<String, IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, UnitResult<TR>, SolverState>>> unitResults, @Nullable SolverResult<TR> solveResult, @Nullable Throwable exception) {
        return new GroupResult<TR>(resource, groupResults, unitResults, solveResult, exception);
    }

    public static <TR extends SolverTracer.IResult<TR>> GroupResult<TR> copyOf(AGroupResult<TR> instance) {
        if (instance instanceof GroupResult) {
            return (GroupResult)instance;
        }
        return GroupResult.builder().from(instance).build();
    }

    public static <TR extends SolverTracer.IResult<TR>> Builder<TR> builder() {
        return new Builder();
    }

    /* synthetic */ GroupResult(GroupResult groupResult, String string, Map.Immutable immutable, Map.Immutable immutable2, SolverResult solverResult, Throwable throwable, GroupResult groupResult2) {
        this(groupResult, string, immutable, immutable2, solverResult, throwable);
    }

    public static final class Builder<TR extends SolverTracer.IResult<TR>> {
        private static final long INIT_BIT_RESOURCE = 1L;
        private static final long INIT_BIT_GROUP_RESULTS = 2L;
        private static final long INIT_BIT_UNIT_RESULTS = 4L;
        private long initBits = 7L;
        private String resource;
        private Map.Immutable<String, IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, GroupResult<TR>, SolverState>>> groupResults;
        private Map.Immutable<String, IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, UnitResult<TR>, SolverState>>> unitResults;
        private SolverResult<TR> solveResult;
        private Throwable exception;

        private Builder() {
        }

        public final Builder<TR> from(AGroupResult<TR> instance) {
            Throwable exceptionValue;
            Objects.requireNonNull(instance, "instance");
            this.resource(instance.resource());
            this.groupResults(instance.groupResults());
            this.unitResults(instance.unitResults());
            SolverResult<TR> solveResultValue = instance.solveResult();
            if (solveResultValue != null) {
                this.solveResult(solveResultValue);
            }
            if ((exceptionValue = instance.exception()) != null) {
                this.exception(exceptionValue);
            }
            return this;
        }

        public final Builder<TR> resource(String resource) {
            this.resource = Objects.requireNonNull(resource, "resource");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder<TR> groupResults(Map.Immutable<String, IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, GroupResult<TR>, SolverState>>> groupResults) {
            this.groupResults = Objects.requireNonNull(groupResults, "groupResults");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder<TR> unitResults(Map.Immutable<String, IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, UnitResult<TR>, SolverState>>> unitResults) {
            this.unitResults = Objects.requireNonNull(unitResults, "unitResults");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder<TR> solveResult(@Nullable SolverResult<TR> solveResult) {
            this.solveResult = solveResult;
            return this;
        }

        public final Builder<TR> exception(@Nullable Throwable exception) {
            this.exception = exception;
            return this;
        }

        public GroupResult<TR> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new GroupResult(null, this.resource, this.groupResults, this.unitResults, this.solveResult, this.exception, null);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("resource");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("groupResults");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("unitResults");
            }
            return "Cannot build GroupResult, some of required attributes are not set " + attributes;
        }
    }
}

