/*
 * Decompiled with CFR 0.152.
 */
package mb.scopegraph.pepm16.terms;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Objects;
import mb.nabl2.terms.IAttachments;
import mb.nabl2.terms.ITerm;
import mb.scopegraph.pepm16.terms.AOccurrence;
import mb.scopegraph.pepm16.terms.Namespace;
import mb.scopegraph.pepm16.terms.OccurrenceIndex;
import mb.scopegraph.pepm16.terms.SpacedName;
import org.metaborg.util.collection.ImList;

public final class Occurrence
extends AOccurrence
implements Serializable {
    private final IAttachments attachments;
    private final Namespace namespace;
    private final ITerm name;
    private final OccurrenceIndex index;
    private final int hashCode;
    private volatile transient long lazyInitBitmap;
    private static final long SPACED_NAME_LAZY_INIT_BIT = 1L;
    private transient SpacedName spacedName;
    private static final long OP_LAZY_INIT_BIT = 2L;
    private transient String op;
    private static final long ARGS_LAZY_INIT_BIT = 4L;
    private transient ImList.Immutable<ITerm> args;
    private static final long serialVersionUID = 42L;

    private Occurrence(Namespace namespace, ITerm name, OccurrenceIndex index) {
        this.namespace = Objects.requireNonNull(namespace, "namespace");
        this.name = Objects.requireNonNull(name, "name");
        this.index = Objects.requireNonNull(index, "index");
        this.attachments = Objects.requireNonNull(super.getAttachments(), "attachments");
        this.hashCode = super.hashCode();
    }

    private Occurrence(IAttachments attachments, Namespace namespace, ITerm name, OccurrenceIndex index) {
        this.attachments = attachments;
        this.namespace = namespace;
        this.name = name;
        this.index = index;
        this.hashCode = super.hashCode();
    }

    @Override
    public IAttachments getAttachments() {
        return this.attachments;
    }

    @Override
    public Namespace getNamespace() {
        return this.namespace;
    }

    @Override
    public ITerm getName() {
        return this.name;
    }

    @Override
    public OccurrenceIndex getIndex() {
        return this.index;
    }

    @Override
    public final Occurrence withAttachments(IAttachments value) {
        if (this.attachments == value) {
            return this;
        }
        IAttachments newValue = Objects.requireNonNull(value, "attachments");
        return new Occurrence(newValue, this.namespace, this.name, this.index);
    }

    public final Occurrence withNamespace(Namespace value) {
        if (this.namespace == value) {
            return this;
        }
        Namespace newValue = Objects.requireNonNull(value, "namespace");
        return new Occurrence(this.attachments, newValue, this.name, this.index);
    }

    public final Occurrence withName(ITerm value) {
        if (this.name == value) {
            return this;
        }
        ITerm newValue = Objects.requireNonNull(value, "name");
        return new Occurrence(this.attachments, this.namespace, newValue, this.index);
    }

    public final Occurrence withIndex(OccurrenceIndex value) {
        if (this.index == value) {
            return this;
        }
        OccurrenceIndex newValue = Objects.requireNonNull(value, "index");
        return new Occurrence(this.attachments, this.namespace, this.name, newValue);
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SpacedName getSpacedName() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            Occurrence occurrence = this;
            synchronized (occurrence) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.spacedName = Objects.requireNonNull(super.getSpacedName(), "spacedName");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.spacedName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getOp() {
        if ((this.lazyInitBitmap & 2L) == 0L) {
            Occurrence occurrence = this;
            synchronized (occurrence) {
                if ((this.lazyInitBitmap & 2L) == 0L) {
                    this.op = Objects.requireNonNull(super.getOp(), "op");
                    this.lazyInitBitmap |= 2L;
                }
            }
        }
        return this.op;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImList.Immutable<ITerm> getArgs() {
        if ((this.lazyInitBitmap & 4L) == 0L) {
            Occurrence occurrence = this;
            synchronized (occurrence) {
                if ((this.lazyInitBitmap & 4L) == 0L) {
                    this.args = Objects.requireNonNull(super.getArgs(), "args");
                    this.lazyInitBitmap |= 4L;
                }
            }
        }
        return this.args;
    }

    public static Occurrence of(Namespace namespace, ITerm name, OccurrenceIndex index) {
        return new Occurrence(namespace, name, index);
    }

    public static Occurrence copyOf(AOccurrence instance) {
        if (instance instanceof Occurrence) {
            return (Occurrence)instance;
        }
        return Occurrence.of(instance.getNamespace(), instance.getName(), instance.getIndex()).withAttachments(instance.getAttachments());
    }

    private Object readResolve() throws ObjectStreamException {
        return new Occurrence(this.attachments, this.namespace, this.name, this.index);
    }
}

