/*
 * Decompiled with CFR 0.152.
 */
package mb.scopegraph.oopsla20.reference;

import io.usethesource.capsule.Map;
import io.usethesource.capsule.Set;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import mb.scopegraph.oopsla20.IScopeGraph;
import org.metaborg.util.collection.CapsuleUtil;
import org.metaborg.util.collection.ConsList;
import org.metaborg.util.tuple.Tuple2;

public abstract class ScopeGraph<S, L, D>
implements IScopeGraph<S, L, D> {
    protected ScopeGraph() {
    }

    @Override
    public abstract Map<Tuple2<S, L>, ConsList<S>> getEdges();

    @Override
    public Collection<S> getEdges(S scope, L label) {
        return (Collection)this.getEdges().getOrDefault(Tuple2.of(scope, label), ConsList.nil());
    }

    @Override
    public abstract Map<S, D> getData();

    @Override
    public Optional<D> getData(S scope) {
        return Optional.ofNullable(this.getData().get(scope));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        AtomicBoolean first = new AtomicBoolean(true);
        this.getEdges().forEach((key, targetScope) -> {
            sb.append(first.getAndSet(false) ? " " : ", ");
            sb.append(key._1());
            sb.append(" -");
            sb.append(key._2());
            sb.append("-> ");
            sb.append(targetScope);
        });
        this.getData().forEach((key, datum) -> {
            sb.append(first.getAndSet(false) ? " " : ", ");
            sb.append(key);
            sb.append(" : ");
            sb.append(datum);
        });
        sb.append(first.get() ? "}" : " }");
        return sb.toString();
    }

    public static class Immutable<S, L, D>
    extends ScopeGraph<S, L, D>
    implements IScopeGraph.Immutable<S, L, D>,
    Serializable {
        private static final long serialVersionUID = 42L;
        private final Set.Immutable<L> labels;
        private final Map.Immutable<Tuple2<S, L>, ConsList<S>> edges;
        private final Map.Immutable<S, D> data;

        Immutable(Set.Immutable<L> labels, Map.Immutable<Tuple2<S, L>, ConsList<S>> edges, Map.Immutable<S, D> data) {
            this.labels = labels;
            this.edges = edges;
            this.data = data;
        }

        @Override
        public Set.Immutable<L> getLabels() {
            return this.labels;
        }

        @Override
        public Map<Tuple2<S, L>, ConsList<S>> getEdges() {
            return this.edges;
        }

        @Override
        public Map<S, D> getData() {
            return this.data;
        }

        @Override
        public Immutable<S, L, D> addEdge(S sourceScope, L label, S targetScope) {
            IScopeGraph.Transient scopeGraph = this.melt();
            ((Transient)scopeGraph).addEdge(sourceScope, label, targetScope);
            return ((Transient)scopeGraph).freeze();
        }

        @Override
        public Immutable<S, L, D> setDatum(S sourceScope, D datum) {
            IScopeGraph.Transient scopeGraph = this.melt();
            ((Transient)scopeGraph).setDatum(sourceScope, datum);
            return ((Transient)scopeGraph).freeze();
        }

        @Override
        public IScopeGraph.Immutable<S, L, D> addAll(IScopeGraph<S, L, D> other) {
            IScopeGraph.Transient scopeGraph = this.melt();
            ((Transient)scopeGraph).addAll(other);
            return ((Transient)scopeGraph).freeze();
        }

        @Override
        public Transient<S, L, D> melt() {
            return new Transient(this.labels.asTransient(), this.edges.asTransient(), this.data.asTransient());
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.edges.hashCode();
            result = 31 * result + this.data.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Immutable other = (Immutable)obj;
            if (!this.edges.equals(other.edges)) {
                return false;
            }
            return this.data.equals(other.data);
        }

        public static <S, L, D> Immutable<S, L, D> of() {
            return new Immutable(CapsuleUtil.immutableSet(), CapsuleUtil.immutableMap(), Map.Immutable.of());
        }
    }

    public static class Transient<S, L, D>
    extends ScopeGraph<S, L, D>
    implements IScopeGraph.Transient<S, L, D> {
        private final Set.Transient<L> labels;
        private final Map.Transient<Tuple2<S, L>, ConsList<S>> edges;
        private final Map.Transient<S, D> data;

        Transient(Set.Transient<L> labels, Map.Transient<Tuple2<S, L>, ConsList<S>> edges, Map.Transient<S, D> data) {
            this.labels = labels;
            this.edges = edges;
            this.data = data;
        }

        @Override
        public Set.Transient<L> getLabels() {
            return this.labels;
        }

        @Override
        public Map<Tuple2<S, L>, ConsList<S>> getEdges() {
            return this.edges;
        }

        @Override
        public Map<S, D> getData() {
            return this.data;
        }

        @Override
        public boolean addEdge(S sourceScope, L label, S targetScope) {
            Tuple2<S, L> key = Tuple2.of(sourceScope, label);
            ConsList scopes = (ConsList)this.edges.getOrDefault(key, ConsList.nil());
            this.edges.__put(key, scopes.prepend(targetScope));
            this.labels.__insert(label);
            return true;
        }

        @Override
        public boolean setDatum(S scope, D datum) {
            this.data.__put(scope, datum);
            return true;
        }

        @Override
        public boolean addAll(IScopeGraph<S, L, D> other) {
            for (Map.Entry<Map.Entry<S, L>, Collection<S>> entry : other.getEdges().entrySet()) {
                Tuple2<S, L> key = Tuple2.of(entry.getKey());
                Iterable otherScopes = entry.getValue();
                ConsList scopes = (ConsList)this.edges.getOrDefault(key, ConsList.nil());
                ConsList mergedScopes = scopes.prepend(ConsList.of(otherScopes));
                this.edges.__put(Tuple2.of(key), mergedScopes);
            }
            for (Map.Entry<Map.Entry<Object, Object>, Collection<Object>> entry : other.getData().entrySet()) {
                this.data.__put(entry.getKey(), entry.getValue());
            }
            for (Object object : other.getLabels()) {
                this.labels.__insert(object);
            }
            return true;
        }

        @Override
        public Immutable<S, L, D> freeze() {
            return new Immutable(this.labels.freeze(), this.edges.freeze(), this.data.freeze());
        }

        public static <S, L, D> Transient<S, L, D> of() {
            return new Transient(CapsuleUtil.transientSet(), CapsuleUtil.transientMap(), Map.Transient.of());
        }
    }
}

