/*
 * Decompiled with CFR 0.152.
 */
package mb.scopegraph.oopsla20.diff;

import io.usethesource.capsule.Map;
import io.usethesource.capsule.Set;
import io.usethesource.capsule.util.stream.CapsuleCollectors;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Collectors;
import mb.scopegraph.oopsla20.IScopeGraph;
import mb.scopegraph.oopsla20.diff.DifferState;
import mb.scopegraph.oopsla20.diff.Edge;
import mb.scopegraph.oopsla20.diff.ScopeGraphDiff;
import mb.scopegraph.oopsla20.diff.ScopeGraphDifferOps;
import mb.scopegraph.oopsla20.diff.ScopeGraphStatusOps;
import mb.scopegraph.oopsla20.reference.EdgeOrData;
import org.metaborg.util.collection.BiMap;
import org.metaborg.util.collection.CapsuleUtil;
import org.metaborg.util.collection.MultiSetMap;
import org.metaborg.util.functions.Function1;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;
import org.metaborg.util.tuple.Tuple2;
import org.metaborg.util.unit.Unit;

public class ScopeGraphDiffer<S, L, D> {
    private static final ILogger logger = LoggerUtils.logger(ScopeGraphDiffer.class);
    private final IScopeGraph.Immutable<S, L, D> previous;
    private final ScopeGraphDifferOps<S, D> diffOps;
    private final ScopeGraphStatusOps<S, L> statusOps;

    private ScopeGraphDiffer(IScopeGraph.Immutable<S, L, D> previous, ScopeGraphDifferOps<S, D> diffOps, ScopeGraphStatusOps<S, L> statusOps) {
        this.previous = previous;
        this.diffOps = diffOps;
        this.statusOps = statusOps;
    }

    public DifferState.Immutable<S, L, D> initDiff(S s0current, S s0previous) {
        DifferState.Transient state = DifferState.Transient.of();
        if (!this.statusOps.closed(s0current, EdgeOrData.data())) {
            throw new IllegalStateException("Current root scope must be closed for data when initializing differ");
        }
        Optional matches = this.canScopesMatch(state, BiMap.Immutable.of(s0current, s0previous));
        if (!matches.isPresent()) {
            throw new IllegalStateException("Cannot match root scopes");
        }
        state.putAllMatchedScopes(matches.get());
        this.statusOps.allLabels(s0current).forEach(lbl -> state.edgeDelays().put(s0current, lbl));
        return state.freeze();
    }

    public DifferState.Immutable<S, L, D> doDiff(IScopeGraph.Immutable<S, L, D> current, DifferState.Immutable<S, L, D> initialState, MultiSetMap<S, EdgeOrData<L>> activations) {
        DifferState.Transient<S, L, D> state = initialState.melt();
        LinkedList<EdgeMatch> worklist = new LinkedList<EdgeMatch>();
        activations.forEach((scope, label) -> {
            this.assertClosed((S)scope, (EdgeOrData<L>)label);
            label.match(() -> {
                state.dataDelays().removeValues(scope).forEach(removedDelay -> {
                    if (!state.dataDelays().containsValue(removedDelay)) {
                        Object currentScope = removedDelay._1();
                        if (state.matchedScopes().containsKey(currentScope)) {
                            Object previousScope = state.matchedScopes().getKey(currentScope);
                            worklist.addAll(this.scheduleMatches(current, state, currentScope, previousScope, removedDelay._2()));
                        } else {
                            logger.trace("Activating yet unmatched scope {}", currentScope);
                        }
                    }
                });
                return Unit.unit;
            }, l -> {
                if (state.matchedScopes().containsKey(scope)) {
                    Object previousScope = state.matchedScopes().getKey(scope);
                    worklist.addAll(this.scheduleMatches(current, state, scope, previousScope, l));
                } else {
                    logger.trace("Activating yet unmatched scope {}", scope);
                }
                return Unit.unit;
            });
        });
        while (!worklist.isEmpty()) {
            EdgeMatch m = (EdgeMatch)worklist.remove();
            logger.trace("Processing match {}", m);
            worklist.addAll(this.matchEdge(current, state, m.currentEdge, m.previousEdges));
        }
        return state.freeze();
    }

    private Tuple2<Boolean, Queue<EdgeMatch>> matchScopes(IScopeGraph.Immutable<S, L, D> current, DifferState.Transient<S, L, D> state, BiMap.Immutable<S> scopes) {
        state.seenCurrentScopes().__insertAll(scopes.keySet());
        state.seenPreviousScopes().__insertAll(scopes.valueSet());
        BiMap newMatches = this.canScopesMatch(state, scopes).orElse(null);
        if (newMatches == null) {
            return Tuple2.of(false, new LinkedList());
        }
        state.putAllMatchedScopes(newMatches);
        LinkedList<EdgeMatch> newEdgeMatches = new LinkedList<EdgeMatch>();
        for (Map.Entry entry : newMatches.entrySet()) {
            Object currentScope = entry.getKey();
            Object previousScope = entry.getValue();
            for (L label : this.statusOps.allLabels(currentScope)) {
                if (this.statusOps.closed(currentScope, EdgeOrData.edge(label))) {
                    newEdgeMatches.addAll(this.scheduleMatches(current, state, currentScope, previousScope, label));
                    continue;
                }
                logger.trace("Delaying matching of ({}, {})", currentScope, label);
                state.edgeDelays().put(currentScope, label);
            }
        }
        logger.trace("Matching {} succeeded, sceduling {}", scopes, newEdgeMatches);
        return Tuple2.of(true, newEdgeMatches);
    }

    private Queue<EdgeMatch> scheduleMatches(IScopeGraph.Immutable<S, L, D> current, DifferState.Transient<S, L, D> state, S currentScope, S previousScope, L label) {
        this.assertClosed(currentScope, EdgeOrData.data());
        Optional currentData = current.getData(currentScope);
        currentData.ifPresent(d -> {
            boolean bl = state.seenCurrentScopes().__insertAll(this.diffOps.getCurrentScopes(d));
        });
        Optional previousData = this.previous.getData(previousScope);
        previousData.ifPresent(d -> {
            boolean bl = state.seenPreviousScopes().__insertAll(this.diffOps.getPreviousScopes(d));
        });
        this.assertClosed(currentScope, EdgeOrData.edge(label));
        return this.scheduleEdgeMatches(current, state, currentScope, previousScope, label);
    }

    private Optional<BiMap.Immutable<S>> canScopesMatch(DifferState.Transient<S, L, D> state, BiMap.Immutable<S> scopes) {
        BiMap.Transient<S> newMatches = BiMap.Transient.of();
        for (Map.Entry<S, S> entry : scopes.entrySet()) {
            S previousScope;
            S currentScope = entry.getKey();
            if (!this.diffOps.isMatchAllowed(currentScope, previousScope = entry.getValue())) {
                return Optional.empty();
            }
            if (!state.canPutMatchedScope(currentScope, previousScope)) {
                return Optional.empty();
            }
            if (state.containsMatchedScopes(currentScope, previousScope)) continue;
            newMatches.put(currentScope, previousScope);
        }
        return Optional.of(newMatches.freeze());
    }

    private Queue<EdgeMatch> scheduleEdgeMatches(IScopeGraph.Immutable<S, L, D> current, DifferState.Transient<S, L, D> state, S currentSource, S previousSource, L label) {
        Set.Immutable currentEdges = (Set.Immutable)current.getEdges(currentSource, label).stream().map(currentTarget -> new Edge<Object, Object>(currentSource, label, currentTarget)).collect(CapsuleCollectors.toSet());
        state.seenCurrentEdges().__insertAll((Set)currentEdges);
        Collection scopeDelays = currentEdges.stream().filter(edge -> !this.statusOps.closed(edge.target, EdgeOrData.data())).map(edge -> edge.target).collect(Collectors.toSet());
        if (!scopeDelays.isEmpty()) {
            logger.trace("Delay matching of ({}, {}) because some target data is not yet set", currentSource, label);
            scopeDelays.forEach(s -> state.dataDelays().put(s, Tuple2.of(currentSource, label)));
            return new LinkedList<EdgeMatch>();
        }
        Set.Immutable previousEdges = (Set.Immutable)this.previous.getEdges(previousSource, label).stream().map(previousTarget -> new Edge<Object, Object>(previousSource, label, previousTarget)).collect(CapsuleCollectors.toSet());
        state.seenPreviousEdges().__insertAll((Set)previousEdges);
        LinkedList<EdgeMatch> newMatches = new LinkedList<EdgeMatch>();
        for (Edge currentEdge : currentEdges) {
            Map.Transient matchingPreviousEdges = CapsuleUtil.transientMap();
            for (Edge previousEdge : previousEdges) {
                BiMap.Immutable req = this.matchScopes(current, currentEdge.target, previousEdge.target).orElse(null);
                if (req == null || !this.canScopesMatch(state, req).isPresent()) continue;
                matchingPreviousEdges.__put((Object)previousEdge, (Object)req);
            }
            EdgeMatch match = new EdgeMatch(currentEdge, matchingPreviousEdges.freeze());
            logger.trace("Scheduling {}", match);
            newMatches.add(match);
        }
        return newMatches;
    }

    private Queue<EdgeMatch> matchEdge(IScopeGraph.Immutable<S, L, D> current, DifferState.Transient<S, L, D> state, Edge<S, L> currentEdge, Map.Immutable<Edge<S, L>, BiMap.Immutable<S>> previousEdges) {
        for (Map.Entry previousEdge : previousEdges.entrySet()) {
            Tuple2<Boolean, Queue<EdgeMatch>> matchResult = this.matchScopes(current, state, (BiMap.Immutable)previousEdge.getValue());
            if (!matchResult._1().booleanValue()) continue;
            state.putMatchedEdge(currentEdge, (Edge)previousEdge.getKey());
            return matchResult._2();
        }
        return new LinkedList<EdgeMatch>();
    }

    private Optional<BiMap.Immutable<S>> matchScopes(IScopeGraph.Immutable<S, L, D> current, S currentScope, S previousScope) {
        BiMap.Transient _matches = BiMap.Transient.of();
        if (!this.scopeMatch(current, currentScope, previousScope, _matches)) {
            return Optional.empty();
        }
        BiMap.Immutable matches = _matches.freeze();
        return Optional.of(matches);
    }

    private boolean scopeMatch(IScopeGraph.Immutable<S, L, D> current, S currentScope, S previousScope, BiMap.Transient<S> req) {
        if (!this.diffOps.isMatchAllowed(currentScope, previousScope)) {
            return false;
        }
        if (!req.canPut(currentScope, previousScope)) {
            return false;
        }
        if (req.containsEntry(currentScope, previousScope)) {
            return true;
        }
        req.put(currentScope, previousScope);
        Optional currentData = current.getData(currentScope);
        Optional previousData = this.previous.getData(previousScope);
        if (currentData.isPresent() != previousData.isPresent()) {
            return false;
        }
        return !currentData.isPresent() || !previousData.isPresent() || this.diffOps.matchDatums(currentData.get(), previousData.get(), (leftScope, rightScope) -> this.scopeMatch(current, leftScope, rightScope, req));
    }

    public ScopeGraphDiff<S, L, D> finalize(IScopeGraph.Immutable<S, L, D> current, DifferState.Immutable<S, L, D> initialState) {
        DifferState.Transient<S, L, D> state = initialState.melt();
        Map.Transient addedScopes = CapsuleUtil.transientMap();
        Set.Transient addedEdges = CapsuleUtil.transientSet();
        this.finishDiff(current, (Function1<D, Set<S>>)((Function1<Object, Set>)this.diffOps::getCurrentScopes), (Collection<S>)state.seenCurrentScopes(), (Collection<Edge<S, L>>)state.seenCurrentEdges(), state.matchedScopes().keySet(), state.matchedEdges().keySet(), (Map.Transient<S, D>)addedScopes, (Set.Transient<Edge<S, L>>)addedEdges);
        Map.Transient removedScopes = CapsuleUtil.transientMap();
        Set.Transient removedEdges = CapsuleUtil.transientSet();
        this.finishDiff(this.previous, (Function1<D, Set<S>>)((Function1<Object, Set>)this.diffOps::getPreviousScopes), (Collection<S>)state.seenPreviousScopes(), (Collection<Edge<S, L>>)state.seenPreviousEdges(), state.matchedScopes().valueSet(), state.matchedEdges().valueSet(), (Map.Transient<S, D>)removedScopes, (Set.Transient<Edge<S, L>>)removedEdges);
        ScopeGraphDiff diff = new ScopeGraphDiff(state.matchedScopes().freeze(), state.matchedEdges().freeze(), addedScopes.freeze(), addedEdges.freeze(), removedScopes.freeze(), removedEdges.freeze());
        return diff;
    }

    /*
     * Exception decompiling
     */
    private void finishDiff(IScopeGraph<S, L, D> scopeGraph, Function1<D, Set<S>> getScopes, Collection<S> seenScopes, Collection<Edge<S, L>> seenEdges, Set<S> matchedScopes, Set<Edge<S, L>> matchedEdges, Map.Transient<S, D> missedScopes, Set.Transient<Edge<S, L>> missedEdges) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundSuperForBase(org.benf.cfr.reader.bytecode.analysis.types.JavaTypeInstance)" because "bindingSuperContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.LoopLivenessClash.getIterableIterType(LoopLivenessClash.java:35)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.LoopLivenessClash.detect(LoopLivenessClash.java:66)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.LoopLivenessClash.detect(LoopLivenessClash.java:25)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:827)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void assertClosed(S scope, EdgeOrData<L> label) {
        if (!this.statusOps.closed(scope, label)) {
            throw new IllegalStateException("Activating (" + scope + ", " + label + ") while it has not been closed yet");
        }
    }

    public static <S, L, D> ScopeGraphDiff<S, L, D> fullDiff(S s0current, S s0previous, IScopeGraph.Immutable<S, L, D> current, IScopeGraph.Immutable<S, L, D> previous, ScopeGraphDifferOps<S, D> diffOps) {
        FinalizedStatusOps statusOps = new FinalizedStatusOps(Set.Immutable.union(current.getLabels(), previous.getLabels()));
        ScopeGraphDiffer<S, L, D> differ = new ScopeGraphDiffer<S, L, D>(previous, diffOps, statusOps);
        DifferState.Immutable<S, L, D> initialState = differ.initDiff(s0current, s0previous);
        MultiSetMap.Transient initialActivations = MultiSetMap.Transient.of();
        initialState.edgeDelays().forEach((s, l) -> {
            int n = initialActivations.put(s, EdgeOrData.edge(l));
        });
        DifferState.Immutable<S, L, D> state = differ.doDiff(current, initialState, initialActivations);
        return differ.finalize(current, state);
    }

    public static <S, L, D> ScopeGraphDiffer<S, L, D> of(IScopeGraph.Immutable<S, L, D> previous, ScopeGraphDifferOps<S, D> diffOps, ScopeGraphStatusOps<S, L> statusOps) {
        return new ScopeGraphDiffer<S, L, D>(previous, diffOps, statusOps);
    }

    private class EdgeMatch
    implements Comparable<EdgeMatch> {
        public final Edge<S, L> currentEdge;
        public final Map.Immutable<Edge<S, L>, BiMap.Immutable<S>> previousEdges;

        public EdgeMatch(Edge<S, L> currentEdge, Map.Immutable<Edge<S, L>, BiMap.Immutable<S>> previousEdges) {
            this.currentEdge = currentEdge;
            this.previousEdges = previousEdges;
        }

        @Override
        public int compareTo(EdgeMatch that) {
            return this.previousEdges.size() - that.previousEdges.size();
        }

        public String toString() {
            return this.currentEdge + " ~ " + this.previousEdges;
        }
    }

    private static class FinalizedStatusOps<S, L>
    implements ScopeGraphStatusOps<S, L> {
        private final Set.Immutable<L> labels;

        public FinalizedStatusOps(Set.Immutable<L> labels) {
            this.labels = labels;
        }

        @Override
        public boolean closed(S scope, EdgeOrData<L> label) {
            return true;
        }

        @Override
        public Collection<L> allLabels(S scope) {
            return this.labels;
        }
    }
}

