/*
 * Decompiled with CFR 0.152.
 */
package mb.resource.hierarchical.walk;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import mb.resource.hierarchical.HierarchicalResource;
import mb.resource.hierarchical.match.path.PathMatcher;
import mb.resource.hierarchical.walk.AllResourceWalker;
import mb.resource.hierarchical.walk.AnyResourceWalker;
import mb.resource.hierarchical.walk.FalseResourceWalker;
import mb.resource.hierarchical.walk.NotResourceWalker;
import mb.resource.hierarchical.walk.PathResourceWalker;
import mb.resource.hierarchical.walk.TrueResourceWalker;

@FunctionalInterface
public interface ResourceWalker
extends Serializable {
    public boolean traverse(HierarchicalResource var1, HierarchicalResource var2) throws IOException;

    public static TrueResourceWalker ofTrue() {
        return new TrueResourceWalker();
    }

    public static FalseResourceWalker ofFalse() {
        return new FalseResourceWalker();
    }

    public static AllResourceWalker ofAll(ResourceWalker ... walkers) {
        return new AllResourceWalker(walkers);
    }

    public static AnyResourceWalker ofAny(ResourceWalker ... walkers) {
        return new AnyResourceWalker(walkers);
    }

    public static NotResourceWalker ofNot(ResourceWalker walkers) {
        return new NotResourceWalker(walkers);
    }

    public static PathResourceWalker ofPath(PathMatcher matcher) {
        return new PathResourceWalker(matcher);
    }

    default public NotResourceWalker not() {
        return new NotResourceWalker(this);
    }

    default public AllResourceWalker and(ResourceWalker ... walkers) {
        ArrayList<ResourceWalker> allWalkers = new ArrayList<ResourceWalker>(walkers.length + 1);
        allWalkers.add(this);
        Collections.addAll(allWalkers, walkers);
        return new AllResourceWalker(allWalkers);
    }

    default public AnyResourceWalker or(ResourceWalker ... walkers) {
        ArrayList<ResourceWalker> anyWalkers = new ArrayList<ResourceWalker>(walkers.length + 1);
        anyWalkers.add(this);
        Collections.addAll(anyWalkers, walkers);
        return new AnyResourceWalker(anyWalkers);
    }

    public static PathResourceWalker ofNoHidden() {
        return ResourceWalker.ofPath(PathMatcher.ofNoHidden());
    }
}

