/*
 * Decompiled with CFR 0.152.
 */
package mb.pie.api.stamp.resource;

import java.io.IOException;
import java.util.Objects;
import mb.pie.api.stamp.ResourceStamper;
import mb.pie.api.stamp.resource.Modified;
import mb.pie.api.stamp.resource.ValueResourceStamp;
import mb.resource.hierarchical.HierarchicalResource;
import mb.resource.hierarchical.match.ResourceMatcher;
import mb.resource.hierarchical.walk.ResourceWalker;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ModifiedWalkResourceStamper
implements ResourceStamper<HierarchicalResource> {
    private final @Nullable ResourceWalker walker;
    private final @Nullable ResourceMatcher matcher;

    public ModifiedWalkResourceStamper(ResourceWalker walker, ResourceMatcher matcher) {
        this.walker = walker;
        this.matcher = matcher;
    }

    public ModifiedWalkResourceStamper() {
        this.walker = null;
        this.matcher = null;
    }

    @Override
    public ValueResourceStamp<HierarchicalResource> stamp(HierarchicalResource resource) throws IOException {
        long modified = Modified.modifiedRec(resource, this.walker, this.matcher);
        return new ValueResourceStamp<HierarchicalResource>(Long.valueOf(modified), this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModifiedWalkResourceStamper that = (ModifiedWalkResourceStamper)o;
        if (!Objects.equals(this.walker, that.walker)) {
            return false;
        }
        return Objects.equals(this.matcher, that.matcher);
    }

    public int hashCode() {
        int result = this.walker != null ? this.walker.hashCode() : 0;
        result = 31 * result + (this.matcher != null ? this.matcher.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ModifiedWalkResourceStamper(" + this.walker + ")";
    }
}

