/*
 * Decompiled with CFR 0.152.
 */
package mb.pie.api;

import java.io.Serializable;
import java.util.Objects;
import mb.pie.api.ExecContext;
import mb.pie.api.Function;
import mb.pie.api.TaskDef;
import mb.pie.api.TaskDefs;
import org.checkerframework.checker.nullness.qual.Nullable;

public class STaskDef<I extends Serializable, O extends @Nullable Serializable>
implements Function<I, O>,
Serializable {
    public final String id;

    public STaskDef(TaskDef<I, O> taskDef) {
        this.id = taskDef.getId();
    }

    public STaskDef(String id) {
        this.id = id;
    }

    public TaskDef<I, O> toTaskDef(TaskDefs taskDefs) {
        @Nullable TaskDef<?, ?> taskDef = taskDefs.getTaskDef(this.id);
        if (taskDef == null) {
            throw new RuntimeException("Cannot get task definition for id " + this.id + "; task definition with that id does not exist");
        }
        return taskDef;
    }

    @Override
    public O apply(ExecContext context, I input) {
        return context.require(this, input);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        STaskDef sTaskDef = (STaskDef)o;
        return this.id.equals(sTaskDef.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return this.id;
    }
}

