/*
 * Decompiled with CFR 0.152.
 */
package mb.pie.api;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import mb.pie.api.ExecContext;
import mb.pie.api.Supplier;
import mb.pie.api.stamp.ResourceStamper;
import mb.resource.ReadableResource;
import mb.resource.ResourceKey;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ResourceStringSupplier
implements Supplier<String> {
    public final ResourceKey key;
    public final @Nullable ResourceStamper<ReadableResource> stamper;
    public final String charsetName;
    private transient Charset charset;

    public ResourceStringSupplier(ResourceKey key, @Nullable ResourceStamper<ReadableResource> stamper, Charset charset) {
        this.key = key;
        this.stamper = stamper;
        this.charsetName = charset.name();
        this.charset = charset;
    }

    public ResourceStringSupplier(ResourceKey key, @Nullable ResourceStamper<ReadableResource> stamper) {
        this(key, stamper, StandardCharsets.UTF_8);
    }

    public ResourceStringSupplier(ResourceKey key, Charset charset) {
        this(key, null, charset);
    }

    public ResourceStringSupplier(ResourceKey key) {
        this(key, (ResourceStamper<ReadableResource>)null);
    }

    @Override
    public String get(ExecContext context) {
        try {
            return context.require(this.key, this.stamper != null ? this.stamper : context.getDefaultRequireReadableResourceStamper()).readString(this.charset);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceStringSupplier that = (ResourceStringSupplier)o;
        return this.key.equals(that.key) && Objects.equals(this.stamper, that.stamper) && this.charset.equals(that.charset);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.stamper, this.charset);
    }

    public String toString() {
        return "ResourceStringSupplier{key=" + this.key + ", stamper=" + this.stamper + ", charset=" + this.charset + '}';
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.charset = Charset.forName(this.charsetName);
    }
}

