/*
 * Decompiled with CFR 0.152.
 */
package mb.pie.api;

import java.io.Serializable;
import java.util.function.BiFunction;
import java.util.function.Function;
import mb.pie.api.ExecContext;
import mb.pie.api.TaskDef;
import org.checkerframework.checker.nullness.qual.Nullable;

public class LambdaTaskDef<I extends Serializable, @Nullable O extends Serializable>
implements TaskDef<I, O> {
    private final String id;
    private final BiFunction<ExecContext, I, O> execFunc;
    private final @Nullable Function<I, Serializable> keyFunc;
    private final @Nullable BiFunction<I, Integer, String> descFunc;

    public LambdaTaskDef(String id, BiFunction<ExecContext, I, O> execFunc) {
        this(id, execFunc, null, null);
    }

    public LambdaTaskDef(String id, BiFunction<ExecContext, I, O> execFunc, @Nullable Function<I, Serializable> keyFunc) {
        this(id, execFunc, keyFunc, null);
    }

    public LambdaTaskDef(String id, BiFunction<ExecContext, I, O> execFunc, @Nullable Function<I, Serializable> keyFunc, @Nullable BiFunction<I, Integer, String> descFunc) {
        this.id = id;
        this.execFunc = execFunc;
        this.keyFunc = keyFunc;
        this.descFunc = descFunc;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public O exec(ExecContext context, I input) {
        return (O)((Serializable)this.execFunc.apply(context, input));
    }

    @Override
    public Serializable key(I input) {
        if (this.keyFunc != null) {
            return this.keyFunc.apply(input);
        }
        return TaskDef.super.key(input);
    }

    @Override
    public String desc(I input, int maxLength) {
        if (this.descFunc != null) {
            return this.descFunc.apply(input, maxLength);
        }
        return TaskDef.super.desc(input, maxLength);
    }
}

