/*
 * Decompiled with CFR 0.152.
 */
package mb.p_raffrayi.impl.tokens;

import java.util.ArrayList;
import java.util.Objects;
import mb.p_raffrayi.actors.IActorRef;
import mb.p_raffrayi.impl.IUnit;
import mb.p_raffrayi.impl.tokens.AInitScope;

public final class InitScope<S, L, D>
extends AInitScope<S, L, D> {
    private final IActorRef<? extends IUnit<S, L, D, ?>> origin;
    private final S scope;
    private final transient int hashCode;

    private InitScope(IActorRef<? extends IUnit<S, L, D, ?>> origin, S scope) {
        this.origin = Objects.requireNonNull(origin, "origin");
        this.scope = Objects.requireNonNull(scope, "scope");
        this.hashCode = this.computeHashCode();
    }

    private InitScope(InitScope<S, L, D> original, IActorRef<? extends IUnit<S, L, D, ?>> origin, S scope) {
        this.origin = origin;
        this.scope = scope;
        this.hashCode = this.computeHashCode();
    }

    @Override
    public IActorRef<? extends IUnit<S, L, D, ?>> origin() {
        return this.origin;
    }

    @Override
    public S scope() {
        return this.scope;
    }

    public final InitScope<S, L, D> withOrigin(IActorRef<? extends IUnit<S, L, D, ?>> value) {
        if (this.origin == value) {
            return this;
        }
        IActorRef<? extends IUnit<S, L, D, ?>> newValue = Objects.requireNonNull(value, "origin");
        return new InitScope<S, L, D>(this, newValue, this.scope);
    }

    public final InitScope<S, L, D> withScope(S value) {
        if (this.scope == value) {
            return this;
        }
        S newValue = Objects.requireNonNull(value, "scope");
        return new InitScope<S, L, D>(this, this.origin, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof InitScope && this.equalTo(0, (InitScope)another);
    }

    private boolean equalTo(int synthetic, InitScope<?, ?, ?> another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return this.origin.equals(another.origin) && this.scope.equals(another.scope);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.origin.hashCode();
        h += (h << 5) + this.scope.hashCode();
        return h;
    }

    public String toString() {
        return "InitScope{origin=" + this.origin + ", scope=" + this.scope + "}";
    }

    public static <S, L, D> InitScope<S, L, D> of(IActorRef<? extends IUnit<S, L, D, ?>> origin, S scope) {
        return new InitScope<S, L, D>(origin, scope);
    }

    public static <S, L, D> InitScope<S, L, D> copyOf(AInitScope<S, L, D> instance) {
        if (instance instanceof InitScope) {
            return (InitScope)instance;
        }
        return InitScope.builder().from(instance).build();
    }

    public static <S, L, D> Builder<S, L, D> builder() {
        return new Builder();
    }

    /* synthetic */ InitScope(InitScope initScope, IActorRef iActorRef, Object object, InitScope initScope2) {
        this(initScope, iActorRef, object);
    }

    public static final class Builder<S, L, D> {
        private static final long INIT_BIT_ORIGIN = 1L;
        private static final long INIT_BIT_SCOPE = 2L;
        private long initBits = 3L;
        private IActorRef<? extends IUnit<S, L, D, ?>> origin;
        private S scope;

        private Builder() {
        }

        public final Builder<S, L, D> from(AInitScope<S, L, D> instance) {
            Objects.requireNonNull(instance, "instance");
            this.origin(instance.origin());
            this.scope(instance.scope());
            return this;
        }

        public final Builder<S, L, D> origin(IActorRef<? extends IUnit<S, L, D, ?>> origin) {
            this.origin = Objects.requireNonNull(origin, "origin");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder<S, L, D> scope(S scope) {
            this.scope = Objects.requireNonNull(scope, "scope");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public InitScope<S, L, D> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new InitScope(null, this.origin, this.scope, null);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("origin");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("scope");
            }
            return "Cannot build InitScope, some of required attributes are not set " + attributes;
        }
    }
}

