/*
 * Decompiled with CFR 0.152.
 */
package mb.p_raffrayi.impl;

import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import mb.p_raffrayi.IRecordedQuery;
import mb.p_raffrayi.IUnitResult;
import mb.p_raffrayi.IUnitStats;
import mb.p_raffrayi.impl.AUnitResult;
import mb.scopegraph.oopsla20.IScopeGraph;
import mb.scopegraph.oopsla20.diff.ScopeGraphDiff;

public final class UnitResult<S, L, D, R>
extends AUnitResult<S, L, D, R>
implements Serializable {
    private final String id;
    private final IScopeGraph.Immutable<S, L, D> scopeGraph;
    private final Set<IRecordedQuery<S, L, D>> queries;
    private final List<S> rootScopes;
    private final Set<S> scopes;
    @Nullable
    private final R result;
    @Nullable
    private final ScopeGraphDiff<S, L, D> diff;
    private final List<Throwable> failures;
    private final Map<String, IUnitResult<S, L, D, ?>> subUnitResults;
    @Nullable
    private final IUnitStats stats;
    private final IUnitResult.TransitionTrace stateTransitionTrace;
    private transient int hashCode;
    private volatile transient long lazyInitBitmap;
    private static final long ALL_FAILURES_LAZY_INIT_BIT = 1L;
    private transient List<Throwable> allFailures;
    private static final long serialVersionUID = 42L;

    private UnitResult(String id, IScopeGraph.Immutable<S, L, D> scopeGraph, Iterable<? extends IRecordedQuery<S, L, D>> queries, Iterable<? extends S> rootScopes, Iterable<? extends S> scopes, @Nullable R result, Iterable<? extends Throwable> failures, Map<String, ? extends IUnitResult<S, L, D, ?>> subUnitResults, @Nullable IUnitStats stats) {
        this.id = Objects.requireNonNull(id, "id");
        this.scopeGraph = Objects.requireNonNull(scopeGraph, "scopeGraph");
        this.queries = UnitResult.createUnmodifiableSet(UnitResult.createSafeList(queries, true, false));
        this.rootScopes = UnitResult.createUnmodifiableList(false, UnitResult.createSafeList(rootScopes, true, false));
        this.scopes = UnitResult.createUnmodifiableSet(UnitResult.createSafeList(scopes, true, false));
        this.result = result;
        this.failures = UnitResult.createUnmodifiableList(false, UnitResult.createSafeList(failures, true, false));
        this.subUnitResults = UnitResult.createUnmodifiableMap(true, false, subUnitResults);
        this.stats = stats;
        this.diff = null;
        this.stateTransitionTrace = Objects.requireNonNull(super.stateTransitionTrace(), "stateTransitionTrace");
    }

    private UnitResult(Builder<S, L, D, R> builder) {
        this.id = ((Builder)builder).id;
        this.scopeGraph = ((Builder)builder).scopeGraph;
        this.queries = UnitResult.createUnmodifiableSet(((Builder)builder).queries);
        this.rootScopes = UnitResult.createUnmodifiableList(true, ((Builder)builder).rootScopes);
        this.scopes = UnitResult.createUnmodifiableSet(((Builder)builder).scopes);
        this.result = ((Builder)builder).result;
        this.diff = ((Builder)builder).diff;
        this.failures = UnitResult.createUnmodifiableList(true, ((Builder)builder).failures);
        this.subUnitResults = UnitResult.createUnmodifiableMap(false, false, ((Builder)builder).subUnitResults);
        this.stats = ((Builder)builder).stats;
        this.stateTransitionTrace = ((Builder)builder).stateTransitionTrace != null ? ((Builder)builder).stateTransitionTrace : Objects.requireNonNull(super.stateTransitionTrace(), "stateTransitionTrace");
    }

    private UnitResult(String id, IScopeGraph.Immutable<S, L, D> scopeGraph, Set<IRecordedQuery<S, L, D>> queries, List<S> rootScopes, Set<S> scopes, @Nullable R result, @Nullable ScopeGraphDiff<S, L, D> diff, List<Throwable> failures, Map<String, IUnitResult<S, L, D, ?>> subUnitResults, @Nullable IUnitStats stats, IUnitResult.TransitionTrace stateTransitionTrace) {
        this.id = id;
        this.scopeGraph = scopeGraph;
        this.queries = queries;
        this.rootScopes = rootScopes;
        this.scopes = scopes;
        this.result = result;
        this.diff = diff;
        this.failures = failures;
        this.subUnitResults = subUnitResults;
        this.stats = stats;
        this.stateTransitionTrace = stateTransitionTrace;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public IScopeGraph.Immutable<S, L, D> scopeGraph() {
        return this.scopeGraph;
    }

    @Override
    public Set<IRecordedQuery<S, L, D>> queries() {
        return this.queries;
    }

    @Override
    public List<S> rootScopes() {
        return this.rootScopes;
    }

    @Override
    public Set<S> scopes() {
        return this.scopes;
    }

    @Override
    @Nullable
    public R result() {
        return this.result;
    }

    @Override
    @Nullable
    public ScopeGraphDiff<S, L, D> diff() {
        return this.diff;
    }

    @Override
    public List<Throwable> failures() {
        return this.failures;
    }

    @Override
    public Map<String, IUnitResult<S, L, D, ?>> subUnitResults() {
        return this.subUnitResults;
    }

    @Override
    @Nullable
    public IUnitStats stats() {
        return this.stats;
    }

    @Override
    public IUnitResult.TransitionTrace stateTransitionTrace() {
        return this.stateTransitionTrace;
    }

    public final UnitResult<S, L, D, R> withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new UnitResult<S, L, D, R>(newValue, this.scopeGraph, this.queries, this.rootScopes, this.scopes, this.result, this.diff, this.failures, this.subUnitResults, this.stats, this.stateTransitionTrace);
    }

    public final UnitResult<S, L, D, R> withScopeGraph(IScopeGraph.Immutable<S, L, D> value) {
        if (this.scopeGraph == value) {
            return this;
        }
        IScopeGraph.Immutable<S, L, D> newValue = Objects.requireNonNull(value, "scopeGraph");
        return new UnitResult<S, L, D, R>(this.id, newValue, this.queries, this.rootScopes, this.scopes, this.result, this.diff, this.failures, this.subUnitResults, this.stats, this.stateTransitionTrace);
    }

    @SafeVarargs
    public final UnitResult<S, L, D, R> withQueries(IRecordedQuery<S, L, D> ... elements) {
        Set<IRecordedQuery<S, L, D>> newValue = UnitResult.createUnmodifiableSet(UnitResult.createSafeList(Arrays.asList(elements), true, false));
        return new UnitResult<S, L, D, R>(this.id, this.scopeGraph, newValue, this.rootScopes, this.scopes, this.result, this.diff, this.failures, this.subUnitResults, this.stats, this.stateTransitionTrace);
    }

    public final UnitResult<S, L, D, R> withQueries(Iterable<? extends IRecordedQuery<S, L, D>> elements) {
        if (this.queries == elements) {
            return this;
        }
        Set<IRecordedQuery<S, L, D>> newValue = UnitResult.createUnmodifiableSet(UnitResult.createSafeList(elements, true, false));
        return new UnitResult<S, L, D, R>(this.id, this.scopeGraph, newValue, this.rootScopes, this.scopes, this.result, this.diff, this.failures, this.subUnitResults, this.stats, this.stateTransitionTrace);
    }

    @SafeVarargs
    public final UnitResult<S, L, D, R> withRootScopes(S ... elements) {
        List<S> newValue = UnitResult.createUnmodifiableList(false, UnitResult.createSafeList(Arrays.asList(elements), true, false));
        return new UnitResult<S, L, D, R>(this.id, this.scopeGraph, this.queries, newValue, this.scopes, this.result, this.diff, this.failures, this.subUnitResults, this.stats, this.stateTransitionTrace);
    }

    public final UnitResult<S, L, D, R> withRootScopes(Iterable<? extends S> elements) {
        if (this.rootScopes == elements) {
            return this;
        }
        List<? extends S> newValue = UnitResult.createUnmodifiableList(false, UnitResult.createSafeList(elements, true, false));
        return new UnitResult<S, L, D, R>(this.id, this.scopeGraph, this.queries, newValue, this.scopes, this.result, this.diff, this.failures, this.subUnitResults, this.stats, this.stateTransitionTrace);
    }

    @SafeVarargs
    public final UnitResult<S, L, D, R> withScopes(S ... elements) {
        Set<S> newValue = UnitResult.createUnmodifiableSet(UnitResult.createSafeList(Arrays.asList(elements), true, false));
        return new UnitResult<S, L, D, R>(this.id, this.scopeGraph, this.queries, this.rootScopes, newValue, this.result, this.diff, this.failures, this.subUnitResults, this.stats, this.stateTransitionTrace);
    }

    public final UnitResult<S, L, D, R> withScopes(Iterable<? extends S> elements) {
        if (this.scopes == elements) {
            return this;
        }
        Set<? extends S> newValue = UnitResult.createUnmodifiableSet(UnitResult.createSafeList(elements, true, false));
        return new UnitResult<S, L, D, R>(this.id, this.scopeGraph, this.queries, this.rootScopes, newValue, this.result, this.diff, this.failures, this.subUnitResults, this.stats, this.stateTransitionTrace);
    }

    public final UnitResult<S, L, D, R> withResult(@Nullable R value) {
        if (this.result == value) {
            return this;
        }
        return new UnitResult<S, L, D, R>(this.id, this.scopeGraph, this.queries, this.rootScopes, this.scopes, value, this.diff, this.failures, this.subUnitResults, this.stats, this.stateTransitionTrace);
    }

    public final UnitResult<S, L, D, R> withDiff(@Nullable ScopeGraphDiff<S, L, D> value) {
        if (this.diff == value) {
            return this;
        }
        return new UnitResult<S, L, D, R>(this.id, this.scopeGraph, this.queries, this.rootScopes, this.scopes, this.result, value, this.failures, this.subUnitResults, this.stats, this.stateTransitionTrace);
    }

    public final UnitResult<S, L, D, R> withFailures(Throwable ... elements) {
        List<Throwable> newValue = UnitResult.createUnmodifiableList(false, UnitResult.createSafeList(Arrays.asList(elements), true, false));
        return new UnitResult<S, L, D, R>(this.id, this.scopeGraph, this.queries, this.rootScopes, this.scopes, this.result, this.diff, newValue, this.subUnitResults, this.stats, this.stateTransitionTrace);
    }

    public final UnitResult<S, L, D, R> withFailures(Iterable<? extends Throwable> elements) {
        if (this.failures == elements) {
            return this;
        }
        List<Throwable> newValue = UnitResult.createUnmodifiableList(false, UnitResult.createSafeList(elements, true, false));
        return new UnitResult<S, L, D, R>(this.id, this.scopeGraph, this.queries, this.rootScopes, this.scopes, this.result, this.diff, newValue, this.subUnitResults, this.stats, this.stateTransitionTrace);
    }

    public final UnitResult<S, L, D, R> withSubUnitResults(Map<String, ? extends IUnitResult<S, L, D, ?>> entries) {
        if (this.subUnitResults == entries) {
            return this;
        }
        Map<String, IUnitResult<S, L, D, ?>> newValue = UnitResult.createUnmodifiableMap(true, false, entries);
        return new UnitResult<S, L, D, R>(this.id, this.scopeGraph, this.queries, this.rootScopes, this.scopes, this.result, this.diff, this.failures, newValue, this.stats, this.stateTransitionTrace);
    }

    public final UnitResult<S, L, D, R> withStats(@Nullable IUnitStats value) {
        if (this.stats == value) {
            return this;
        }
        return new UnitResult<S, L, D, R>(this.id, this.scopeGraph, this.queries, this.rootScopes, this.scopes, this.result, this.diff, this.failures, this.subUnitResults, value, this.stateTransitionTrace);
    }

    public final UnitResult<S, L, D, R> withStateTransitionTrace(IUnitResult.TransitionTrace value) {
        IUnitResult.TransitionTrace newValue = Objects.requireNonNull(value, "stateTransitionTrace");
        if (this.stateTransitionTrace == newValue) {
            return this;
        }
        return new UnitResult<S, L, D, R>(this.id, this.scopeGraph, this.queries, this.rootScopes, this.scopes, this.result, this.diff, this.failures, this.subUnitResults, this.stats, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof UnitResult && this.equalTo(0, (UnitResult)another);
    }

    private boolean equalTo(int synthetic, UnitResult<?, ?, ?, ?> another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.id.equals(another.id) && this.scopeGraph.equals(another.scopeGraph) && this.queries.equals(another.queries) && this.rootScopes.equals(another.rootScopes) && this.scopes.equals(another.scopes) && Objects.equals(this.result, another.result) && this.failures.equals(another.failures) && this.subUnitResults.equals(another.subUnitResults) && Objects.equals(this.stats, another.stats) && this.stateTransitionTrace.equals((Object)another.stateTransitionTrace);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.scopeGraph.hashCode();
        h += (h << 5) + this.queries.hashCode();
        h += (h << 5) + this.rootScopes.hashCode();
        h += (h << 5) + this.scopes.hashCode();
        h += (h << 5) + Objects.hashCode(this.result);
        h += (h << 5) + this.failures.hashCode();
        h += (h << 5) + this.subUnitResults.hashCode();
        h += (h << 5) + Objects.hashCode(this.stats);
        h += (h << 5) + this.stateTransitionTrace.hashCode();
        return h;
    }

    public String toString() {
        return "UnitResult{id=" + this.id + ", scopeGraph=" + this.scopeGraph + ", queries=" + this.queries + ", rootScopes=" + this.rootScopes + ", scopes=" + this.scopes + ", result=" + this.result + ", failures=" + this.failures + ", subUnitResults=" + this.subUnitResults + ", stats=" + this.stats + ", stateTransitionTrace=" + (Object)((Object)this.stateTransitionTrace) + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Throwable> allFailures() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            UnitResult unitResult = this;
            synchronized (unitResult) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.allFailures = Objects.requireNonNull(super.allFailures(), "allFailures");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.allFailures;
    }

    public static <S, L, D, R> UnitResult<S, L, D, R> of(String id, IScopeGraph.Immutable<S, L, D> scopeGraph, Set<IRecordedQuery<S, L, D>> queries, List<S> rootScopes, Set<S> scopes, @Nullable R result, List<Throwable> failures, Map<String, IUnitResult<S, L, D, ?>> subUnitResults, @Nullable IUnitStats stats) {
        return UnitResult.of(id, scopeGraph, queries, rootScopes, scopes, result, failures, subUnitResults, stats);
    }

    public static <S, L, D, R> UnitResult<S, L, D, R> of(String id, IScopeGraph.Immutable<S, L, D> scopeGraph, Iterable<? extends IRecordedQuery<S, L, D>> queries, Iterable<? extends S> rootScopes, Iterable<? extends S> scopes, @Nullable R result, Iterable<? extends Throwable> failures, Map<String, ? extends IUnitResult<S, L, D, ?>> subUnitResults, @Nullable IUnitStats stats) {
        return new UnitResult<S, L, D, R>(id, scopeGraph, queries, rootScopes, scopes, result, failures, subUnitResults, stats);
    }

    public static <S, L, D, R> UnitResult<S, L, D, R> copyOf(AUnitResult<S, L, D, R> instance) {
        if (instance instanceof UnitResult) {
            return (UnitResult)instance;
        }
        return UnitResult.builder().from(instance).build();
    }

    public static <S, L, D, R> Builder<S, L, D, R> builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <T> Set<T> createUnmodifiableSet(List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>(list.size() * 4 / 3 + 1);
        set.addAll(list);
        return Collections.unmodifiableSet(set);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    /* synthetic */ UnitResult(Builder builder, UnitResult unitResult) {
        this(builder);
    }

    public static final class Builder<S, L, D, R> {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_SCOPE_GRAPH = 2L;
        private long initBits = 3L;
        private String id;
        private IScopeGraph.Immutable<S, L, D> scopeGraph;
        private List<IRecordedQuery<S, L, D>> queries = new ArrayList<IRecordedQuery<S, L, D>>();
        private List<S> rootScopes = new ArrayList<S>();
        private List<S> scopes = new ArrayList<S>();
        private R result;
        private ScopeGraphDiff<S, L, D> diff;
        private List<Throwable> failures = new ArrayList<Throwable>();
        private Map<String, IUnitResult<S, L, D, ?>> subUnitResults = new LinkedHashMap();
        private IUnitStats stats;
        private IUnitResult.TransitionTrace stateTransitionTrace;

        private Builder() {
        }

        public final Builder<S, L, D, R> from(AUnitResult<S, L, D, R> instance) {
            ScopeGraphDiff<S, L, D> diffValue;
            Objects.requireNonNull(instance, "instance");
            this.id(instance.id());
            this.scopeGraph(instance.scopeGraph());
            this.addAllQueries(instance.queries());
            this.addAllRootScopes(instance.rootScopes());
            this.addAllScopes(instance.scopes());
            R resultValue = instance.result();
            if (resultValue != null) {
                this.result(resultValue);
            }
            if ((diffValue = instance.diff()) != null) {
                this.diff(diffValue);
            }
            this.addAllFailures(instance.failures());
            this.putAllSubUnitResults(instance.subUnitResults());
            IUnitStats statsValue = instance.stats();
            if (statsValue != null) {
                this.stats(statsValue);
            }
            this.stateTransitionTrace(instance.stateTransitionTrace());
            return this;
        }

        public final Builder<S, L, D, R> id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder<S, L, D, R> scopeGraph(IScopeGraph.Immutable<S, L, D> scopeGraph) {
            this.scopeGraph = Objects.requireNonNull(scopeGraph, "scopeGraph");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder<S, L, D, R> addQueries(IRecordedQuery<S, L, D> element) {
            this.queries.add(Objects.requireNonNull(element, "queries element"));
            return this;
        }

        @SafeVarargs
        public final Builder<S, L, D, R> addQueries(IRecordedQuery<S, L, D> ... elements) {
            IRecordedQuery<S, L, D>[] iRecordedQueryArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IRecordedQuery<S, L, D> element = iRecordedQueryArray[n2];
                this.queries.add(Objects.requireNonNull(element, "queries element"));
                ++n2;
            }
            return this;
        }

        public final Builder<S, L, D, R> queries(Iterable<? extends IRecordedQuery<S, L, D>> elements) {
            this.queries.clear();
            return this.addAllQueries(elements);
        }

        public final Builder<S, L, D, R> addAllQueries(Iterable<? extends IRecordedQuery<S, L, D>> elements) {
            for (IRecordedQuery<S, L, D> element : elements) {
                this.queries.add(Objects.requireNonNull(element, "queries element"));
            }
            return this;
        }

        public final Builder<S, L, D, R> addRootScopes(S element) {
            this.rootScopes.add(Objects.requireNonNull(element, "rootScopes element"));
            return this;
        }

        @SafeVarargs
        public final Builder<S, L, D, R> addRootScopes(S ... elements) {
            S[] SArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                S element = SArray[n2];
                this.rootScopes.add(Objects.requireNonNull(element, "rootScopes element"));
                ++n2;
            }
            return this;
        }

        public final Builder<S, L, D, R> rootScopes(Iterable<? extends S> elements) {
            this.rootScopes.clear();
            return this.addAllRootScopes(elements);
        }

        public final Builder<S, L, D, R> addAllRootScopes(Iterable<? extends S> elements) {
            for (S element : elements) {
                this.rootScopes.add(Objects.requireNonNull(element, "rootScopes element"));
            }
            return this;
        }

        public final Builder<S, L, D, R> addScopes(S element) {
            this.scopes.add(Objects.requireNonNull(element, "scopes element"));
            return this;
        }

        @SafeVarargs
        public final Builder<S, L, D, R> addScopes(S ... elements) {
            S[] SArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                S element = SArray[n2];
                this.scopes.add(Objects.requireNonNull(element, "scopes element"));
                ++n2;
            }
            return this;
        }

        public final Builder<S, L, D, R> scopes(Iterable<? extends S> elements) {
            this.scopes.clear();
            return this.addAllScopes(elements);
        }

        public final Builder<S, L, D, R> addAllScopes(Iterable<? extends S> elements) {
            for (S element : elements) {
                this.scopes.add(Objects.requireNonNull(element, "scopes element"));
            }
            return this;
        }

        public final Builder<S, L, D, R> result(@Nullable R result) {
            this.result = result;
            return this;
        }

        public final Builder<S, L, D, R> diff(@Nullable ScopeGraphDiff<S, L, D> diff) {
            this.diff = diff;
            return this;
        }

        public final Builder<S, L, D, R> addFailures(Throwable element) {
            this.failures.add(Objects.requireNonNull(element, "failures element"));
            return this;
        }

        public final Builder<S, L, D, R> addFailures(Throwable ... elements) {
            Throwable[] throwableArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Throwable element = throwableArray[n2];
                this.failures.add(Objects.requireNonNull(element, "failures element"));
                ++n2;
            }
            return this;
        }

        public final Builder<S, L, D, R> failures(Iterable<? extends Throwable> elements) {
            this.failures.clear();
            return this.addAllFailures(elements);
        }

        public final Builder<S, L, D, R> addAllFailures(Iterable<? extends Throwable> elements) {
            for (Throwable throwable : elements) {
                this.failures.add(Objects.requireNonNull(throwable, "failures element"));
            }
            return this;
        }

        public final Builder<S, L, D, R> putSubUnitResults(String key, IUnitResult<S, L, D, ?> value) {
            this.subUnitResults.put(Objects.requireNonNull(key, "subUnitResults key"), Objects.requireNonNull(value, value == null ? "subUnitResults value for key: " + key : null));
            return this;
        }

        public final Builder<S, L, D, R> putSubUnitResults(Map.Entry<String, ? extends IUnitResult<S, L, D, ?>> entry) {
            IUnitResult<S, L, D, ?> v;
            String k = entry.getKey();
            this.subUnitResults.put(Objects.requireNonNull(k, "subUnitResults key"), Objects.requireNonNull(v, (v = entry.getValue()) == null ? "subUnitResults value for key: " + k : null));
            return this;
        }

        public final Builder<S, L, D, R> subUnitResults(Map<String, ? extends IUnitResult<S, L, D, ?>> entries) {
            this.subUnitResults.clear();
            return this.putAllSubUnitResults(entries);
        }

        public final Builder<S, L, D, R> putAllSubUnitResults(Map<String, ? extends IUnitResult<S, L, D, ?>> entries) {
            for (Map.Entry<String, IUnitResult<S, L, D, ?>> e : entries.entrySet()) {
                IUnitResult<S, L, D, ?> v;
                String k = e.getKey();
                this.subUnitResults.put(Objects.requireNonNull(k, "subUnitResults key"), Objects.requireNonNull(v, (v = e.getValue()) == null ? "subUnitResults value for key: " + k : null));
            }
            return this;
        }

        public final Builder<S, L, D, R> stats(@Nullable IUnitStats stats) {
            this.stats = stats;
            return this;
        }

        public final Builder<S, L, D, R> stateTransitionTrace(IUnitResult.TransitionTrace stateTransitionTrace) {
            this.stateTransitionTrace = Objects.requireNonNull(stateTransitionTrace, "stateTransitionTrace");
            return this;
        }

        public UnitResult<S, L, D, R> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new UnitResult(this, null);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("scopeGraph");
            }
            return "Cannot build UnitResult, some of required attributes are not set " + attributes;
        }
    }
}

