/*
 * Decompiled with CFR 0.152.
 */
package mb.p_raffrayi.impl;

import io.usethesource.capsule.Set;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.metaborg.util.collection.CapsuleUtil;
import org.metaborg.util.collection.MultiSetMap;
import org.metaborg.util.collection.SetMultimap;
import org.metaborg.util.collection.Sets;

public class DeadlockUtils {
    private DeadlockUtils() {
    }

    public static <V> boolean connectedToAll(V vertex, IGraph<V> graph) {
        return DeadlockUtils.reachableVertices(vertex, graph).size() == graph.vertices().size();
    }

    public static <V> boolean allConnectedTo(V vertex, IGraph<V> graph) {
        return DeadlockUtils.reachableVertices(vertex, graph.invert()).size() == graph.vertices().size();
    }

    public static <V> Set<Set<V>> sccs(IGraph<V> graph) {
        SetMultimap reachables = new SetMultimap();
        HashSet<V> vertices = new HashSet<V>(graph.vertices());
        for (Object vertex : vertices) {
            reachables.putAll(vertex, DeadlockUtils.reachableVertices(vertex, graph));
        }
        HashSet<Set<V>> sccs = new HashSet<Set<V>>();
        block1: while (!vertices.isEmpty()) {
            Object currentVertex = vertices.iterator().next();
            Set currentTargets = (Set)reachables.get(currentVertex);
            for (Object other : currentTargets) {
                Set otherTargets;
                if (other == currentVertex || (otherTargets = (Set)reachables.get(other)).contains(currentVertex)) continue;
                vertices.removeAll(Sets.difference(currentTargets, otherTargets));
                continue block1;
            }
            sccs.add(currentTargets);
            vertices.removeAll(currentTargets);
        }
        return sccs;
    }

    public static <V> Set<V> reachableVertices(V vertex, IGraph<V> graph) {
        LinkedList<V> queue = new LinkedList<V>();
        HashSet<V> reachable = new HashSet<V>();
        queue.add(vertex);
        reachable.add(vertex);
        while (!queue.isEmpty()) {
            Object head = queue.remove();
            for (V target : graph.targets(head)) {
                if (reachable.contains(target)) continue;
                queue.add(target);
                reachable.add(target);
            }
        }
        return reachable;
    }

    private static class Graph<V>
    implements IGraph<V> {
        private final Set.Immutable<V> vertices;
        private final MultiSetMap.Immutable<V, V> edges;

        public Graph(Set.Immutable<V> vertices, MultiSetMap.Immutable<V, V> edges) {
            this.edges = edges;
            this.vertices = vertices;
        }

        @Override
        public Collection<V> vertices() {
            return this.vertices;
        }

        @Override
        public Collection<V> targets(V vertex) {
            return this.edges.get(vertex).toCollection();
        }

        @Override
        public IGraph<V> invert() {
            GraphBuilder builder = GraphBuilder.of();
            this.vertices.forEach(builder::addVertex);
            this.edges.forEach((from, to) -> {
                GraphBuilder<Object> graphBuilder2 = builder.addEdge(to, from);
            });
            return builder.build();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Graph{");
            for (Object vertex : this.vertices) {
                sb.append("  ").append(vertex).append(":\n");
                for (Object tgt : this.edges.get(vertex)) {
                    sb.append("    ").append(tgt).append("\n");
                }
            }
            return sb.append("}").toString();
        }
    }

    public static class GraphBuilder<V> {
        private Set.Transient<V> vertices = CapsuleUtil.transientSet();
        private MultiSetMap.Transient<V, V> edges = MultiSetMap.Transient.of();

        private GraphBuilder() {
        }

        public static <V> GraphBuilder<V> of() {
            return new GraphBuilder<V>();
        }

        public GraphBuilder<V> addVertex(V vertex) {
            this.vertices.__insert(vertex);
            return this;
        }

        public GraphBuilder<V> addEdge(V source, V target) {
            this.addVertex(source);
            this.addVertex(target);
            this.edges.put(source, target);
            return this;
        }

        public IGraph<V> build() {
            return new Graph<V>(this.vertices.freeze(), this.edges.freeze());
        }
    }

    public static interface IGraph<V> {
        public Collection<V> vertices();

        public Collection<V> targets(V var1);

        public IGraph<V> invert();
    }
}

