/*
 * Decompiled with CFR 0.152.
 */
package mb.p_raffrayi.impl;

import io.usethesource.capsule.Set;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mb.p_raffrayi.DeadlockException;
import mb.p_raffrayi.IScopeImpl;
import mb.p_raffrayi.ITypeChecker;
import mb.p_raffrayi.IUnitResult;
import mb.p_raffrayi.PRaffrayiSettings;
import mb.p_raffrayi.actors.IActor;
import mb.p_raffrayi.actors.IActorRef;
import mb.p_raffrayi.actors.TypeTag;
import mb.p_raffrayi.actors.deadlock.ChandyMisraHaas;
import mb.p_raffrayi.actors.impl.ActorSystem;
import mb.p_raffrayi.actors.impl.IActorScheduler;
import mb.p_raffrayi.impl.BrokerProcess;
import mb.p_raffrayi.impl.IDeadlockProtocol;
import mb.p_raffrayi.impl.IProcess;
import mb.p_raffrayi.impl.IUnit;
import mb.p_raffrayi.impl.IUnitContext;
import mb.p_raffrayi.impl.Result;
import mb.p_raffrayi.impl.StateSummary;
import mb.p_raffrayi.impl.TypeCheckerUnit;
import mb.p_raffrayi.impl.UnitProcess;
import org.metaborg.util.collection.BiMap;
import org.metaborg.util.collection.CapsuleUtil;
import org.metaborg.util.collection.MultiSet;
import org.metaborg.util.functions.Action0;
import org.metaborg.util.functions.Function0;
import org.metaborg.util.functions.Function2;
import org.metaborg.util.future.CompletableFuture;
import org.metaborg.util.future.ICompletable;
import org.metaborg.util.future.ICompletableFuture;
import org.metaborg.util.future.IFuture;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;
import org.metaborg.util.task.ICancel;
import org.metaborg.util.task.IProgress;
import org.metaborg.util.tuple.Tuple2;

public class Broker<S, L, D, R extends ITypeChecker.IOutput<S, L, D>, T extends ITypeChecker.IState<S, L, D>>
implements ChandyMisraHaas.Host<IProcess<S, L, D>>,
IDeadlockProtocol<S, L, D> {
    private static final ILogger logger = LoggerUtils.logger(Broker.class);
    private static final int INACTIVE_TIMEOUT = 5;
    private final String id;
    private final PRaffrayiSettings settings;
    private final ITypeChecker<S, L, D, R, T> typeChecker;
    private final boolean rootChanged;
    @Nullable
    private final IUnitResult<S, L, D, Result<S, L, D, R, T>> previousResult;
    private final IScopeImpl<S, D> scopeImpl;
    private final Set<L> edgeLabels;
    private final ICancel cancel;
    private final IProgress progress;
    private final IActorScheduler scheduler;
    private final ActorSystem system;
    private final Map<String, IActorRef<? extends IUnit<S, L, D, ?>>> units;
    private final AtomicInteger unfinishedUnits;
    private final AtomicInteger totalUnits;
    private final Map<String, ICompletableFuture<IActorRef<? extends IUnit<S, L, D, ?>>>> delays;
    private final ReentrantLock lock = new ReentrantLock();
    private final BrokerProcess<S, L, D> process;
    private ChandyMisraHaas<IProcess<S, L, D>> cmh;
    private AtomicReference<MultiSet.Immutable<IProcess<S, L, D>>> dependentSet = new AtomicReference(MultiSet.Immutable.of());
    private static final Pattern RE_ID_SEG = Pattern.compile("\\/(?:\\\\\\\\|\\\\\\/|[^\\\\\\/])+");

    private Broker(String id, PRaffrayiSettings settings, ITypeChecker<S, L, D, R, T> typeChecker, IScopeImpl<S, D> scopeImpl, Iterable<L> edgeLabels, boolean rootChanged, @Nullable IUnitResult<S, L, D, Result<S, L, D, R, T>> previousResult, ICancel cancel, IProgress progress, IActorScheduler scheduler) {
        this.id = id;
        this.settings = settings;
        this.typeChecker = typeChecker;
        this.rootChanged = rootChanged;
        if (previousResult != null) {
            if (!previousResult.allFailures().isEmpty()) {
                logger.warn("Initial state contains failures, discarding it.");
                for (Throwable ex : previousResult.allFailures()) {
                    logger.debug("* ", ex);
                }
                this.previousResult = null;
            } else {
                this.previousResult = previousResult;
            }
        } else {
            this.previousResult = null;
        }
        this.scopeImpl = scopeImpl;
        this.edgeLabels = CapsuleUtil.toSet(edgeLabels);
        this.cancel = cancel;
        this.progress = progress;
        this.scheduler = scheduler;
        this.system = new ActorSystem(scheduler);
        this.units = new HashMap();
        this.unfinishedUnits = new AtomicInteger();
        this.totalUnits = new AtomicInteger();
        this.delays = new HashMap();
        this.process = BrokerProcess.of();
        this.cmh = new ChandyMisraHaas(this, this::_deadlocked);
    }

    private IFuture<IUnitResult<S, L, D, Result<S, L, D, R, T>>> run() {
        IActorRef unit = this.system.add(this.id, (TypeTag)TypeTag.of(IUnit.class), self -> new TypeCheckerUnit<S, L, D, R, T>(self, null, new UnitContext(self), this.typeChecker, this.edgeLabels, this.previousResult == null || this.rootChanged, this.previousResult));
        this.addUnit(unit);
        IFuture unitResult = ((IUnit)this.system.async(unit))._start(Collections.emptyList());
        IFuture<IUnitResult<S, L, D, Result<S, L, D, R, T>>> runResult = unitResult.compose((arg_0, arg_1) -> this.lambda$2((IActor)unit, arg_0, arg_1));
        this.startWatcherThread();
        return runResult;
    }

    private void addUnit(IActorRef<? extends IUnit<S, L, D, ?>> unit) {
        this.unfinishedUnits.incrementAndGet();
        this.totalUnits.incrementAndGet();
        ICompletable future = this.executeCritial(() -> {
            this.units.put(unit.id(), unit);
            return this.delays.remove(unit.id());
        });
        if (future != null) {
            future.complete(unit);
        }
    }

    private void finalizeUnit(IActorRef<? extends IUnit<S, L, D, ?>> unit, Throwable ex) {
        this.progress.work(1);
        String event = ex != null ? "failed" : "finished";
        logger.info("Unit {} {} ({} of {} remaining).", event, unit.id(), this.unfinishedUnits.decrementAndGet(), this.totalUnits.get());
    }

    private void startWatcherThread() {
        AtomicInteger inactive = new AtomicInteger();
        Thread watcher = new Thread(() -> {
            try {
                while (true) {
                    if (!this.system.running()) {
                        return;
                    }
                    if (this.cancel.cancelled()) {
                        this.system.cancel();
                        return;
                    }
                    if (!this.scheduler.isActive()) {
                        if (inactive.incrementAndGet() >= 5) {
                            logger.error("Deadlock detected.");
                            this.system.cancel();
                            return;
                        }
                        logger.error("Potential deadlock...");
                    } else if (inactive.getAndSet(0) != 0) {
                        logger.error("False deadlock.");
                    }
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }, "PRaffrayiWatcher");
        watcher.start();
    }

    private IFuture<IActorRef<? extends IUnit<S, L, D, ?>>> getActorRef(String unitId) {
        Matcher idMatcher = RE_ID_SEG.matcher(unitId);
        ArrayList<String> segments = new ArrayList<String>();
        while (idMatcher.find()) {
            segments.add(idMatcher.group());
        }
        return this.executeCritial(() -> this.getActorRef(segments));
    }

    private IFuture<IActorRef<? extends IUnit<S, L, D, ?>>> getActorRef(List<String> segments) {
        String unitId = String.join((CharSequence)"", segments);
        if (segments.isEmpty()) {
            throw new IllegalStateException("Invalid unit id.");
        }
        IActorRef<? extends IUnit<S, L, D, ?>> unit = this.units.get(unitId);
        if (unit != null) {
            return CompletableFuture.completedFuture(unit);
        }
        segments.remove(segments.size() - 1);
        return this.getActorRef(segments).thenCompose(parent -> this.executeCritial(() -> {
            UnitProcess origin = new UnitProcess(parent);
            this.dependentSet.getAndUpdate(ds -> ds.add(origin, 1));
            ICompletableFuture future = this.delays.computeIfAbsent(unitId, key -> new CompletableFuture());
            return future.whenComplete((ref, ex) -> this.executeCritial(() -> this.dependentSet.getAndUpdate(ds -> ds.remove(origin, 1))));
        }));
    }

    @Override
    public void _deadlocked(Set<IProcess<S, L, D>> nodes) {
        HashMap<String, ICompletableFuture> delays = new HashMap<String, ICompletableFuture>();
        this.executeCritial(() -> {
            delays.putAll(this.delays);
            this.dependentSet.set(MultiSet.Immutable.of());
            this.cmh.exec();
        });
        delays.forEach((unit, future) -> future.completeExceptionally(new DeadlockException("Deadlocked while waiting for unit " + unit + " to be added.")));
    }

    @Override
    public void _deadlockQuery(IProcess<S, L, D> i, int m, IProcess<S, L, D> k) {
        this.executeCritial(() -> this.cmh.query(i, m, k));
    }

    @Override
    public void _deadlockReply(IProcess<S, L, D> i, int m, Set<IProcess<S, L, D>> R2) {
        this.executeCritial(() -> this.cmh.reply(i, m, R2));
    }

    @Override
    public IFuture<StateSummary<S, L, D>> _state() {
        return CompletableFuture.completedFuture(StateSummary.restart(this.process, this.dependentSet()));
    }

    @Override
    public void _release() {
        logger.error("Trying to release broker.");
        throw new IllegalStateException("Cannot release broker.");
    }

    @Override
    public void _restart() {
    }

    @Override
    public IProcess<S, L, D> process() {
        return this.process;
    }

    @Override
    public Set<IProcess<S, L, D>> dependentSet() {
        return this.executeCritial(() -> this.dependentSet.get().elementSet());
    }

    @Override
    public void query(IProcess<S, L, D> k, IProcess<S, L, D> i, int m) {
        k.from(this)._deadlockQuery(i, m, this.process);
    }

    @Override
    public void reply(IProcess<S, L, D> k, IProcess<S, L, D> i, int m, Set<IProcess<S, L, D>> R2) {
        k.from(this)._deadlockReply(i, m, R2);
    }

    @Override
    public void assertOnActorThread() {
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalStateException("Broker lock is not held by current Thread.");
        }
    }

    public IDeadlockProtocol<S, L, D> deadlock(IActorRef<? extends IDeadlockProtocol<S, L, D>> unit) {
        return this.system.async(unit);
    }

    private void executeCritial(Action0 action) {
        this.lock.lock();
        try {
            action.apply();
        }
        finally {
            this.lock.unlock();
        }
    }

    private <Q> Q executeCritial(Function0<Q> action) {
        this.lock.lock();
        try {
            Q q = action.apply();
            return q;
        }
        finally {
            this.lock.unlock();
        }
    }

    public static <S, L, D, R extends ITypeChecker.IOutput<S, L, D>, T extends ITypeChecker.IState<S, L, D>> IFuture<IUnitResult<S, L, D, Result<S, L, D, R, T>>> run(String id, PRaffrayiSettings settings, ITypeChecker<S, L, D, R, T> unitChecker, IScopeImpl<S, D> scopeImpl, Iterable<L> edgeLabels, ICancel cancel, IProgress progress) {
        return Broker.run(id, settings, unitChecker, scopeImpl, edgeLabels, true, null, cancel, progress, Runtime.getRuntime().availableProcessors());
    }

    public static <S, L, D, R extends ITypeChecker.IOutput<S, L, D>, T extends ITypeChecker.IState<S, L, D>> IFuture<IUnitResult<S, L, D, Result<S, L, D, R, T>>> run(String id, PRaffrayiSettings settings, ITypeChecker<S, L, D, R, T> unitChecker, IScopeImpl<S, D> scopeImpl, Iterable<L> edgeLabels, boolean changed, IUnitResult<S, L, D, Result<S, L, D, R, T>> previousResult, ICancel cancel, IProgress progress) {
        return Broker.run(id, settings, unitChecker, scopeImpl, edgeLabels, changed, previousResult, cancel, progress, Runtime.getRuntime().availableProcessors());
    }

    public static <S, L, D, R extends ITypeChecker.IOutput<S, L, D>, T extends ITypeChecker.IState<S, L, D>> IFuture<IUnitResult<S, L, D, Result<S, L, D, R, T>>> run(String id, PRaffrayiSettings settings, ITypeChecker<S, L, D, R, T> typeChecker, IScopeImpl<S, D> scopeImpl, Iterable<L> edgeLabels, boolean changed, IUnitResult<S, L, D, Result<S, L, D, R, T>> previousResult, ICancel cancel, IProgress progress, int parallelism) {
        return super.run();
    }

    public static <S, L, D, R extends ITypeChecker.IOutput<S, L, D>, T extends ITypeChecker.IState<S, L, D>> IFuture<IUnitResult<S, L, D, Result<S, L, D, R, T>>> debug(String id, PRaffrayiSettings settings, ITypeChecker<S, L, D, R, T> typeChecker, IScopeImpl<S, D> scopeImpl, Iterable<L> edgeLabels, ICancel cancel, double preemptProbability, int scheduleDelayBoundMillis) {
        return Broker.debug(id, settings, typeChecker, scopeImpl, edgeLabels, true, null, cancel, Runtime.getRuntime().availableProcessors(), preemptProbability, scheduleDelayBoundMillis);
    }

    public static <S, L, D, R extends ITypeChecker.IOutput<S, L, D>, T extends ITypeChecker.IState<S, L, D>> IFuture<IUnitResult<S, L, D, Result<S, L, D, R, T>>> debug(String id, PRaffrayiSettings settings, ITypeChecker<S, L, D, R, T> typeChecker, IScopeImpl<S, D> scopeImpl, Iterable<L> edgeLabels, boolean changed, IUnitResult<S, L, D, Result<S, L, D, R, T>> previousResult, ICancel cancel, double preemptProbability, int scheduleDelayBoundMillis) {
        return Broker.debug(id, settings, typeChecker, scopeImpl, edgeLabels, changed, previousResult, cancel, Runtime.getRuntime().availableProcessors(), preemptProbability, scheduleDelayBoundMillis);
    }

    public static <S, L, D, R extends ITypeChecker.IOutput<S, L, D>, T extends ITypeChecker.IState<S, L, D>> IFuture<IUnitResult<S, L, D, Result<S, L, D, R, T>>> debug(String id, PRaffrayiSettings settings, ITypeChecker<S, L, D, R, T> typeChecker, IScopeImpl<S, D> scopeImpl, Iterable<L> edgeLabels, boolean changed, IUnitResult<S, L, D, Result<S, L, D, R, T>> previousResult, ICancel cancel, int parallelism, double preemptProbability, int scheduleDelayBoundMillis) {
        return super.run();
    }

    private /* synthetic */ IFuture lambda$2(IActor iActor, IUnitResult r, Throwable ex) throws Throwable {
        this.finalizeUnit(iActor, ex);
        return this.system.stop().compose((r2, ex2) -> CompletableFuture.completed(r, ex));
    }

    private class UnitContext
    implements IUnitContext<S, L, D> {
        private final IActor<? extends IUnit<S, L, D, ?>> self;

        public UnitContext(IActor<? extends IUnit<S, L, D, ?>> self) {
            this.self = self;
        }

        @Override
        public ICancel cancel() {
            return Broker.this.cancel;
        }

        @Override
        public PRaffrayiSettings settings() {
            return Broker.this.settings;
        }

        @Override
        public S makeScope(String name) {
            return Broker.this.scopeImpl.make(this.self.id(), name);
        }

        @Override
        public String scopeId(S scope) {
            return Broker.this.scopeImpl.id(scope);
        }

        @Override
        public D substituteScopes(D datum, BiMap.Immutable<S> substitution) {
            return Broker.this.scopeImpl.substituteScopes(datum, substitution.asMap());
        }

        @Override
        public Set.Immutable<S> getScopes(D datum) {
            return Broker.this.scopeImpl.getScopes(datum);
        }

        @Override
        public D embed(S scope) {
            return Broker.this.scopeImpl.embed(scope);
        }

        @Override
        public Optional<BiMap.Immutable<S>> matchDatums(D currentDatum, D previousDatum) {
            return Broker.this.scopeImpl.matchDatums(currentDatum, previousDatum);
        }

        @Override
        public IFuture<IActorRef<? extends IUnit<S, L, D, ?>>> owner(S scope) {
            String id = Broker.this.scopeImpl.id(scope);
            IActorRef unit = (IActorRef)Broker.this.units.get(id);
            if (unit != null) {
                return CompletableFuture.completedFuture(unit);
            }
            return (IFuture)Broker.this.executeCritial(() -> {
                Broker.this.cmh.exec();
                IFuture result = Broker.this.getActorRef(id);
                Broker.this.cmh.idle();
                return result;
            });
        }

        @Override
        public <U> Tuple2<IFuture<IUnitResult<S, L, D, U>>, IActorRef<? extends IUnit<S, L, D, U>>> add(String id, Function2<IActor<IUnit<S, L, D, U>>, IUnitContext<S, L, D>, IUnit<S, L, D, U>> unitProvider, List<S> rootScopes) {
            return (Tuple2)Broker.this.executeCritial(() -> {
                Broker.this.cmh.exec();
                IActorRef<IUnit> unit = this.self.add(id, TypeTag.of(IUnit.class), (IActor<U> subself) -> (IUnit)unitProvider.apply((IActor)subself, new UnitContext(subself)));
                Broker.this.addUnit(unit);
                IFuture unitResult = this.self.async(unit)._start(rootScopes);
                unitResult.whenComplete((r, ex) -> Broker.this.finalizeUnit(unit, ex));
                Broker.this.cmh.idle();
                return Tuple2.of(unitResult, unit);
            });
        }

        @Override
        public int parallelism() {
            return Broker.this.scheduler.parallelism();
        }

        @Override
        public IDeadlockProtocol<S, L, D> deadlock() {
            return Broker.this;
        }
    }
}

